# -*- encoding: utf-8 -*-
=begin
=図鑑_人物データ設定セクション by nwapeg

図鑑の人物の項に表示する内容を設定します。
解説のスクロールを実装した際に、制御文字の描画が不可能になりました。

==更新履歴
Date     Version Author Comment
14/11/30 0.3.0   トリス CG閲覧を追加
13/07/20 0.2.1   Foo    画像の拡縮率を可能に
13/07/20 0.2.0   Foo    画像にX,Y調整値指定可能に
                        解説から固有アビリティに変更
12/06/09 0.1.1   nwapeg 画像指定追加
12/06/08 0.1.0   nwapeg 試作

=end

#==============================================================================
# ■ NWConst::Library
#==============================================================================
module NWConst::Library

  # アクター画像の設定
  # パス,ファイル名,色相,X調整値,Y調整値,拡縮率で記述します。
  # X座標の基準点は中央,Y座標の基準点は最下部です。
  # X調整値に値が設定された時点で自動縮小機能がOFFになります。
  # 色相以降の設定値は省略可能です。(デフォルト値:色相=0,X調整値=0,Y調整値=0,拡縮率=1.00)
  ACTOR_IMAGE = {
    1 => ["Graphics/Pictures/", "80_ruka_st01",0,20,0,0.9],
    2 => ["Graphics/Pictures/", "80_ruka_st31",0,0,-20,0.9],
    3 => ["Graphics/Pictures/", "80_ruka_st21",0,0,-20,0.9],
    4 => ["Graphics/Pictures/", "80_ruka_st99",0,0,-20,0.9],
    5 => ["Graphics/Pictures/", "80_alice_st71",0,0,0],
    6 => ["Graphics/Pictures/", "80_alice_st01",0,0,-20,0.9],
    7 => ["Graphics/Pictures/", "80_alice_st51b",0,0,20,0.8],
    9 => ["Graphics/Pictures/", "80_worldbreaker_st01",0,0,-40,0.9],
    10 => ["Graphics/Pictures/", "80_judgement_st01",0,0,-20,0.9],
    12 => ["Graphics/Pictures/", "80_sylph_st01",0,0,-20,0.9],
    13 => ["Graphics/Pictures/", "80_gnome_st01",0,0,0,0.9],
    14 => ["Graphics/Pictures/", "80_undine_st01",0,0,-20,0.9],
    15 => ["Graphics/Pictures/", "80_salamander_st01",0,0,-20,0.9],
    16 => ["Graphics/Pictures/", "80_granberia_st61",0,0,-20,0.8],
    17 => ["Graphics/Pictures/", "80_granberia_st71",0,0,-20,0.8],
    19 => ["Graphics/Pictures/", "80_arumaeruma_st61",0,0,-20,0.8],
    21 => ["Graphics/Pictures/", "80_tamamo_st01",0,0,-20,0.9],
    22 => ["Graphics/Pictures/", "80_tamamo_st51",0,0,-20,0.9],
    23 => ["Graphics/Pictures/", "80_erbetie_st01",0,0,-20,0.9],
    24 => ["Graphics/Pictures/", "80_erbetie_st14",0,0,-20,0.9],
    26 => ["Graphics/Pictures/", "80_iriasu_st31",0,0,0,0.8],
    27 => ["Graphics/Pictures/", "80_iriasu_st01",0,0,-20,0.9],
    28 => ["Graphics/Pictures/", "80_iriasu2_st01",0,0,-20,0.9],
    29 => ["Graphics/Pictures/", "80_iriasu_st41",0,0,-20,0.9],
    30 => ["Graphics/Pictures/", "80_iriasu3_st01",0,0,-20,1.0],
    32 => ["Graphics/Pictures/", "80_micaela_st31",0,0,-20,0.9],
    33 => ["Graphics/Pictures/", "80_micaela_st41",0,0,-20,0.9],
    34 => ["Graphics/Pictures/", "80_micaelac_st01",0,-30,-20,0.9],
    35 => ["Graphics/Pictures/", "80_rucyfina_st21",0,0,-20,0.9],
    36 => ["Graphics/Pictures/", "80_rucyfinac_st01",0,0,-20,0.9],
    37 => ["Graphics/Pictures/", "80_stein_st01",0,0,-20,0.9],
    38 => ["Graphics/Pictures/", "80_stein_st21",0,0,-20,0.9],
    39 => ["Graphics/Pictures/", "80_stein2_st01",0,0,-20,0.9],
    40 => ["Graphics/Pictures/", "80_stein_st51",0,0,-20,0.9],
    41 => ["Graphics/Pictures/", "80_stein_st31",0,0,-20,0.9],
    45 => ["Graphics/Pictures/", "80_alicetromeria_st01",0,0,-20,0.9],
    53 => ["Graphics/Pictures/", "80_slime_st01",0,0,-30,0.9],
    54 => ["Graphics/Pictures/", "80_bunnyslime_st01",0,0,0,0.8],
    55 => ["Graphics/Pictures/", "80_name_st01",0,-30,-40,0.9],
    56 => ["Graphics/Pictures/", "80_inp_st01",0,0,-20,0.9],
    57 => ["Graphics/Pictures/", "80_inp_st21",0,0,-10,0.9],
    58 => ["Graphics/Pictures/", "80_inp_st11",0,0,-10,0.9],
    59 => ["Graphics/Pictures/", "80_mdg_st01",0,0,0,0.8],
    60 => ["Graphics/Pictures/", "80_dog_st01",0,0,-10,0.9],
    61 => ["Graphics/Pictures/", "80_mimizu_st01",0,0,0,0.8],
    62 => ["Graphics/Pictures/", "80_gob_st01",0,0,0,0.9],
    63 => ["Graphics/Pictures/", "80_gob_st31",0,0,-20,0.9],
    64 => ["Graphics/Pictures/", "80_pramia_st01",0,0,0,0.9],
    65 => ["Graphics/Pictures/", "80_pramia_st21",0,0,0,0.9],
    66 => ["Graphics/Pictures/", "80_vgirl_st01",0,0,0,0.9],
    67 => ["Graphics/Pictures/", "80_vgirl_st31",0,0,0,0.9],
    68 => ["Graphics/Pictures/", "80_dragonp_st01",0,0,0,0.9],
    69 => ["Graphics/Pictures/", "80_dragonp_st31",0,0,-20,0.9],
    70 => ["Graphics/Pictures/", "80_nezumi_st01",0,-20,-20,0.9],
    71 => ["Graphics/Pictures/", "80_okami_st01",0,0,-20,0.9],
    72 => ["Graphics/Pictures/", "80_phoenix_st01",0,0,0,0.9],
    73 => ["Graphics/Pictures/", "80_hiru_st01",0,0,0,0.8],
    74 => ["Graphics/Pictures/", "80_usagi_st01",0,0,0,0.85],
    75 => ["Graphics/Pictures/", "80_hituzi_st01",0,0,-30,0.8],
    76 => ["Graphics/Pictures/", "80_syuree_st01",0,0,0,0.8],
    77 => ["Graphics/Pictures/", "80_jeid_st01",0,0,0,0.9],
    78 => ["Graphics/Pictures/", "80_syesta_st01",0,0,0,0.9],
    79 => ["Graphics/Pictures/", "80_nuruko_st01",0,0,-50,0.9],
    80 => ["Graphics/Pictures/", "80_orc_st01",0,40,-40],
    81 => ["Graphics/Pictures/", "80_mitubati_st01",0,0,0,0.8],
    82 => ["Graphics/Pictures/", "80_suzume_st01",0,0,0,0.8],
    83 => ["Graphics/Pictures/", "80_hapy_a_st01",0,0,0,0.9],
    84 => ["Graphics/Pictures/", "80_hapy_bc_st01",0,0,0,0.9],
    85 => ["Graphics/Pictures/", "80_highslag_st01",0,0,0,0.8],
    86 => ["Graphics/Pictures/", "80_name_s_st01",0,0,-30,0.9],
    87 => ["Graphics/Pictures/", "80_name2_st01",0,0,0,0.8],
    88 => ["Graphics/Pictures/", "80_jack_st01",0,-40,0,0.8],
    89 => ["Graphics/Pictures/", "80_ropa_st01",0,0,0,0.8],
    90 => ["Graphics/Pictures/", "80_meda_st01",0,0,-20,0.9],
    91 => ["Graphics/Pictures/", "80_candle_st01",0,0,-20,0.9],
    92 => ["Graphics/Pictures/", "80_eater_st01",0,0,-20,0.9],
    93 => ["Graphics/Pictures/", "80_liot_st01",0,0,-20,0.9],
    94 => ["Graphics/Pictures/", "80_luksl_st01",0,0,-20,0.9],
    95 => ["Graphics/Pictures/", "80_delh_a_st01",0,0,-20,0.9],
    96 => ["Graphics/Pictures/", "80_delh_b_st01",0,0,-20,0.9],
    97 => ["Graphics/Pictures/", "80_fairy_st01",0,0,-20,0.9],
    98 => ["Graphics/Pictures/", "80_minikani_st01",0,0,-20,0.9],
    99 => ["Graphics/Pictures/", "80_namazu_st01",0,0,-20,0.9],
    100 => ["Graphics/Pictures/", "80_rahure_st01",0,0,-20,0.9],
    101 => ["Graphics/Pictures/", "80_cent2_st01",0,0,-20,0.9],
    102 => ["Graphics/Pictures/", "80_youko_st01",0,0,-20,0.9],
    103 => ["Graphics/Pictures/", "80_kamuro_st01",0,0,-20,0.9],
    104 => ["Graphics/Pictures/", "80_kumo_st01",0,0,-20,0.9],
    105 => ["Graphics/Pictures/", "80_mimic_st01",0,0,-20,0.9],
    106 => ["Graphics/Pictures/", "80_nanabi_st01",0,0,-20,0.9],
    107 => ["Graphics/Pictures/", "80_namako_st01",0,0,-20,0.9],
    108 => ["Graphics/Pictures/", "80_kai_st01",0,0,-20,0.9],
    109 => ["Graphics/Pictures/", "80_kani_st01",0,0,-20,0.9],
    110 => ["Graphics/Pictures/", "80_slimelord_st01",0,0,0,0.7],
    111 => ["Graphics/Pictures/", "80_suika_st01",0,0,-20,0.9],
    112 => ["Graphics/Pictures/", "80_utubo_st01",0,0,-20,0.9],
    113 => ["Graphics/Pictures/", "80_lamia_st01",0,0,-20,0.9],
    114 => ["Graphics/Pictures/", "80_wakame_st01",0,0,-20,0.9],
    115 => ["Graphics/Pictures/", "80_kurage_st01",0,0,-20,0.9],
    116 => ["Graphics/Pictures/", "80_iso_st01",0,0,-20,0.9],
    117 => ["Graphics/Pictures/", "80_ankou_st01",0,0,-20,0.9],
    118 => ["Graphics/Pictures/", "80_meia_st01",0,0,-20,0.9],
    119 => ["Graphics/Pictures/", "80_page17_st01",0,0,-20,0.9],
    120 => ["Graphics/Pictures/", "80_page257_st01",0,0,-20,0.9],
    121 => ["Graphics/Pictures/", "80_page65537_st01",0,0,-20,0.9],
    122 => ["Graphics/Pictures/", "80_sisterlamia_st01",0,50,-20,0.9],
    123 => ["Graphics/Pictures/", "80_sisccubus_st01",0,0,-20,0.9],
    124 => ["Graphics/Pictures/", "80_arikui_st01",0,0,0,0.8],
    125 => ["Graphics/Pictures/", "80_grizzly_st01",0,0,-40],
    126 => ["Graphics/Pictures/", "80_XX-7_st01",0,0,0,0.8],
    127 => ["Graphics/Pictures/", "80_littlebug_st01",0,0,-20,0.9],
    128 => ["Graphics/Pictures/", "80_kaniloid_st01",0,0,-20,0.9],
    129 => ["Graphics/Pictures/", "80_brunhild_st01",0,0,-20,0.9],
    130 => ["Graphics/Pictures/", "80_ghost_st01",0,0,-20,0.9],
    131 => ["Graphics/Pictures/", "80_doll_st01",0,0,-20,0.9],
    132 => ["Graphics/Pictures/", "80_zonbe_st11",0,0,-20,0.9],
    133 => ["Graphics/Pictures/", "80_zonbe_st21",0,0,-20,0.9],
    134 => ["Graphics/Pictures/", "80_chrom_st21",0,0,-20,0.9],
    135 => ["Graphics/Pictures/", "80_frederika_st01",0,0,-20,0.9],
    136 => ["Graphics/Pictures/", "80_elf_st01",0,0,-20,0.9],
    137 => ["Graphics/Pictures/", "80_braunys_st01",0,0,-20,0.8],
    138 => ["Graphics/Pictures/", "80_tfairy_st01",0,0,-20,0.9],
    139 => ["Graphics/Pictures/", "80_fairys_st01",0,0,-20,0.9],
    140 => ["Graphics/Pictures/", "80_taran_st01",0,0,-20,0.9],
    141 => ["Graphics/Pictures/", "80_mino_st01",0,0,-20,0.9],
    142 => ["Graphics/Pictures/", "80_bander_st01",0,0,-20,0.9],
    143 => ["Graphics/Pictures/", "80_eva_st01",0,0,0,0.9],
    144 => ["Graphics/Pictures/", "80_saboresu_st01",0,0,-80],
    145 => ["Graphics/Pictures/", "80_mukade_st01",0,0,-20,0.9],
    146 => ["Graphics/Pictures/", "80_sasori_st01",0,0,-20,0.9],
    147 => ["Graphics/Pictures/", "80_saboten_st01",0,0,-20,0.9],
    148 => ["Graphics/Pictures/", "80_datyou_st01",0,80,-20,0.9],
    149 => ["Graphics/Pictures/", "80_lamp_st21",0,0,-20,0.9],
    150 => ["Graphics/Pictures/", "80_mummy_st01",0,0,-20,0.9],
    151 => ["Graphics/Pictures/", "80_kobura_st01",0,0,-20,0.9],
    152 => ["Graphics/Pictures/", "80_lamias_st01",0,0,-20,0.9],
    153 => ["Graphics/Pictures/", "80_sphinx_st01",0,0,-20,0.9],
    154 => ["Graphics/Pictures/", "80_wani_st01",0,0,-20,0.9],
    155 => ["Graphics/Pictures/", "80_saki_st01",0,0,-20,0.9],
    156 => ["Graphics/Pictures/", "80_d_fighter_st01",0,0,-20,0.9],
    157 => ["Graphics/Pictures/", "80_oogumo_st01",0,0,-20,0.8],
    158 => ["Graphics/Pictures/", "80_suckvore_st01",0,0,-20,0.9],
    159 => ["Graphics/Pictures/", "80_ironmaiden_st01",0,0,-20,0.9],
    160 => ["Graphics/Pictures/", "80_wormv_st01",0,0,-20,0.9],
    161 => ["Graphics/Pictures/", "80_ustrel_st01",0,0,-40,0.9],
    162 => ["Graphics/Pictures/", "80_mitutubo_st01",0,0,-20,0.9],
    163 => ["Graphics/Pictures/", "80_lily_st01",0,0,-20,0.9],
    164 => ["Graphics/Pictures/", "80_kooni_st01",0,0,-50],
    165 => ["Graphics/Pictures/", "80_onaho_st01",0,0,0,0.8],
    166 => ["Graphics/Pictures/", "80_narcubus_st11",0,0,-20,0.9],
    167 => ["Graphics/Pictures/", "80_lusia_st01",0,0,-20,0.9],
    168 => ["Graphics/Pictures/", "80_dodome_st01",0,0,-20,0.9],
    169 => ["Graphics/Pictures/", "80_lizardthief_st01",0,0,-40,0.9],
    170 => ["Graphics/Pictures/", "80_lizardthief_st11",0,0,-40,0.9],
    171 => ["Graphics/Pictures/", "80_lizardboss_st01",0,0,-20,0.9],
    172 => ["Graphics/Pictures/", "80_sinkiro_st01",0,0,-20,0.9],
    173 => ["Graphics/Pictures/", "80_arizigoku_st01",0,0,-20,0.9],
    174 => ["Graphics/Pictures/", "80_sandw_st01",0,30,-20,0.9],
    175 => ["Graphics/Pictures/", "80_d_scylla_st01",0,0,-20,0.9],
    176 => ["Graphics/Pictures/", "80_vitae_st01",0,0,-20,0.9],
    177 => ["Graphics/Pictures/", "80_vetala_st01",0,0,-20,0.9],
    178 => ["Graphics/Pictures/", "80_valt_st01",0,0,-20,0.9],
    179 => ["Graphics/Pictures/", "80_sinifa_st01",0,0,-20,0.9],
    180 => ["Graphics/Pictures/", "80_shadow_st01",0,0,-20,0.9],
    181 => ["Graphics/Pictures/", "80_gaistvine_st01",0,0,-20,0.9],
    182 => ["Graphics/Pictures/", "80_c_homunculus_st01",0,0,-20,0.9],
    183 => ["Graphics/Pictures/", "80_ironmaiden_k_st01",0,0,-20,0.9],
    184 => ["Graphics/Pictures/", "80_junkdoll_st01",0,0,-20,0.9],
    185 => ["Graphics/Pictures/", "80_radio_st01",0,0,-20,0.8],
    191 => ["Graphics/Pictures/", "80_kinoko_st01",0,0,-20,0.9],
    192 => ["Graphics/Pictures/", "80_nobisutam_st01",0,0,-20,0.9],
    193 => ["Graphics/Pictures/", "80_u_scylla_st01",0,0,-20,0.9],
    194 => ["Graphics/Pictures/", "80_husuma_st01",0,0,-20,0.8],
    195 => ["Graphics/Pictures/", "80_mermaid_st01",0,0,-20,0.8],
    196 => ["Graphics/Pictures/", "80_s_mermaid_st01",0,0,-20,0.9],
    197 => ["Graphics/Pictures/", "80_k_mermaid_st01",0,0,-20,0.9],
    198 => ["Graphics/Pictures/", "80_ittanmomen_st01",0,0,-20,0.8],
    199 => ["Graphics/Pictures/", "80_dagon_st01",0,0,-20,0.9],
    200 => ["Graphics/Pictures/", "80_hitodama_st01",0,0,-20,0.9],
    201 => ["Graphics/Pictures/", "80_ashel_st01",0,0,-20,0.9],
    202 => ["Graphics/Pictures/", "80_bonny_st01",0,0,-20,0.9],
    203 => ["Graphics/Pictures/", "80_tatunoko_k_st01",0,0,-20,0.9],
    204 => ["Graphics/Pictures/", "80_umiusi_k_st01",0,0,-20,0.9],
    205 => ["Graphics/Pictures/", "80_levia_st01",0,0,-20,0.9],
    206 => ["Graphics/Pictures/", "80_kaeru_st01",0,0,-20,0.9],
    207 => ["Graphics/Pictures/", "80_centa_st01",0,0,-20,0.9],
    208 => ["Graphics/Pictures/", "80_alraune_st01",0,0,-20,0.9],
    209 => ["Graphics/Pictures/", "80_okikumusi_st01",0,0,-20,0.7],
    210 => ["Graphics/Pictures/", "80_ghost2_st01",0,0,-20,0.9],
    211 => ["Graphics/Pictures/", "80_hakoiri_st01",0,0,-20,0.9],
    212 => ["Graphics/Pictures/", "80_durahan_st01",0,0,-20,0.9],
    213 => ["Graphics/Pictures/", "80_kerberos_st01",0,0,-20,0.9],
    214 => ["Graphics/Pictures/", "80_nureonnna_st01",0,0,-20,0.9],
    215 => ["Graphics/Pictures/", "80_h_mino_st01",0,0,-20,0.9],
    216 => ["Graphics/Pictures/", "80_m_mino_st01",0,0,-20,0.9],
    217 => ["Graphics/Pictures/", "80_zinitauros_st01",0,0,-20,0.9],
    218 => ["Graphics/Pictures/", "80_nyumaou_st01",0,0,-20,0.9],
    219 => ["Graphics/Pictures/", "80_kunoitielf_st01",0,0,-20,0.9],
    220 => ["Graphics/Pictures/", "80_samuraielf_st01",0,0,-20,0.9],
    221 => ["Graphics/Pictures/", "80_yukionna_st01",0,0,-20,0.8],
    222 => ["Graphics/Pictures/", "80_nekomata_st01",0,0,-50,0.9],
    223 => ["Graphics/Pictures/", "80_akaname_st01",0,0,-20,0.9],
    224 => ["Graphics/Pictures/", "80_kappa_st01",0,0,-20,0.8],
    225 => ["Graphics/Pictures/", "80_hutakuti_st11",0,0,-20,0.9],
    226 => ["Graphics/Pictures/", "80_sirohebisama_st01",0,0,-20,0.9],
    227 => ["Graphics/Pictures/", "80_mikolamia_st01",0,0,-20,0.8],
    228 => ["Graphics/Pictures/", "80_mikoarachne_st01",0,0,-50,0.9],
    229 => ["Graphics/Pictures/", "80_kezyorou_st01",0,0,-20,0.9],
    230 => ["Graphics/Pictures/", "80_yamatanooroti_st01",0,0,-20,0.8],
    231 => ["Graphics/Pictures/", "80_m_batterfly_st01",0,0,-20,0.8],
    232 => ["Graphics/Pictures/", "80_m_elf_st01",0,0,-20,0.9],
    233 => ["Graphics/Pictures/", "80_mefist_st01",0,0,-20,0.9],
    234 => ["Graphics/Pictures/", "80_kamakiri_st01",0,0,-20,0.9],
    235 => ["Graphics/Pictures/", "80_kaiko_st01",0,0,-20,0.9],
    236 => ["Graphics/Pictures/", "80_a_alm_st01",0,0,-20,0.9],
    237 => ["Graphics/Pictures/", "80_a_vore_st01",0,0,-20,0.9],
    238 => ["Graphics/Pictures/", "80_dorothy_st01",0,0,-20,0.9],
    239 => ["Graphics/Pictures/", "80_rafi_st01",0,0,-20,0.9],
    240 => ["Graphics/Pictures/", "80_dina_st01",0,0,-20,0.9],
    241 => ["Graphics/Pictures/", "80_a_emp_st01",0,0,-20,0.9],
    242 => ["Graphics/Pictures/", "80_a_emp_st21",0,0,-20,0.9],
    243 => ["Graphics/Pictures/", "80_moss_st01",0,0,-20,0.9],
    244 => ["Graphics/Pictures/", "80_suzumebati_st01",0,0,-20,0.9],
    245 => ["Graphics/Pictures/", "80_queenbee_st01",0,0,-20,0.9],
    246 => ["Graphics/Pictures/", "80_jelly_st01",0,0,-20,0.8],
    247 => ["Graphics/Pictures/", "80_blob_st01",0,0,-20,0.8],
    248 => ["Graphics/Pictures/", "80_slime_purple_st01",0,0,-20,0.9],
    249 => ["Graphics/Pictures/", "80_ant_st11",0,0,-20,0.9],
    250 => ["Graphics/Pictures/", "80_artm_st01",0,0,-20,0.8],
    251 => ["Graphics/Pictures/", "80_paizuridoll_st01",0,0,-20,0.8],
    252 => ["Graphics/Pictures/", "80_scylla_st01",0,0,-20,0.8],
    253 => ["Graphics/Pictures/", "80_medusa_st01",0,0,-20,0.8],
    254 => ["Graphics/Pictures/", "80_ageha_st01",0,0,-20,0.9],
    255 => ["Graphics/Pictures/", "80_blom_st01",0,0,-20,0.9],
    256 => ["Graphics/Pictures/", "80_warmer_st01",0,0,-20,0.8],
    257 => ["Graphics/Pictures/", "80_gool_st01",0,0,-20,0.9],
    258 => ["Graphics/Pictures/", "80_fakejelly_st01",0,0,-20,0.9],
    259 => ["Graphics/Pictures/", "80_w_hapy_st01",0,0,-20,0.9],
    260 => ["Graphics/Pictures/", "80_k_hapy_st01",0,0,-20,0.9],
    261 => ["Graphics/Pictures/", "80_madgolem_st01",0,0,-20,0.9],
    262 => ["Graphics/Pictures/", "80_golem_st01",0,0,-20,0.9],
    263 => ["Graphics/Pictures/", "80_h_kamakiri_st01",0,0,-20,0.8],
    264 => ["Graphics/Pictures/", "80_bgolem_st01",0,0,-20,0.9],
    265 => ["Graphics/Pictures/", "80_kitunezyu_st01",0,0,-20,0.9],
    266 => ["Graphics/Pictures/", "80_kunoitisanbi_st01",0,0,-20,0.9],
    267 => ["Graphics/Pictures/", "80_mononohuyonbi_st01",0,0,-20,0.9],
    268 => ["Graphics/Pictures/", "80_queenant_st01",0,0,-20,0.9],
    269 => ["Graphics/Pictures/", "80_yougan_st01",0,0,-20,0.9],
    270 => ["Graphics/Pictures/", "80_lamiad_st01",0,0,-20,0.9],
    271 => ["Graphics/Pictures/", "80_scyllad_st01",0,0,-20,0.9],
    272 => ["Graphics/Pictures/", "80_seiren_st01",0,0,-20,0.9],
    273 => ["Graphics/Pictures/", "80_sango_st01",0,0,-20,0.8],
    274 => ["Graphics/Pictures/", "80_hitode_st01",0,0,-20,0.9],
    275 => ["Graphics/Pictures/", "80_beelzebub_st01",0,0,-20,0.8],
    276 => ["Graphics/Pictures/", "80_beelzebub_st11",0,0,-20,0.8],
    277 => ["Graphics/Pictures/", "80_beelzebub_st21",0,0,-20,0.8],
    278 => ["Graphics/Pictures/", "80_arkjelly_st01",0,0,-20,0.8],
    279 => ["Graphics/Pictures/", "80_e_scylla_st01",0,0,-20,0.8],
    280 => ["Graphics/Pictures/", "80_poseidones_st01",0,0,-20,0.9],
    281 => ["Graphics/Pictures/", "80_succubuses_st01",0,160,-50,0.9],
    282 => ["Graphics/Pictures/", "80_maycubbus_st01",0,0,-20,0.9],
    283 => ["Graphics/Pictures/", "80_maccubus_st31",0,0,-20,0.9],
    284 => ["Graphics/Pictures/", "80_minccubus_st21",0,0,-20,0.9],
    285 => ["Graphics/Pictures/", "80_renccubus_st21",0,0,-20,0.9],
    286 => ["Graphics/Pictures/", "80_witchs_st01",0,0,-20,0.8],
    287 => ["Graphics/Pictures/", "80_succubus_st01",0,0,-20,0.8],
    288 => ["Graphics/Pictures/", "80_d_succubus_st01",0,0,-20,0.9],
    289 => ["Graphics/Pictures/", "80_maidscyulla_st01",0,0,-20,0.8],
    290 => ["Graphics/Pictures/", "80_madaminsect_st01",0,0,-20,0.8],
    291 => ["Graphics/Pictures/", "80_madamumbrella_st01",0,0,-20,0.9],
    292 => ["Graphics/Pictures/", "80_aradia_st01",0,0,-20,0.8],
    293 => ["Graphics/Pictures/", "80_candy_st01",0,0,-20,0.8],
    294 => ["Graphics/Pictures/", "80_emily_st01",0,0,-20,0.8],
    295 => ["Graphics/Pictures/", "80_cassandra_st21",0,0,-20,0.8],
    296 => ["Graphics/Pictures/", "80_cassandra_st02",0,0,-20,0.8],
    297 => ["Graphics/Pictures/", "80_basilisk_st01",0,0,-20,0.9],
    298 => ["Graphics/Pictures/", "80_dragon_st01",0,0,-20,0.8],
    299 => ["Graphics/Pictures/", "80_gelatinous_st01",0,0,-20,0.9],
    300 => ["Graphics/Pictures/", "80_youki_st01",0,20,-20,0.8],
    301 => ["Graphics/Pictures/", "80_tora_st01",0,0,-20,0.8],
    302 => ["Graphics/Pictures/", "80_vampire_st01",0,0,-20,0.8],
    303 => ["Graphics/Pictures/", "80_jeraira_st01",0,0,-20,0.9],
    304 => ["Graphics/Pictures/", "80_libolibo_st01",0,0,-20,0.9],
    305 => ["Graphics/Pictures/", "80_anfill_st01",0,0,-20,0.9],
    306 => ["Graphics/Pictures/", "80_twinkel_st01",0,0,-20,0.8],
    307 => ["Graphics/Pictures/", "80_seaanemone_st01",0,0,-20,0.8],
    308 => ["Graphics/Pictures/", "80_suiryu_st01",0,0,-20,0.9],
    309 => ["Graphics/Pictures/", "80_manta_st01",0,0,-20,0.9],
    310 => ["Graphics/Pictures/", "80_ikkaku_st01",0,0,-20,0.9],
    311 => ["Graphics/Pictures/", "80_trickfairy_st01",0,0,-20,0.8],
    312 => ["Graphics/Pictures/", "80_amazoneself_st01",0,0,-20,0.9],
    313 => ["Graphics/Pictures/", "80_carbuncle_st01",0,0,-20,0.8],
    314 => ["Graphics/Pictures/", "80_gigantic_st01",0,0,-20,0.9],
    315 => ["Graphics/Pictures/", "80_queenfairy_st01",0,0,-20,0.8],
    316 => ["Graphics/Pictures/", "80_queenelf_st01",0,0,-20,0.9],
    317 => ["Graphics/Pictures/", "80_f_alraune_st01",0,0,-20,0.8],
    318 => ["Graphics/Pictures/", "80_f_dryad_st01",0,0,-20,0.8],
    319 => ["Graphics/Pictures/", "80_walraune_st01",0,0,-20,0.9],
    320 => ["Graphics/Pictures/", "80_dryad_st01",0,60,-50,0.9],
    321 => ["Graphics/Pictures/", "80_dryad_st11",0,60,-50,0.9],
    322 => ["Graphics/Pictures/", "80_queenalraune_st01",0,0,-20,0.8],
    323 => ["Graphics/Pictures/", "80_queenhapy_st01",0,0,0,0.9],
    324 => ["Graphics/Pictures/", "80_knight_mermaid_st01",0,0,-20,0.8],
    325 => ["Graphics/Pictures/", "80_g_mermaid_st01",0,-50,-20,0.9],
    326 => ["Graphics/Pictures/", "80_loreley_st01",0,0,-20,0.9],
    327 => ["Graphics/Pictures/", "80_ningyohime_st04",0,0,-20,0.8],
    328 => ["Graphics/Pictures/", "80_queenmermaid_st01",0,0,-20,0.8],
    329 => ["Graphics/Pictures/", "80_kraken_st01",0,0,-20,0.9],
    330 => ["Graphics/Pictures/", "80_arachnes_st01",0,0,-20,0.9],
    331 => ["Graphics/Pictures/", "80_tutigumo_st11",0,0,-20,0.8],
    332 => ["Graphics/Pictures/", "80_alakneload_st01",0,0,-20,0.8],
    333 => ["Graphics/Pictures/", "80_atlach_st02",0,0,-20,0.8],
    334 => ["Graphics/Pictures/", "80_kumonomiko_st01",0,0,-20,0.9],
    335 => ["Graphics/Pictures/", "80_conquista_st01",0,0,-20,0.8],
    336 => ["Graphics/Pictures/", "80_vendetta_st01",0,0,-20,0.8],
    337 => ["Graphics/Pictures/", "80_e_vampire_st01",0,0,-20,0.8],
    338 => ["Graphics/Pictures/", "80_carmilla_st01",0,0,-20,0.9],
    339 => ["Graphics/Pictures/", "80_elisabeth_st01",0,0,-20,0.9],
    340 => ["Graphics/Pictures/", "80_queenvanpire_st11",0,0,-20,0.9],
    341 => ["Graphics/Pictures/", "80_lilith_st01",0,0,-20,0.8],
    342 => ["Graphics/Pictures/", "80_m_shadow_st01",0,0,-20,0.9],
    343 => ["Graphics/Pictures/", "80_enenra_st11",0,0,-20,0.8],
    344 => ["Graphics/Pictures/", "80_kirin_st01",0,0,-20,0.9],
    345 => ["Graphics/Pictures/", "80_zyakotuonna_st01",0,0,-20,0.9],
    346 => ["Graphics/Pictures/", "80_behemoth_st01",0,0,-20,0.9],
    347 => ["Graphics/Pictures/", "80_wyvern_st01",0,0,-20,0.9],
    348 => ["Graphics/Pictures/", "80_kyoryuu_st01",0,0,-20,0.9],
    349 => ["Graphics/Pictures/", "80_monk_sucubuss_st01",0,0,-20,0.9],
    350 => ["Graphics/Pictures/", "80_monk_demon_st01",0,0,-20,0.9],
    351 => ["Graphics/Pictures/", "80_scylla_s_st01",0,0,-20,0.9],
    352 => ["Graphics/Pictures/", "80_vouivre_st01",0,0,-20,0.9],
    353 => ["Graphics/Pictures/", "80_icemaze_st01",0,0,-20,0.9],
    354 => ["Graphics/Pictures/", "80_shirokuma_st01",0,20,-20,0.9],
    355 => ["Graphics/Pictures/", "80_angels_st01",0,8,-28,0.9],
    356 => ["Graphics/Pictures/", "80_trinity_st01",0,0,-50,0.9],
    357 => ["Graphics/Pictures/", "80_uranus_st01",0,50,-20,0.9],
    358 => ["Graphics/Pictures/", "80_ediniel_st01",0,0,-20,0.9],
    359 => ["Graphics/Pictures/", "80_cupid_st01",0,0,-20,0.9],
    360 => ["Graphics/Pictures/", "80_valkyrie_st01",0,-50,-20,0.9],
    361 => ["Graphics/Pictures/", "80_heriel_st01",0,0,-20,0.9],
    362 => ["Graphics/Pictures/", "80_arusiel_st11",0,0,-20,0.9],
    363 => ["Graphics/Pictures/", "80_c_beast_st01",0,0,-20,0.8],
    364 => ["Graphics/Pictures/", "80_c_s2_st01",0,0,-20,0.8],
    365 => ["Graphics/Pictures/", "80_c_a3_st01",0,0,-20,0.8],
    366 => ["Graphics/Pictures/", "80_AD-5_st01",0,0,-20,0.8],
    367 => ["Graphics/Pictures/", "80_q_5_st01",0,50,-20,0.8],
    368 => ["Graphics/Pictures/", "80_cirqueb_st01",0,0,-20,0.9],
    369 => ["Graphics/Pictures/", "80_cirquec_st01",0,0,-20,0.9],
    370 => ["Graphics/Pictures/", "80_cirqueb_st11",0,-30,-50,0.9],
    371 => ["Graphics/Pictures/", "80_cirquec_st11",0,0,-20,0.9],
    372 => ["Graphics/Pictures/", "80_cirqueb_st21",0,0,-20,0.9],
    373 => ["Graphics/Pictures/", "80_cirquec_st21",0,0,-20,0.8],
    374 => ["Graphics/Pictures/", "80_cirqueb_st31",0,0,-20,0.9],
    375 => ["Graphics/Pictures/", "80_cirquec_st31",0,0,-20,0.9],
    376 => ["Graphics/Pictures/", "80_cirqueb_st41",0,0,-20,0.8],
    377 => ["Graphics/Pictures/", "80_cirquec_st41",0,0,-20,0.8],
    378 => ["Graphics/Pictures/", "80_cirqueb_st51",0,0,-20,0.9],
    379 => ["Graphics/Pictures/", "80_cirquec_st51",0,70,-20,0.8],
    382 => ["Graphics/Pictures/", "80_morrigan_st01",0,0,-50],
    383 => ["Graphics/Pictures/", "80_eden_st21",0,0,-20,0.9],
    384 => ["Graphics/Pictures/", "80_eden_st01",0,0,-20,0.9],
    385 => ["Graphics/Pictures/", "80_eden_st31",0,0,-20,0.9],
    386 => ["Graphics/Pictures/", "80_eden_st51",0,0,-20,0.9],
    387 => ["Graphics/Pictures/", "80_eden_st41",0,0,-20,0.9],
    388 => ["Graphics/Pictures/", "80_eden_st62",0,0,-20,0.9],
    391 => ["Graphics/Pictures/", "80_mefist_st11",0,0,-20,0.8],
    392 => ["Graphics/Pictures/", "80_mefist_st31",0,0,-20,0.9],
    393 => ["Graphics/Pictures/", "80_mefist_st41",0,0,-20,0.9],
    394 => ["Graphics/Pictures/", "80_astaroth_st01",0,0,-50],
    395 => ["Graphics/Pictures/", "80_lilith2_st01b",0,0,-20,0.8],
    396 => ["Graphics/Pictures/", "80_lilith2_st11",0,0,-20,0.9],
    397 => ["Graphics/Pictures/", "80_shion_st01",0,0,-20,0.9],
    398 => ["Graphics/Pictures/", "80_shion_st31",0,0,-20,0.9],
    399 => ["Graphics/Pictures/", "80_shion_st51",0,0,-20,0.9],
    400 => ["Graphics/Pictures/", "80_shion_st71",0,0,-20,0.9],
    401 => ["Graphics/Pictures/", "80_gnosis_st01",0,0,-20,0.9],
    403 => ["Graphics/Pictures/", "80_galda_st01",0,0,-20,0.8],
    404 => ["Graphics/Pictures/", "80_cockroacha_st01",0,0,-20,0.8],
    405 => ["Graphics/Pictures/", "80_cockroachb_st01",0,0,-20,0.9],
    406 => ["Graphics/Pictures/", "80_queenroach_st01",0,0,-20,0.9],
    407 => ["Graphics/Pictures/", "80_magicpot_st01",0,0,-50,0.9],
    408 => ["Graphics/Pictures/", "80_mametanuki_st01",0,0,-20,0.9],
    409 => ["Graphics/Pictures/", "80_zyoutanuki_st01",0,0,-20,0.9],
    410 => ["Graphics/Pictures/", "80_shinobitanuki_st01",0,0,-20,0.9],
    411 => ["Graphics/Pictures/", "80_baketanuki_st01",0,0,-20,0.9],
    412 => ["Graphics/Pictures/", "80_inugami_st01",0,0,-20,0.9],
    413 => ["Graphics/Pictures/", "80_kurodanuki_st01",0,0,-20,0.9],
    414 => ["Graphics/Pictures/", "80_kunoitielf2_st01",0,0,-20,0.9],
    415 => ["Graphics/Pictures/", "80_kuno_succubus_st01",0,0,-20,0.9],
    416 => ["Graphics/Pictures/", "80_kuno_hapy_st01",0,0,-20,0.9],
    417 => ["Graphics/Pictures/", "80_kuno_scylla_st01",0,0,-20,0.9],
    418 => ["Graphics/Pictures/", "80_kuno_arachne_st01",0,0,-20,0.9],
    419 => ["Graphics/Pictures/", "80_elfhime_st01",0,0,-20,0.9],
    420 => ["Graphics/Pictures/", "80_hatibi_st01",0,0,-20,0.9],
    421 => ["Graphics/Pictures/", "80_esuccubus_st01",0,0,-20,0.9],
    422 => ["Graphics/Pictures/", "80_gran_centa_st01",0,0,-20,0.9],
    423 => ["Graphics/Pictures/", "80_abis_st01",0,0,-20,0.9],
    424 => ["Graphics/Pictures/", "80_onmyougobi_st01",0,0,-20,0.9],
    425 => ["Graphics/Pictures/", "80_oiranrokubi_st01",0,0,-20,0.9],
    426 => ["Graphics/Pictures/", "80_sanki_st01",0,10,-100,1.0],
    427 => ["Graphics/Pictures/", "80_sanki_st11",0,180,-20,1.0],
    428 => ["Graphics/Pictures/", "80_sanki_st21",0,-200,-50,1.0],
    429 => ["Graphics/Pictures/", "80_amoldoll_st01",0,0,-20,0.9],
    430 => ["Graphics/Pictures/", "80_persephone_st01",0,0,-20,0.9],
    431 => ["Graphics/Pictures/", "80_trilobite_st11",0,0,-20,0.9],
    432 => ["Graphics/Pictures/", "80_zenki_st01",0,0,-20,0.9],
    433 => ["Graphics/Pictures/", "80_kouki_st01",0,0,-20,0.9],
    435 => ["Graphics/Pictures/", "80_mariel_st01",0,0,-20,0.9],
    436 => ["Graphics/Pictures/", "80_tennyo_st01",0,0,-20,0.9],
    437 => ["Graphics/Pictures/", "80_c_tentacle_st01",0,0,-20,0.9],
    438 => ["Graphics/Pictures/", "80_ariel_st01",0,0,-20,0.9],
    439 => ["Graphics/Pictures/", "80_ranael_st31",0,0,-20,0.9],
    440 => ["Graphics/Pictures/", "80_nagael_st01",0,0,-20,0.9],
    441 => ["Graphics/Pictures/", "80_c_medulahan_st01",0,0,-20,0.9],
    442 => ["Graphics/Pictures/", "80_ratael_st01",0,0,-20,0.9],
    443 => ["Graphics/Pictures/", "80_rifaiel_st11",0,0,-20,0.9],
    444 => ["Graphics/Pictures/", "80_giriel_st01",0,0,-20,0.9],
    445 => ["Graphics/Pictures/", "80_trooperloid_st01",0,0,-20,0.9],
    446 => ["Graphics/Pictures/", "80_sabiriel_st01",0,0,-20,0.9],
    447 => ["Graphics/Pictures/", "80_muzukiel_st01",0,0,-20,0.9],
    448 => ["Graphics/Pictures/", "80_silkiel_st01",0,0,-20,0.9],
    449 => ["Graphics/Pictures/", "80_berryel_st01",0,0,-20,0.9],
    450 => ["Graphics/Pictures/", "80_evilprant_st01",0,0,-20,0.9],
    451 => ["Graphics/Pictures/", "80_revel_st01",0,0,-20,0.9],
    452 => ["Graphics/Pictures/", "80_c_tangh_st01",0,0,-20,0.9],
    453 => ["Graphics/Pictures/", "80_c_bug_st01",0,0,-20,0.8],
    454 => ["Graphics/Pictures/", "80_c_slag_st01",0,0,-20,0.9],
    455 => ["Graphics/Pictures/", "80_c_dryad_st01",0,0,-20,0.9],
    456 => ["Graphics/Pictures/", "80_catoblepas_st01",0,0,-20,0.9],
    457 => ["Graphics/Pictures/", "80_typhon_st01",0,0,-20,0.9],
    458 => ["Graphics/Pictures/", "80_laplace_st01",0,0,-20,0.9],
    459 => ["Graphics/Pictures/", "80_traptemis_st01",0,0,-20,0.9],
    460 => ["Graphics/Pictures/", "80_furiel_st01",0,0,-20,0.9],
    461 => ["Graphics/Pictures/", "80_drainplant_st01",0,0,-20,0.9],
    462 => ["Graphics/Pictures/", "80_drainloid_st01",0,0,-20,0.9],
    463 => ["Graphics/Pictures/", "80_handyloid_st01",0,0,-20,0.9],
    464 => ["Graphics/Pictures/", "80_maid_angel_st01",0,0,-20,0.9],
    465 => ["Graphics/Pictures/", "80_cooc_angel_st01",0,0,-20,0.9],
    466 => ["Graphics/Pictures/", "80_whiteyel_st01",0,0,-20,0.9],
    467 => ["Graphics/Pictures/", "80_lamianloid_st01",0,0,-20,0.9],
    468 => ["Graphics/Pictures/", "80_endiel_st11",0,0,-20,0.9],
    469 => ["Graphics/Pictures/", "80_replicant_st01",0,30,-20,0.9],
    470 => ["Graphics/Pictures/", "80_c_prison_st01",0,0,-20,0.9],
    471 => ["Graphics/Pictures/", "80_maikonido_st01",0,0,-20,0.9],
    472 => ["Graphics/Pictures/", "80_matango_st01",0,0,-20,0.9],
    473 => ["Graphics/Pictures/", "80_meltymoss_st01",0,0,-20,0.9],
    474 => ["Graphics/Pictures/", "80_meltyrose_st01",0,0,-20,0.9],
    475 => ["Graphics/Pictures/", "80_c_dryad_vore_st01",0,0,-20,0.9],
    476 => ["Graphics/Pictures/", "80_yomotu_st01",0,0,-20,0.9],
    477 => ["Graphics/Pictures/", "80_fermesara_st01",0,0,-20,0.9],
    478 => ["Graphics/Pictures/", "80_angelghoul_st01",0,0,-20,0.8],
    479 => ["Graphics/Pictures/", "80_dragonzonbe_st21",0,100,-20,0.9],
    480 => ["Graphics/Pictures/", "80_sarlacc_st01",0,0,-20,0.9],
    481 => ["Graphics/Pictures/", "80_siriel_st01",0,0,-20,0.9],
    482 => ["Graphics/Pictures/", "80_eggel_st01",0,0,-20,0.9],
    483 => ["Graphics/Pictures/", "80_c_chariot_st01",0,0,-20,0.9],
    484 => ["Graphics/Pictures/", "80_knightloid_st01",0,-40,-20,0.9],
    485 => ["Graphics/Pictures/", "80_assassinloid_st01",0,0,-20,0.9],
    486 => ["Graphics/Pictures/", "80_yuriel_st01",0,0,-20,0.9],
    487 => ["Graphics/Pictures/", "80_merusiel_st01",0,0,-20,0.9],
    488 => ["Graphics/Pictures/", "80_sebasiel_st01",0,0,-20,0.9],
    489 => ["Graphics/Pictures/", "80_holmiel_st01",0,0,20,0.9],
    490 => ["Graphics/Pictures/", "80_aptiel_st01",0,0,-20,0.9],
    491 => ["Graphics/Pictures/", "80_clionera_st01",0,0,-20,0.9],
    492 => ["Graphics/Pictures/", "80_roseniel_st11",0,0,-20,0.8],
    493 => ["Graphics/Pictures/", "80_cubiel_st01",0,0,-20,0.9],
    494 => ["Graphics/Pictures/", "80_wormiel_st01",0,0,-20,0.9],
    496 => ["Graphics/Pictures/", "80_zylphe_st01",0,0,-20,0.9],
    497 => ["Graphics/Pictures/", "80_gnomaren_st01",0,0,-20,0.9],
    498 => ["Graphics/Pictures/", "80_grandine_st01",0,0,-20,0.9],
    499 => ["Graphics/Pictures/", "80_gigamander_st01",0,0,-20,0.9],
    500 => ["Graphics/Pictures/", "80_arcen_st01",0,0,-20,0.9],
    501 => ["Graphics/Pictures/", "80_hainu_st01",0,0,-20,0.9],
    502 => ["Graphics/Pictures/", "80_amphis_st01",0,0,-20,0.9],
    503 => ["Graphics/Pictures/", "80_tukuyomi_st01",0,0,-20,0.9],
    504 => ["Graphics/Pictures/", "80_rapun_st01",0,0,-20,0.9],
    505 => ["Graphics/Pictures/", "80_doppeleb_st01",0,0,-20,0.9],
    506 => ["Graphics/Pictures/", "80_doppele_st01",0,0,-20,0.9],
    507 => ["Graphics/Pictures/", "80_doppele_st11",0,0,-20,0.9],
    508 => ["Graphics/Pictures/", "80_doppele_st21",0,0,-20,0.9],
    509 => ["Graphics/Pictures/", "80_doppele_st31",0,0,-20,0.9],
    510 => ["Graphics/Pictures/", "80_rafaera_st11",0,0,-20,0.9],
    511 => ["Graphics/Pictures/", "80_gaburiera_st11",0,0,-20,0.9],
    512 => ["Graphics/Pictures/", "80_uriera_st11",0,0,-20,0.9],
    513 => ["Graphics/Pictures/", "80_sariera_st11",0,0,-20,0.9],
    514 => ["Graphics/Pictures/", "80_metatorone_st11",0,0,-20,0.9],
    515 => ["Graphics/Pictures/", "80_sandalforne_st11",0,-50,-20,0.9],
    516 => ["Graphics/Pictures/", "80_puruel_st01",0,0,-20,0.9],
    517 => ["Graphics/Pictures/", "80_inuel_st01",0,0,-20,0.9],
    518 => ["Graphics/Pictures/", "80_rafaera_st31",0,30,-20,0.9],
    520 => ["Graphics/Pictures/", "80_lazarus_st21",0,30,-20,0.9],
    521 => ["Graphics/Pictures/", "80_lazarus_st31",0,0,-20,0.9],
    522 => ["Graphics/Pictures/", "80_merlin_st01",0,30,-20,0.9],
    523 => ["Graphics/Pictures/", "80_marcellus_st01",0,0,-20,0.9],
    525 => ["Graphics/Pictures/", "80_sonia_s1_st01",0,0,-70],
    526 => ["Graphics/Pictures/", "80_sabasa_st01",0,0,-20,0.9],
    527 => ["Graphics/Pictures/", "80_sabasa_st21",0,0,-20,0.9],
    528 => ["Graphics/Pictures/", "80_sabasa_st31",0,0,-20,0.9],
    529 => ["Graphics/Pictures/", "80_sara_st01",0,0,-20,0.9],
    530 => ["Graphics/Pictures/", "80_saraevil_st01",0,0,-20,0.9],
    531 => ["Graphics/Pictures/", "80_saniria_st12",0,0,-20,0.9],
    533 => ["Graphics/Pictures/", "80_grandnoa_st01",0,0,-20,0.9],
    534 => ["Graphics/Pictures/", "80_madousen_st01",0,0,-20,0.9],
    535 => ["Graphics/Pictures/", "80_grangold_st11",0,0,-20,0.9],
    536 => ["Graphics/Pictures/", "80_serene_st11",0,0,-20,0.9],
    538 => ["Graphics/Pictures/", "80_heinrich_st01",0,0,-20,0.9],
    539 => ["Graphics/Pictures/", "80_heinrich_st41",0,30,-20,0.9],
    540 => ["Graphics/Pictures/", "80_amira_st01",0,0,-20,0.9],
    541 => ["Graphics/Pictures/", "80_piha_st01",0,0,-20,0.9],
    542 => ["Graphics/Pictures/", "80_domeima_st01",0,-70,-20,0.9],
    543 => ["Graphics/Pictures/", "80_santos_st01",0,0,-20,0.9],
    544 => ["Graphics/Pictures/", "80_mob_maid_st01",0,0,-20,0.9],
    545 => ["Graphics/Pictures/", "80_mob_murabito1_st01",0,0,-20,0.9],
    546 => ["Graphics/Pictures/", "80_mob_hurou_st01",0,0,-20,0.9],
    547 => ["Graphics/Pictures/", "80_dondaria_st01",0,0,-20,0.9],
    548 => ["Graphics/Pictures/", "80_mob_bunny1_st01",0,0,-20,0.9],
    549 => ["Graphics/Pictures/", "80_mob_touzoku_st01",0,0,-20,0.9],
    550 => ["Graphics/Pictures/", "80_mob_kakutou_st01",0,0,-20,0.9],
    551 => ["Graphics/Pictures/", "80_mob_maid1_st01",0,0,-20,0.9],
    552 => ["Graphics/Pictures/", "80_mob_elf1_st01",0,0,-20,0.9],
    553 => ["Graphics/Pictures/", "80_mob_gakusya1_st01",0,0,-20,0.9],
    554 => ["Graphics/Pictures/", "80_mob_nasu1_st01",0,0,-20,0.9],
    555 => ["Graphics/Pictures/", "80_mob_murabito2_st01",0,0,-20,0.9],
    556 => ["Graphics/Pictures/", "80_mob_sister1_st01",0,0,-20,0.9],
    557 => ["Graphics/Pictures/", "80_justice_st01",0,0,-20,0.9],
    558 => ["Graphics/Pictures/", "80_mob_uranai1_st01",0,0,-20,0.9],
    559 => ["Graphics/Pictures/", "80_mob_assasin1_st01",0,0,-20,0.9],
    560 => ["Graphics/Pictures/", "80_mob_odoriko1_st01",0,0,-20,0.9],
    561 => ["Graphics/Pictures/", "80_mob_majyo1_st01",0,0,-20,0.9],
    562 => ["Graphics/Pictures/", "80_mob_bukiya1_st01",0,0,-20,0.9],
    570 => ["Graphics/Pictures/", "80_mob_kensi_st01",0,0,-20,0.9],
    571 => ["Graphics/Pictures/", "80_mob_kaihei_st01",0,0,-20,0.9],
    572 => ["Graphics/Pictures/", "80_mob_murabito3_st01",0,0,-20,0.9],
    573 => ["Graphics/Pictures/", "80_mob_sensi1_st01",0,0,-20,0.9],
    574 => ["Graphics/Pictures/", "80_mob_miko1_st01",0,0,-20,0.9],
    575 => ["Graphics/Pictures/", "80_mob_samurai_st01",0,0,-20,0.9],
    576 => ["Graphics/Pictures/", "80_mob_gakusya2_st01",0,0,-20,0.9],
    577 => ["Graphics/Pictures/", "80_mob_mahousyouzyo_st01",0,0,-20,0.9],
    578 => ["Graphics/Pictures/", "80_mob_heisi_st01",0,0,-20,0.9],
    579 => ["Graphics/Pictures/", "80_mob_sanzoku_st01",0,0,-20,0.9],
    580 => ["Graphics/Pictures/", "80_mob_ozyou_st01",0,0,-20,0.9],
    581 => ["Graphics/Pictures/", "80_mob_kizoku_st01",0,0,-20,0.9],
    582 => ["Graphics/Pictures/", "80_mob_douguya_st01",0,0,-20,0.9],
    583 => ["Graphics/Pictures/", "80_mob_kaizoku1_st01",0,0,-20,0.9],
    584 => ["Graphics/Pictures/", "80_mob_kaizoku2_st01",0,0,-20,0.9],
    585 => ["Graphics/Pictures/", "80_mob_kaizoku3_st01",0,0,-20,0.9],
    586 => ["Graphics/Pictures/", "80_mob_ninzya1_st01",0,0,-20,0.9],
    587 => ["Graphics/Pictures/", "80_mob_elf2_st01",0,0,-20,0.9],
    588 => ["Graphics/Pictures/", "80_mob_ninzya2_st01",0,0,-20,0.9],
    589 => ["Graphics/Pictures/", "80_mob_murabito5_st01",0,0,-20,0.9],
    590 => ["Graphics/Pictures/", "80_mob_maid2_st01",0,0,-20,0.9],
    591 => ["Graphics/Pictures/", "80_mob_syuzin_st01",0,0,-20,0.9],
    592 => ["Graphics/Pictures/", "80_mob_youzyo_st01",0,0,-20,0.9],
    593 => ["Graphics/Pictures/", "80_mob_elf3_st01",0,0,-20,0.9],
    594 => ["Graphics/Pictures/", "80_mob_maid3_st01",0,0,-20,0.9],
    595 => ["Graphics/Pictures/", "80_mob_ninzya3_st01",0,0,-20,0.9],
    596 => ["Graphics/Pictures/", "80_mob_maid4_st01",0,0,-20,0.9],
    597 => ["Graphics/Pictures/", "80_mob_miko2_st01",0,0,-20,0.9],
    598 => ["Graphics/Pictures/", "80_mob_wahu1_st01",0,0,-20,0.9],
    599 => ["Graphics/Pictures/", "80_mob_rakunou1_st01",0,0,-20,0.9],
    600 => ["Graphics/Pictures/", "80_mob_murabito4_st01",0,0,-20,0.9],
    601 => ["Graphics/Pictures/", "80_mob_syohu_st01",0,0,-20,0.9],
    602 => ["Graphics/Pictures/", "80_mob_wahu2_st01",0,0,-20,0.9],
    603 => ["Graphics/Pictures/", "80_mob_sister2_st01",0,0,-20,0.9],
    604 => ["Graphics/Pictures/", "80_mob_kisi_st01b",0,0,-20,0.9],
    605 => ["Graphics/Pictures/", "80_mob_hime_st01b",0,0,-20,0.9],
    606 => ["Graphics/Pictures/", "80_fenrir_st01",0,0,-20,0.9],
    607 => ["Graphics/Pictures/", "80_garukimasera_st01",0,0,-20,0.9],
    608 => ["Graphics/Pictures/", "80_greatorc_st01",0,0,-20,0.9],
    609 => ["Graphics/Pictures/", "80_ranccubus_st01",0,0,-20,0.9],
    610 => ["Graphics/Pictures/", "80_leeccubus_st01",0,0,-20,0.9],
    611 => ["Graphics/Pictures/", "80_evaq_st01",0,0,-20,0.9],
    612 => ["Graphics/Pictures/", "80_baphomet_st01",0,0,-20,0.9],
    613 => ["Graphics/Pictures/", "80_kudan_st01",0,0,-20,0.9],
    614 => ["Graphics/Pictures/", "80_vellraune_st01",0,0,-20,0.9],
    615 => ["Graphics/Pictures/", "80_nependeath_st01",0,0,0,0.8],
    616 => ["Graphics/Pictures/", "80_barakizoku_st01",0,0,-20,0.9],
    617 => ["Graphics/Pictures/", "80_bombslime_st01",0,0,-20,0.9],
    618 => ["Graphics/Pictures/", "80_liqurslime_st01",0,0,-20,0.9],
    619 => ["Graphics/Pictures/", "80_slimeprin_st01",0,0,-20,0.9],
    620 => ["Graphics/Pictures/", "80_asura_st01",0,0,-20,0.9],
    621 => ["Graphics/Pictures/", "80_gigaslime_st01",0,0,-20,0.9],
    622 => ["Graphics/Pictures/", "80_lamia_n_st01",0,0,-20,0.8],
    623 => ["Graphics/Pictures/", "80_l_medusa_st01",0,0,-20,0.9],
    624 => ["Graphics/Pictures/", "80_pandora_st01",0,0,-20,0.9],
    625 => ["Graphics/Pictures/", "80_utubom_st01",0,0,-20,0.9],
    626 => ["Graphics/Pictures/", "80_ancientscylla_st01",0,0,-20,0.8],
    627 => ["Graphics/Pictures/", "80_s_akaname_st01",0,0,-20,0.9],
    628 => ["Graphics/Pictures/", "80_nekogami_st01",0,0,-20,0.9],
    629 => ["Graphics/Pictures/", "80_kizin_st01",0,0,-20,0.9],
    630 => ["Graphics/Pictures/", "80_onmyosasori_st01",0,-50,-20,0.9],
    631 => ["Graphics/Pictures/", "80_caitsith_st01",0,0,-20,0.9],
    632 => ["Graphics/Pictures/", "80_galfox_st01",0,0,-20,0.9],
    633 => ["Graphics/Pictures/", "80_juraabis_st01",0,0,-20,0.9],
    634 => ["Graphics/Pictures/", "80_marchosias_st01",0,0,-20,0.9],
    635 => ["Graphics/Pictures/", "80_loccubus_st01",0,0,-20,0.9],
    636 => ["Graphics/Pictures/", "80_testarossa_st01",0,0,-20,0.9],
    637 => ["Graphics/Pictures/", "80_ek_mermaid_st01",0,0,-20,0.9],
    638 => ["Graphics/Pictures/", "80_greatmarman_st01",0,0,-20,0.9],
    639 => ["Graphics/Pictures/", "80_gigadryad_st01",0,0,-20,0.9],
    640 => ["Graphics/Pictures/", "80_arucubuss_st01",0,0,-20,0.9],
    641 => ["Graphics/Pictures/", "80_lesscubuss_st01",0,0,-20,0.9],
    642 => ["Graphics/Pictures/", "80_granabass_st01",0,0,-20,0.9],
    643 => ["Graphics/Pictures/", "80_hargenbeck_st21",0,0,-20,0.9],
    644 => ["Graphics/Pictures/", "80_santamaria_st11",0,0,-20,0.9],
    645 => ["Graphics/Pictures/", "80_elis_st01",0,0,-20,0.9],
    646 => ["Graphics/Pictures/", "80_shoutmata_st01",0,0,-20,0.9],
    647 => ["Graphics/Pictures/", "80_giantsarah_st01",0,0,-20,0.9],
    648 => ["Graphics/Pictures/", "80_paizuridoll2_st01",0,0,-20,0.8],
    649 => ["Graphics/Pictures/", "80_lovemata_st01",0,0,-20,0.8],
    650 => ["Graphics/Pictures/", "80_blavatsky_st01",0,0,-20,0.9],
    651 => ["Graphics/Pictures/", "80_aguni_st01",0,-30,-20,0.8],
    652 => ["Graphics/Pictures/", "80_miyabihime_st01",0,30,-20,0.8],
    653 => ["Graphics/Pictures/", "80_nanccubus_st01",0,0,-20,0.9],
    654 => ["Graphics/Pictures/", "80_pabilsag_st01",0,0,-20,0.9],
    655 => ["Graphics/Pictures/", "80_maneater_st01",0,0,-20,0.9],
    656 => ["Graphics/Pictures/", "80_kodairyu_st01",0,0,-20,0.9],
    657 => ["Graphics/Pictures/", "80_heavensgate_st01",0,0,-20,0.9],
    658 => ["Graphics/Pictures/", "80_niprell_st01",0,40,-20,0.9],
    659 => ["Graphics/Pictures/", "80_high_baphomet_st01",0,0,-20,0.9],
    660 => ["Graphics/Pictures/", "80_rogueelf_st01",0,0,-20,0.9],
    661 => ["Graphics/Pictures/", "80_gargoyle_st01",0,0,-20,0.9],
    662 => ["Graphics/Pictures/", "80_athena_st01",0,0,-20,0.9],
    663 => ["Graphics/Pictures/", "80_aun_st01",0,0,-20,0.9],
    664 => ["Graphics/Pictures/", "80_dragonhead_st01",0,-40,20,0.8],
    665 => ["Graphics/Pictures/", "80_monstruo_st01",0,-100,-20,0.9],
    666 => ["Graphics/Pictures/", "80_siva_st01",0,0,-20,0.9],
    667 => ["Graphics/Pictures/", "80_neptune_st01",0,0,-20,0.9],
    668 => ["Graphics/Pictures/", "80_tao_st01",0,0,-20,0.9],
    669 => ["Graphics/Pictures/", "80_moruboru_st01",0,0,-20,0.9],
    670 => ["Graphics/Pictures/", "80_a_pterix_st01",0,0,-20,0.8],
    671 => ["Graphics/Pictures/", "80_asmodeus_st01",0,0,-20,0.9],
    672 => ["Graphics/Pictures/", "80_jormungand_st01",0,0,-20,0.9],
    674 => ["Graphics/Pictures/", "80_ambrosia_st01",0,0,-20,0.9],
    675 => ["Graphics/Pictures/", "80_loa_st01",0,0,-20,0.9],
    676 => ["Graphics/Pictures/", "80_ghatanothoa_st01",0,0,20,0.9],
    677 => ["Graphics/Pictures/", "80_grimoire_st01",0,0,-20,0.9],
    678 => ["Graphics/Pictures/", "80_minagi_st01",0,0,-20,0.9],
    679 => ["Graphics/Pictures/", "80_kanade_st01",0,0,-20,0.9],
    680 => ["Graphics/Pictures/", "80_hiruko_st01",0,0,-20,0.9],
    681 => ["Graphics/Pictures/", "80_kanon_st01",0,0,-20,0.9],
    682 => ["Graphics/Pictures/", "80_tamamo_st61",0,0,-20,0.9],
    683 => ["Graphics/Pictures/", "80_sazya_st01",0,0,-20,0.9],
    684 => ["Graphics/Pictures/", "80_alice0_st21",0,0,-20,0.9],
    685 => ["Graphics/Pictures/", "80_alice0_st01",0,-40,-20,0.9],
    686 => ["Graphics/Pictures/", "80_alice0_st11",0,0,-20,0.9],
    692 => ["Graphics/Pictures/", "80_adramelek_st11",0,0,-20,0.9],
    693 => ["Graphics/Pictures/", "80_adramelek_st21",0,0,-20,0.9],
    694 => ["Graphics/Pictures/", "80_adramelek_st31",0,0,-20,0.9],
    695 => ["Graphics/Pictures/", "80_kureo_adora_st01",0,0,-20,0.9],
    696 => ["Graphics/Pictures/", "80_sirousagi_st01",0,0,-20,0.9],
    697 => ["Graphics/Pictures/", "80_apiro_ragos_st01",0,0,-20,0.9],
    698 => ["Graphics/Pictures/", "80_sinigami_st01",0,0,-20,0.9],
    699 => ["Graphics/Pictures/", "80_nihuta_telos_st01",0,0,-20,0.9],
    700 => ["Graphics/Pictures/", "80_idea_rukas_st01",0,0,-20,0.9],
    702 => ["Graphics/Pictures/", "80_nero_st01",0,0,0,0.8],
    703 => ["Graphics/Pictures/", "80_nero_st11",0,0,0,0.8],
    704 => ["Graphics/Pictures/", "80_neris_st01",0,0,-20,0.9],
    705 => ["Graphics/Pictures/", "80_neris_st11",0,0,-20,0.9],
    706 => ["Graphics/Pictures/", "80_nurukox_st01",0,0,-20,0.9],
    707 => ["Graphics/Pictures/", "80_chaos_st01b",0,0,-20,0.9],
    709 => ["Graphics/Pictures/", "80_alice8th_st01",0,0,-20,0.9],
    710 => ["Graphics/Pictures/", "80_alice8th2_st01",0,0,-20,0.9],
    711 => ["Graphics/Pictures/", "80_alice8th3_st01",0,0,-20,0.9],
    712 => ["Graphics/Pictures/", "80_alice8th4_st01",0,0,-20,0.9],
    713 => ["Graphics/Pictures/", "80_alice8th6_st01",0,0,-20,0.9],
    714 => ["Graphics/Pictures/", "80_alice8th5_st01",0,0,-20,0.9],
    715 => ["Graphics/Pictures/", "80_alice8thx01_st01",0,0,-20,0.9],
    716 => ["Graphics/Pictures/", "80_alice8thx01_st02",0,0,-20,0.9],
    717 => ["Graphics/Pictures/", "80_alice8thx01_st03",0,0,-20,0.9],
    718 => ["Graphics/Pictures/", "80_alice8thx01_st04",0,0,-20,0.9],
    719 => ["Graphics/Pictures/", "80_alice8thx01_st05",0,0,-20,0.9],
    720 => ["Graphics/Pictures/", "80_alice8thx01_st06",0,0,-20,0.9],
    721 => ["Graphics/Pictures/", "80_alice8thx01_st07",0,0,-20,0.9],
    722 => ["Graphics/Pictures/", "80_alice8thx01_st08",0,0,-20,0.9],
    723 => ["Graphics/Pictures/", "80_alice8thx01_st09",0,0,-20,0.9],
    724 => ["Graphics/Pictures/", "80_alice8thx01_st10",0,0,-20,0.9],
    725 => ["Graphics/Pictures/", "80_alice8thx01_st11",0,0,-20,0.9],
    726 => ["Graphics/Pictures/", "80_alice8thx01_st12",0,0,-20,0.9],
    727 => ["Graphics/Pictures/", "80_alice8thx01_st13",0,0,-20,0.9],
    728 => ["Graphics/Pictures/", "80_alice8thx01_st14",0,0,-20,0.9],
    729 => ["Graphics/Pictures/", "80_alice8thx01_st15",0,0,-20,0.9],
    730 => ["Graphics/Pictures/", "80_alice3th_st01",0,0,-20,0.9],
    731 => ["Graphics/Pictures/", "80_alice3th_st11",0,0,20,0.8],
    732 => ["Graphics/Pictures/", "80_alice4th_st01",0,0,-20,0.9],
    733 => ["Graphics/Pictures/", "80_alice4th_st11",0,0,20,0.8],
    734 => ["Graphics/Pictures/", "80_alice5th_st01",0,0,-20,0.9],
    735 => ["Graphics/Pictures/", "80_alice5th_st11",0,0,20,0.8],
    736 => ["Graphics/Pictures/", "80_alice6th_st01",0,0,-20,0.9],
    737 => ["Graphics/Pictures/", "80_alice6th_st11",0,0,20,0.8],
    738 => ["Graphics/Pictures/", "80_alice7th_st01",0,0,-20,0.9],
    739 => ["Graphics/Pictures/", "80_alice7th_st11",0,0,20,0.8],
    740 => ["Graphics/Pictures/", "80_alice9th_st01",0,0,-20,0.9],
    741 => ["Graphics/Pictures/", "80_alice9th_st11",0,0,20,0.8],
    742 => ["Graphics/Pictures/", "80_alice10th_st01",0,0,-20,0.9],
    743 => ["Graphics/Pictures/", "80_alice10th_st11",0,-50,20,0.8],
    744 => ["Graphics/Pictures/", "80_alice11th12th_st01",0,0,-20,0.9],
    745 => ["Graphics/Pictures/", "80_alice11th_st01",0,50,20,0.8],
    746 => ["Graphics/Pictures/", "80_alice12th_st01",0,-30,20,0.8],
    747 => ["Graphics/Pictures/", "80_alice13th_st01",0,0,-20,0.9],
    748 => ["Graphics/Pictures/", "80_alice13th_st11",0,0,20,0.8],
    749 => ["Graphics/Pictures/", "80_alice14th_st01",0,0,-20,0.9],
    750 => ["Graphics/Pictures/", "80_alice14th_st11",0,0,20,0.8],
    751 => ["Graphics/Pictures/", "80_alice15th_st51",0,0,-20,0.9],
    752 => ["Graphics/Pictures/", "80_alice15th_st61",0,0,-20,0.9],
    753 => ["Graphics/Pictures/", "80_seitentaisei_st01",0,0,-20,0.9],
    754 => ["Graphics/Pictures/", "80_coatlus_st01",0,0,-20,0.9],
    755 => ["Graphics/Pictures/", "80_tezcatlipoca_st01",0,0,-20,0.9],
    756 => ["Graphics/Pictures/", "80_azidahaka_st01",0,0,-20,0.9],
    757 => ["Graphics/Pictures/", "80_tukumokomati_st01",0,0,-20,0.9],
    758 => ["Graphics/Pictures/", "80_izanami_st01",0,0,-20,0.9],
    759 => ["Graphics/Pictures/", "80_deusex_st21",0,0,-20,0.9],
    760 => ["Graphics/Pictures/", "80_deusex_st01",0,0,-50,0.9],
    761 => ["Graphics/Pictures/", "80_sigurd_st11",0,0,-50,1.0],
    762 => ["Graphics/Pictures/", "80_frederika_st31",0,0,-20,0.9],
    763 => ["Graphics/Pictures/", "80_chromg_st01",0,0,0,0.8],
    764 => ["Graphics/Pictures/", "80_chromg_st11",0,0,-20,0.8],
    765 => ["Graphics/Pictures/", "80_chromdoll_st21",0,0,-20,0.9],
    766 => ["Graphics/Pictures/", "80_shirom_st81",0,0,-20,0.9],
    767 => ["Graphics/Pictures/", "80_kagetumugi_st01",0,0,-20,0.9],
    768 => ["Graphics/Pictures/", "80_kagetumugi2_st01",0,0,-20,0.9],
    769 => ["Graphics/Pictures/", "80_kagetumugi_st11",0,0,-20,0.9],
    770 => ["Graphics/Pictures/", "80_kagetumugi_st21",0,0,-20,0.9],
    771 => ["Graphics/Pictures/", "80_kagetumugi_st31",0,0,-20,0.9],
    772 => ["Graphics/Pictures/", "80_kagetumugi2_st11",0,40,-20,0.8],
    773 => ["Graphics/Pictures/", "80_gob_st11",0,0,-20,0.9],
    774 => ["Graphics/Pictures/", "80_pramia_st31",0,0,-20,0.9],
    775 => ["Graphics/Pictures/", "80_vgirl_st21",0,0,-20,0.9],
    776 => ["Graphics/Pictures/", "80_dragonp_st21",0,0,-20,0.9],
    777 => ["Graphics/Pictures/", "80_phoenixc_st01",0,0,-20,0.9],
    778 => ["Graphics/Pictures/", "80_phoenixb_st01",0,0,-20,0.9],
    779 => ["Graphics/Pictures/", "80_gigantweapon_st01",0,50,-20,0.9],
    780 => ["Graphics/Pictures/", "80_nephilim_st01",0,0,-20,0.9],
    781 => ["Graphics/Pictures/", "80_angolmois_st01",0,0,-20,0.9],
    782 => ["Graphics/Pictures/", "80_magatuomikami_st01",0,0,-20,0.9],
    783 => ["Graphics/Pictures/", "80_singularity_st21",0,0,-20,0.9],
    784 => ["Graphics/Pictures/", "80_worlddrown_st01",0,0,-20,0.9],
    785 => ["Graphics/Pictures/", "80_queenmoss_st01",0,0,-20,0.9],
    786 => ["Graphics/Pictures/", "80_queenmoss_st11",0,0,-20,0.9],
    787 => ["Graphics/Pictures/", "80_dragonbone_st01",0,-40,20,0.8],
    788 => ["Graphics/Pictures/", "80_baal_zebub_st01",0,0,-20,0.9],
    789 => ["Graphics/Pictures/", "80_satan_st01",0,-50,-20,0.9],
    790 => ["Graphics/Pictures/", "80_skyuba_st01",0,0,-20,0.9],
    791 => ["Graphics/Pictures/", "80_echidna_st01",0,0,-20,0.9],
    792 => ["Graphics/Pictures/", "80_cthulhu_st01b",0,0,0,0.9],
    793 => ["Graphics/Pictures/", "80_zigen_boss_st11",0,0,-20,1.0],
    794 => ["Graphics/Pictures/", "80_darkphenix_st01",0,30,-40,1.0],
    795 => ["Graphics/Pictures/", "80_hosikui_st01",0,0,-20,0.9],
    796 => ["Graphics/Pictures/", "80_koron_st01",0,0,-20,0.8],
    797 => ["Graphics/Pictures/", "80_mazin_st01b",0,0,-20,0.9],
    798 => ["Graphics/Pictures/", "80_kizin2_st01b",0,0,-20,0.9],
    799 => ["Graphics/Pictures/", "80_megami_st01b",0,0,-20,0.9],
    801 => ["Graphics/Pictures/", "80_lars_st01",0,0,-20,0.9],
    802 => ["Graphics/Pictures/", "80_rovissa_st01",0,0,-20,0.9],
    803 => ["Graphics/Pictures/", "80_est_st01",0,0,-20,0.9],
    804 => ["Graphics/Pictures/", "80_myuska_st11",0,0,-20,0.9],
    805 => ["Graphics/Pictures/", "80_nemea_st01",0,0,-20,0.9],
    806 => ["Graphics/Pictures/", "80_vinum_st01",0,0,-20,0.9],
    807 => ["Graphics/Pictures/", "80_lawrat_st01",0,0,-20,0.9],
    808 => ["Graphics/Pictures/", "80_rejeo_st01",0,0,-20,0.9],
    809 => ["Graphics/Pictures/", "80_fulbeua_st01",0,0,-20,0.9],
    810 => ["Graphics/Pictures/", "80_gilgoon_st01",0,0,-20,0.9],
    811 => ["Graphics/Pictures/", "80_byakunen_st01",0,0,-20,0.9],
    812 => ["Graphics/Pictures/", "80_magatu_st01",0,0,-20,0.9],
    813 => ["Graphics/Pictures/", "80_youkosan_st01",0,0,-20,0.9],
    814 => ["Graphics/Pictures/", "80_daimeikai_st01",0,0,-20,0.9],
    815 => ["Graphics/Pictures/", "80_kazuya_st01",0,0,-20,0.9],
    816 => ["Graphics/Pictures/", "80_lanpass_st01",0,0,-20,0.9],
    817 => ["Graphics/Pictures/", "80_mukuro_st01",0,0,-20,0.9],
    818 => ["Graphics/Pictures/", "80_dakki_st01",0,0,-20,0.9],
    819 => ["Graphics/Pictures/", "80_rest_st01",0,0,-20,0.9],
    820 => ["Graphics/Pictures/", "80_bell_st01",0,0,-20,0.9],
    821 => ["Graphics/Pictures/", "80_lira_st01",0,0,-20,0.9],
    822 => ["Graphics/Pictures/", "80_muzet_st01",0,0,-20,0.9],
    823 => ["Graphics/Pictures/", "80_nobissa_st01",0,0,-20,0.9],
    824 => ["Graphics/Pictures/", "80_tarsa_st01",0,0,-20,0.9],
    825 => ["Graphics/Pictures/", "80_tarsa_st11",0,0,-20,0.9],
    826 => ["Graphics/Pictures/", "80_executioner_st01",0,0,-20,0.9],
    827 => ["Graphics/Pictures/", "80_ogretooth_st01",0,0,-20,0.9],
    828 => ["Graphics/Pictures/", "80_mistilteinn_st01",0,0,-20,0.9],
    829 => ["Graphics/Pictures/", "80_succubusq_st01",0,0,-20,0.9],
    830 => ["Graphics/Pictures/", "80_succubusm_st01",0,0,-20,0.9],
    831 => ["Graphics/Pictures/", "80_succubusj_st01",0,0,-20,0.9],
    832 => ["Graphics/Pictures/", "80_amabie_st01",0,0,-20,0.9],
    833 => ["Graphics/Pictures/", "80_amabie_st11",0,0,-20,0.9],
    834 => ["Graphics/Pictures/", "80_cassandra_st51",0,0,-20,0.9],
    835 => ["Graphics/Pictures/", "80_cassandra_st61",0,0,-20,0.9],
    836 => ["Graphics/Pictures/", "80_lily_st21",0,0,-20,0.9],
    837 => ["Graphics/Pictures/", "80_lusia_st21",0,0,-20,0.9],
    838 => ["Graphics/Pictures/", "80_nyumaou_st11",0,20,0,0.9],
    839 => ["Graphics/Pictures/", "80_witchs_st21",0,0,-20,0.9],
    840 => ["Graphics/Pictures/", "80_queenvanpire_st31",0,0,-20,0.9],
    841 => ["Graphics/Pictures/", "80_ex_sonia_st01",0,0,-20,0.9],
    842 => ["Graphics/Pictures/", "80_ex_sonia_st11",0,0,-20,0.9],
    843 => ["Graphics/Pictures/", "80_soniamazda_st01",0,0,-20,0.9],
    844 => ["Graphics/Pictures/", "80_soniamanyu_st01",0,0,-20,0.9],
    845 => ["Graphics/Pictures/", "80_soniachaos_st01",0,0,-20,0.9],
    846 => ["Graphics/Pictures/", "80_ex_sonia_st21",0,0,-20,0.9],
    848 => ["Graphics/Pictures/", "80_s_gyokuza_st01",0,0,-20,0.9],
    849 => ["Graphics/Pictures/", "80_doubleundead_st01",0,0,-20,0.9],
    850 => ["Graphics/Pictures/", "80_izun_st01",0,0,-20,0.9],
    851 => ["Graphics/Pictures/", "80_carthangels_st01",0,0,-20,0.9],
    852 => ["Graphics/Pictures/", "80_algemini_st01",0,0,-20,0.9],
    853 => ["Graphics/Pictures/", "80_elgemini_st01",0,0,-20,1.0],
    854 => ["Graphics/Pictures/", "80_shemhaza_st01",0,0,-20,0.9],
    855 => ["Graphics/Pictures/", "80_agrave_st01",0,0,-20,0.9],
    856 => ["Graphics/Pictures/", "80_starma_st01",0,0,-20,0.9],
    857 => ["Graphics/Pictures/", "80_rajara_st01",0,0,-20,0.9],
    858 => ["Graphics/Pictures/", "80_megidryad_st01",0,0,-20,0.9],
    859 => ["Graphics/Pictures/", "80_exsera_st01",0,0,-20,0.9],
    860 => ["Graphics/Pictures/", "80_apsaras_st01",0,0,-20,0.9],
    861 => ["Graphics/Pictures/", "80_zoloct_st01",0,0,-20,0.9],
    862 => ["Graphics/Pictures/", "80_tiamat_st01",0,0,-20,0.9],
    863 => ["Graphics/Pictures/", "80_aptiel_st11",0,0,-20,0.9],
    864 => ["Graphics/Pictures/", "80_amnario_st01",0,0,-20,0.9],
    865 => ["Graphics/Pictures/", "80_samael_st01",0,0,20,0.8],
    866 => ["Graphics/Pictures/", "80_shadowassassin_st01",0,40,20,0.8],
    867 => ["Graphics/Pictures/", "80_unknown1_st01",0,0,20,0.8],
    868 => ["Graphics/Pictures/", "80_unknown2_st01",0,0,20,0.8],
    869 => ["Graphics/Pictures/", "80_unknown3_st01",0,0,20,0.8],
    870 => ["Graphics/Pictures/", "80_unknown4_st01",0,0,20,0.8],
    871 => ["Graphics/Pictures/", "80_unknown5_st01",0,0,20,0.8],
    872 => ["Graphics/Pictures/", "80_curseloreley_st01",0,0,-40,1.0],
    873 => ["Graphics/Pictures/", "80_voremermaid_st01",0,0,-20,0.9],
    874 => ["Graphics/Pictures/", "80_pazuzu_st01",0,0,0,0.9],
    875 => ["Graphics/Pictures/", "80_masutema_st01",0,0,-20,0.9],
    876 => ["Graphics/Pictures/", "80_amenohaduti_st01",0,0,-20,0.9],
    877 => ["Graphics/Pictures/", "80_hasyakusama_st01",0,0,-20,0.9],
    878 => ["Graphics/Pictures/", "80_gestalt_st01",0,0,-20,0.9],
    879 => ["Graphics/Pictures/", "80_hivemind_st01",0,0,-20,0.9],
    880 => ["Graphics/Pictures/", "80_madamlamia_st01",0,0,-20,0.9],
    881 => ["Graphics/Pictures/", "80_satanachia_st01",0,0,-50,1.0],
    882 => ["Graphics/Pictures/", "80_bloddydragon_st01",0,0,-20,0.9],
    883 => ["Graphics/Pictures/", "80_paizuridoll3_st01",0,0,0,0.8],
    884 => ["Graphics/Pictures/", "80_ironmaiden_s_st01",0,0,-20,0.9],
    885 => ["Graphics/Pictures/", "80_doll_itai_st01",0,0,-20,0.9],
    886 => ["Graphics/Pictures/", "80_magda_st01",0,0,-20,0.9],
    887 => ["Graphics/Pictures/", "80_sisel_st01",0,0,-20,0.9],
    888 => ["Graphics/Pictures/", "80_azazel_st01",0,0,-20,0.9],
    889 => ["Graphics/Pictures/", "80_grigori_st01",0,0,-20,0.9],
    890 => ["Graphics/Pictures/", "80_hakutenko_st01",0,0,-20,0.9],
    891 => ["Graphics/Pictures/", "80_myouhouzyorougumo_st01",0,0,-20,0.9],
    892 => ["Graphics/Pictures/", "80_houshi_st01",0,0,20,0.8],
    893 => ["Graphics/Pictures/", "80_spawn_st01",0,0,-20,0.9],
    894 => ["Graphics/Pictures/", "80_zigen_kenzoku_st01",0,0,-30,0.9],
    895 => ["Graphics/Pictures/", "80_zigen_kenzoku2_st01",0,0,-40,0.8],
    896 => ["Graphics/Pictures/", "80_outerjelly_st01",0,0,-20,0.9],
    897 => ["Graphics/Pictures/", "80_outerworm_st01",0,0,-40,0.9],
    898 => ["Graphics/Pictures/", "80_null_kenzoku_st01",0,0,-20,0.8],
    899 => ["Graphics/Pictures/", "80_null_kenzoku_st02",0,0,-20,0.8],
    900 => ["Graphics/Pictures/", "80_null_kenzoku_st03",0,0,-20,0.8],
    901 => ["Graphics/Pictures/", "80_TT_st01",0,0,-20,0.8],
    902 => ["Graphics/Pictures/", "80_QQ_st01",0,0,-20,0.9],
    903 => ["Graphics/Pictures/", "80_gran_arachne_st01",0,0,-20,0.9],
    904 => ["Graphics/Pictures/", "80_tonberi_st01",0,0,-20,0.9],
    905 => ["Graphics/Pictures/", "80_indora_st01",0,0,-20,0.9],
    906 => ["Graphics/Pictures/", "80_abaddon_st01",0,0,-20,0.9],
    907 => ["Graphics/Pictures/", "80_exkyubi_st01",0,0,-20,0.9],
    908 => ["Graphics/Pictures/", "80_dolladolla_st01",0,-30,10,0.9],
    909 => ["Graphics/Pictures/", "80_beelzebub_s_st01",0,0,-20,0.9],
    910 => ["Graphics/Pictures/", "80_merkava_st01",0,0,-20,0.9],
    911 => ["Graphics/Pictures/", "80_ozum_st01",0,0,-20,0.9],
    912 => ["Graphics/Pictures/", "80_agaliarept_st01b",0,0,-20,0.9],
    913 => ["Graphics/Pictures/", "80_gazer_st01",0,0,-20,0.9],
    914 => ["Graphics/Pictures/", "80_berial_st01b",0,0,-20,0.9],
    916 => ["Graphics/Pictures/", "80_hero_st01",0,0,-20,0.9],
    917 => ["Graphics/Pictures/", "80_hero_st11",0,0,-20,0.9],
    918 => ["Graphics/Pictures/", "80_hero_st21",0,0,-20,0.9],
    919 => ["Graphics/Pictures/", "80_hero4_st01",0,0,-20,0.9],
    920 => ["Graphics/Pictures/", "80_hero5_st01",0,0,-20,0.9],
    921 => ["Graphics/Pictures/", "80_hero6_st01",0,0,-20,0.9],
    922 => ["Graphics/Pictures/", "80_merlin_st11",0,0,-20,0.9],
    923 => ["Graphics/Pictures/", "80_merlin_st31",0,0,-20,0.9],
    924 => ["Graphics/Pictures/", "80_hero_st24",0,0,-20,0.9],
    925 => ["Graphics/Pictures/", "80_hero4_st11",0,0,-20,0.9],
    926 => ["Graphics/Pictures/", "80_hero6_st11",0,0,-20,0.9],
    927 => ["Graphics/Pictures/", "80_Karen_st01",0,0,-20,0.9],
    928 => ["Graphics/Pictures/", "80_kagetumugi_st82",0,0,-20,0.9],
  }
  # アクター固有アビリティの設定
  FIX_ABILITY_NAME = "Trait:"
  ACTOR_FIX_ABILITY = {
    1 => ["Hero's Blood",
      "Can always use Sword, Spear, Katana, Axe, Holy, Talk, and",
      "Heroism skills. Heroism skills deal +30% damage, gaining +2%",
      "damage for every % of missing HP.",
    ],
    2 => ["Crossdressing Hero",
      "Can always use Sword and Heroism skills. Heroism skills deal",
      "15% more damage, gaining +1% damage for every % of missing",
      "HP. Takes 50% less damage from Pleasure-element attacks.",
    ],
    3 => ["One Who Connects to the Abyss of Chaos",
      "Attack/Magic/Agility/Dexterity +100%. Deal +100% Carnage",
      "damage. Physical attacks deal Carnage damage. Can always use",
      "Sword, Holy, Dark, Heroism, and Chaos skills, dealing +75%",
      "damage. Can always use the skill Logos Magia. Holy skills use",
      "Attack in place of other stats. Heroism and Chaos skills gain",
      "+2% damage for every % of missing HP.",
    ],
    4 => ["Father of Chaos", #NOTE: Original description states crisis effect only applies to Heroism and Chaos skills, but notes indicate it also applies to Sword, Holy, and Dark skills.
      "Gets an additional action every turn. Deal +100% Carnage/",
      "Eternal/Demise damage. Physical attacks inflict Carnage,",
      "Eternal, and Demise damage. Can always use Sword, Holy,",
      "Dark, Heroism, and Chaos skills, dealing +100% damage,",
      "gaining +2% damage for every % of missing HP. Holy skills",
      "skills use Attack in place of other stats. Immune to all",
      "non-Chaos elements. Takes 25% damage from Chaos elements.",
      "Immune to Time Stop.",
    ],
    5 => ["Petite Monster Lord",
      "Can always use Black Magic, Dark, and Demon Arts skills.",
      "Skills that sacrifice health have 50% HP cost.",
    ],
    6 => ["Sixteenth Monster Lord",
      "Can always use Black Magic, Dark skills, and Demon Arts.",
      "Rapier, Black Magic, Dark, and Demon Arts skills deal",
      "+50% damage. Deal +50% Dark damage. Dark skills do not",
      "cost any HP.",
    ],
    7 => ["邪神の力を宿した者", #NOTE: Does not have Demise booster or composite damage in original actor notes
      "Deal +75% Demise damage. Physical and Dark attacks inflict",
      "Demise damage. Can always use Rapier, Black Magic, Dark, and",
      "Demon Arts skills, dealing +75% damage. Dark skills do not",
      "cost any HP. Immune to Dark damage, and takes halved damage",
      "from Eternal element. Chains Rapier skills into Rapier, then",
      "Demon Arts, then Dark skills.",
    ],
    9 => ["Destroyer of Worlds",
      "Gets an additional action every turn. Deal +100% Demise",
      "damage. Physical and Dark attacks deal Demise damage.",
      "Can always use Sword, Dark, and Heroism skills, dealing",
      "+100% damage. Immune to Holy, Dark, and Demise damage, and",
      "takes halved damage from Eternal element. Chains up to three",
      "Dark skills in a row.",
    ],
    10 => ["The One Who Judges",
      "Gets an additional action every turn. Deal +100% Eternal",
      "damage. Physical and Holy attacks deal Eternal damage. ",
      "Can always use Sword, Holy, and Heroism skills, dealing",
      "+100% damage. Holy skills can use Attack in place of other",
      "stats. Immune to Holy, Dark, and Demise damage, and takes",
      "halved damage from Demise element. Chains up to three Holy",
      "skills in a row.",
    ],
    12 => ["Wind Spirit",
      "Deal +30% Wind damage. Can always use Thievery and Nature",
      "skills. Gain Devastating Gale status (+200% Accuracy, 100%",
      "Evasion/50% Magic Evasion) while below 20% HP. Absorb Wind",
      "damage. +15% to all stats for each of the Four Spirits in",
      "the main party.",
    ],
    13 => ["Earth Spirit",
      "Deal +30% Earth damage. Can always use Club, Unarmed, and",
      "Nature skills. Unarmed skills can use Attack in place of",
      "Agility. Gain Wild Lands status (+100% Defense/Critical Rate/",
      "Magical Critical Rate) while below 20% HP. Absorb Earth",
      "damage. +15% to all stats for each of the Four Spirits in", 
      "the party.",
    ],
    14 => ["Water Spirit",
      "Deal +30% Water damage. Can always use White Magic, Slime,",
      "and Nature skills, dealing +30% damage. Absorb Water damage.",
      "Immune to Slimed. Slime skills can use Willpower in place of",
      "other stats. +15% to all stats for each of the Four Spirits", 
      "in the main party.",
    ],
    15 => ["Fire Spirit",
      "Deal +30% Fire damage. Can always use Unarmed, Breath, and",
      "Nature skills. Unarmed & Nature skills deal +30% damage.",
      "Innate Burn Strike 30%. Absorb Fire Damage. Immune to Burn.",
      "Unarmed skills deal +100% damage to Burning foes. +15% to",
      "all stats for each of the Four Spirits in the main party.",
    ],
    16 => ["Peerless Monster Swordswoman",
      "Innate Carnage Strike. Deal +50% Carnage damage. Can always",
      "equip Swords, Knight Swords, Great Swords, and Katana. Can",
      "always use Sword and Katana skills, dealing +50% damage with",
      "increased priority and persistence, and gaining +2% damage",
      "for every % of missing HP. Deal +30% damage to and take 50%",
      "less damage against Bosses. Starts the battle with Serene",
      "Mind.",
    ],
    17 => ["Peerless Magical Girl",
      "Innate Galactic Strike. Deal +50% Galactic damage. Can always",
      "equip Magic Swords, Rods, Robes, and Magic Hats. Justice",
      "skills have increased priority and persistence. 50% of Magic",
      "is added to Justice skill power. Magic Justice skills deal",
      "+75% damage. Innate Magic and Pleasure/Nightmare reflection.",
      "Automatically use Ultimate Change at the start of battle.",
      "battle.",
    ],
    19 => ["Fist of the Queen Succubus",
      "Deal +50% Pleasure damage. Can always equip Fists.",
      "Can always use Unarmed and Sexcraft skills. Unarmed skills",
      "deal +50% damage and can use Dexterity in place of Attack.",
      "Immune to Climax and Instant Death.",
    ],
    21 => ["Nine-tailed Kitsune",
      "Max HP and Defense +50%. Can always equip Rods, Fans, Magic",
      "Hats, and Robes. Can always use White Magic, Black Magic,",
      "Time Magic, Summoning, Taoism, and Ninjutsu skills.",
      "White Magic, Black Magic, Taoism, and Ninjutsu deal +30%",
      "heal 30% more HP, and have 50% MP/SP cost. Magic skills and",
      "Ninjutsu execute an additional time. Ninjutsu skills can use",
      "Magic in place of other stats. Automatically use Wild Lands",
      "at the start of battle.",
    ],
    22 => ["True Nine-tailed Kitsune",
      "Max HP/Defense +100%, other stats +50%. Can always equip",
      "Rods/Fans/Magic Hats/Robes. Fire/Earth attacks also inflict",
      "their respective chaos damage. Starts battles at 100% SP,",
      "-20% MP/SP each turn, cannot regen MP/SP. Can always use",
      "White/Black/Taoism/Ninjutsu, dealing +75% damage, and Time/",
      "Beast/Summoning skills. Magic and Ninjutsu execute two more",
      "times. Ninjutsu can use Magic. Chains Beast into Taoism then",
      "Ninjutsu/Dancing then Fan skill. Automatic Wild Lands status.",
    ],
    23 => ["Protector of Kin",
      "Can always equip Boomerangs, Bucklers, Shields, and Heavy",
      "Shields. Can always use Throwing, Medicine, and Slime skills.",
      "Throwing and Slime skills deal +50% damage (+150% to Slimed",
      "and debuffed foes), can use Defense in place of other stats,",
      "and have persistence. Takes halved damage from Physical and",
      "Pleasure elements.",
    ],
    24 => ["Bearer of Kanade's Cells",
      "Gets an additional action every turn. Can always equip",
      "Boomerangs, Bucklers, Shields, and Heavy Shields.",
      "Can always use Throwing, Medicine, and Slime skills.",
      "Throwing and Slime skills deal +50% damage and can use",
      "Defense in place of other stats. Takes halved damage from",
      "Physical and Pleasure elements.",
    ],
    26 => ["Goddess of Creation",
      "Can always use White Magic and Holy skills.",
      "Skills that deal Holy damage have 50% MP cost.",
    ],
    27 => ["Goddess of Creation",
      "Deal 75% Eternal damage and pierce Eternal resistance.",
      "Physical and Holy attacks inflict Eternal damage. Can always",
      "equip Staves and Bows. Can always use Bow, White Magic, Holy,",
      "and Medicine skills. Bow, White Magic, and Holy skill deal",
      "+75% damage. Holy skills consume no MP. Immune to Holy damage",
      "and takes halved damage from Eternal element. Chains White",
      "Magic into White Magic or Medicine, then Bow, then Holy",
      "skills.",
    ],
    28 => ["Chaos Goddess of Creation",
      "Gets an additional action every turn. Deal +100% Eternal",
      "damage and pierce Eternal resistance. Physical and Holy",
      "attacks inflict Eternal damage. Can always equip Staves and",
      "Bows. Can always use Bow, White Magic, and Holy skills,",
      "dealing +100% damage but have 133% SP/MP cost. Holy skills",
      "consume no MP. Immune to Holy and Dark damage and takes",
      "halved damage from Eternal and Demise elements. Chains Bow",
      "skills into White Magic then Holy skills.",
    ],
    29 => ["Goddess of Creation",
      "Deal +75% Eternal damage and pierce Eternal resistance.",
      "Physical and Holy attacks inflict Eternal damage. Can always",
      "equip Staves and Bows. Can always use Bow, White Magic, and",
      "Holy skills, dealing +75% damage. Holy skills consume no",
      "MP. Immune to Holy damage and takes halved damage from",
      "Eternal element. Chains White Magic into White Magic or",
      "Medicine, then Bow, then Holy skills.",
    ],
    30 => ["Goddess of Chaos",
      "Gets an additional action every turn. Deal +100% Eternal",
      "damage and pierce eternal resistance. Physical and Holy",
      "attacks inflict Eternal damage. All skills have 150%",
      "MP/SP cost. Can always equip Staves and Bows. Can always",
      "use Bow, White Magic, Holy, Dark, and Chaos skills, dealing",
      "+100% damage. Immune to Holy and Dark damage and takes halved",
      "damage from Eternal and Demise elements. Chains White Magic",
      "skills into Bow, then Holy, then Dark, then Chaos skills.",
    ],
    32 => ["Commander of Heaven's Army",
      "Can always equip Swords and Knight Swords. Holy attacks",
      "also inflict Eternal damage. Deal +100% Eternal damage.",
      " Can always use Sword, Spear, and Holy skills,  dealing",
      "+100% damage. Spear and Holy skills can use Attack in place of",
      "other stats. Holy skills chain into Spear, then Sword skills.",
    ],
    33 => ["Fallen Commander",
      "Can always equip Swords and Knight Swords. Innate Carnage",
      "Strike. Deal +100% Carnage damage. Can always use Sword,",
      "Spear, and Holy skills, dealing +100% damage. Spear and Holy",
      "skills can use Attack in place of other stats. Dark skill",
      "HP cost is reduced by 50%. Holy skills chain into Spear,",
      "then Sword skills.",
    ],
    34 => ["Angel Commander",
      "Deal +30% Holy damage. Can always use Sword, Spear, and Holy",
      "skills, dealing +30% damage. Spear and Holy skills can use",
      "Attack in place of other stats. Heavenly Blade deals +2%",
      "damage for every % of missing HP. +15% to all stats if",
      "Lucifina-chan is in the main party.",
    ],
    35 => ["The Daystar",
      "Can always equip Bows. Holy attacks inflict Eternal damage as",
      "well. Deal +100% Eternal damage. Can always use Bow, White",
      "Magic, Black Magic, and Holy skills, dealing +100% damage and",
      "healing 100% more HP. Bow, Black Magic, and Holy skills can",
      "use Dexterity in place of other stats. Dark skill HP cost is",
      "reduced by 50%. Holy skills chain into Black Magic, then Bow",
      "skills.",
    ],
    36 => ["Morning Star",
      "Deal +30% Holy damage. Can always use White and Black Magic,",
      "Holy, and Bow skills, dealing +30% damage. Bow, Black Magic,",
      "and Holy skills can use Dexterity in place of other stats.",
      "Morning Star deals +2% damage for every % of missing HP.",
      "+15% to all stats if Micaela-chan is in the main party.",
    ],
    37 => ["True Mad Scientist Angel",
      "Can always equip Scalpels and Grimoires. Can always use Holy,",
      "Magic Science, Makina, and Medicine skills. Magic Science,",
      "Makina, and Medicine skills deal +50% damage (+100% to",
      "Chimeras). Magic Science and Medicine skills deal +1% damage",
      "for every % of missing HP. Chains Magic Science or Makina",
      "skills into Medicine skills.",
    ],
    38 => ["Monster Seaweed Mad Scientist Angel",
      "Can always equip Scalpels and Grimoires. Can always use Magic",
      "Science, Medicine, and Plant skills, dealing +75% damage",
      "(+100% to Chimeras) but have 133% SP cost. Magic Science and",
      "Medicine skills deal +1% damage for every % of missing HP.",
      "Chains Magic Science and Medicine skills into Plant skills.",
    ],
    39 => ["Rampaging Seaweed Mad Scientist Angel",
      "Can always equip Scalpels and Grimoires. Can always use Magic",
      "Science, Medicine, Plant, and Giant skills, dealing +75%",
      "damage, gaining +2% damage for every % of missing HP, but",
      "have 133% SP cost. Chains Magic Science or Medicine skills",
      "into Plant or Giant skills.",
    ],
    40 => ["Ultimate Fusion Mad Scientist Angel",
      "Defense/Agility +50%, Evasion/Magic Evasion/Auto-Hit",
      "Evasion +15%. Can always equip Scalpels, Grimoires, and Guns.",
      "Can always use Gun, Magic Science, Makina, Medicine, and",
      "Artificial skills, dealing +75% damage (+100% to Chimeras,",
      "Roids, and Giants), gaining +2% damage for every % of missing",
      "HP. Chains Magic Science or Medicine skills into Gun, then",
      "Makina, then Artificial skills.",
    ],
    41 => ["Mad Scientist Angel",
      "Can always use Holy, Magic Science, and Medicine skills.",
      "Magic Science skills deal +30% damage, gaining +1% damage for",
      "every % of missing HP.",
    ],
    45 => ["Pretend Mage",
      "Deal +30% Dark damage. Can always use Black Magic, Time",
      "Magic, and Dark skills. Black Magic and Time Magic execute",
      "an additional time but have 150% MP cost.",
    ],
    53 => ["Boomerang Love",
      "Can always equip Boomerangs and use Throwing and Slime",
      "skills. Throwing skills deal +30% damage (+100% to Slimed",
      "foes).",
    ],
    54 => ["Self-Proclaimed Rabbit",
      "+30% Agility. Can always use Beast and Slime skills.",
      "Beast skills deal +100% damage to Slimed foes.",
    ],
    55 => ["Slimy Slug",
      "Can always use Sword and Slime skills. Can always equip",
      "Dresses and Skimpy armor. Innate Slimed Strike 50%.",
      "Immune to Slimed status. Sword skills deal +100% damage to",
      "Slimed foes. +15% to all stats if Elisabeth is in the main",
      "party.",
    ],
    56 => ["Pyro Imp",
      "Deal +30% Fire damage. Can always use Black Magic and",
      "Sexcraft skills. Black Magic deals +100% damage to Burned",
      "foes and has 66% MP cost. +15% to all stats if Remi and/or",
      "Rumi is in the main party.",
    ],
    57 => ["Grappler Imp",
      "Can always use Unarmed and Sexcraft skills. Unarmed skills",
      "deal +15% damage and have a 30% chance to inflict Horny.",
      "+15% to all stats if Rami, Remi, and/or Alma Elma is in the",
      "main party.",
    ],
    58 => ["Timid Imp",
      "Can always use White Magic and Sexcraft skills. Targeted by",
      "foes 75% as often. Gain +75% Evasion for 4 turns when",
      "falling below 20% HP. Curative White Magic imparts Dexterity",
      "Up. +15% to all stats if Rami and/or Rumi is in the main",
      "party.",
    ],
    59 => ["Mandragora Heart",
      "Innate Paralysis Strike 15%. Can always use Singing and",
      "Plant skills. Immune to Sonic damage, Paralysis, and",
      "Confusion. Singing skills have +15% status infliction rate.",
      "Has a 33% chance to perform a Mandragora Scream at the start",
      "of battle.",
    ],
    60 => ["Dog Girl",
      "Innate Stun Strike 20%. Can always use Beast skills.",
      "+500 Speed when using normal attacks. Immune to Stun.",
      "33% chance to dig a hole at the end of each turn.",
      "+15% to all stats for each Beast-type monster in the main",
      "party.",
    ],
    61 => ["Sticky Earthworm",
      "Can always use Snake and Slime skills.",
      "Innate Slimed Strike 50%. Immune to Earth and Slimed.",
      "33% chance to dig a hole at the end of each turn.",
      "Snake skills deal +100% damage to Slimed foes.",
    ],
    62 => ["Zazoom Bandit!",
      "+30% Agility, +15% Critical/Evasion Rate. Can always equip",
      "Clubs. Can always use Club and Thievery skills. +15% to all",
      "stats for each Former Bandit in the main party.",
    ],
    63 => ["Greedy Oni",
      "+30% Agility, +15% Critical/Evasion Rate. Can always equip",
      "Clubs. Can always use Club and Thievery skills, dealing +30%",
      "danage with 50% SP cost. +15% to all stats for each Former",
      "Bandit in the party. Starts the battle with Power of Greed",
      "(XP/Job XP/Gold/Item Drop Rate x2).",
    ],
    64 => ["Petite Maid Bandit",
      "Can always equip Plates. Can always use Cooking, Service,",
      "Thievery, and Snake skills. Service skills deal +15% damage.",
      "+15% to all stats for each Former Bandit in the main party.",
    ],
    65 => ["Greedy Lamia",
      "Can always equip Plates. Can always use Thievery, Cooking,",
      "Service, and Snake skills Thievery, Service, and Snake skills",
      "deal +30% damage with 50% SP cost. +15% to all stats for each",
      "Former Bandit in the party. Starts the battle with Power of",
      "Greed (XP/Job XP/Gold/Item Drop Rate x2).",
    ],
    66 => ["Item Bandit",
      "Can always use Mercantile, Thievery, and Demon Arts.",
      "150% steal and item drop rate.",
      "+15% to all stats for each Former Bandit in the main party.",
    ],
    67 => ["Greedy Vampire",
      "Can always use Thievery, Mercantile, and Demon Arts skills.",
      "Thievery and Demon Arts skills inflict +30% damage with 50%",
      "SP cost. 150% Steal Success and Item Drop Rate. +15% to all",
      "stats for each Former Bandit in the party. Starts the battle",
      "with Power of Greed (XP/Job XP/Gold/Item Drop Rate x2).",
    ],
    68 => ["Brawler Bandit",
      "Can always use Thievery, Beast, and Breath skills. While",
      "below 20% HP, enter a Rumble state (All Stats +50%, Combat/",
      "Racial skills execute an additional time, but become",
      "uncontrollable.) +15% to all stats for each Former Bandit in",
      "the party.",
    ],
    69 => ["Greedy Dragon",
      "Can always use Thievery, Beast, and Breath skills, dealing",
      "+30% damage with 50% SP cost. While below 20% HP, enter a",
      "Rumble state (All Stats +50%, Combat/Racial skills execute an",
      "additional time, but become uncontrollable.) +15% to all",
      "stats for each Former Bandit in the party. Starts the battle",
      "with Power of Greed (XP/Job XP/Gold/Item Drop Rate x2).",
    ],
    70 => ["Biohazard Rat",
      "Innate Bio Strike and Poison Strike 30%. Can always use",
      "Beast skills. Deal +30% Bio damage. Immune to Bio damage",
      "and Poison status. Beast skills deal +100% damage to",
      "Poisoned foes.",
    ],
    71 => ["Vanishing Wolf",
      "+15% Critical/Evasion Rate. Can always use Beast skills,",
      "dealing +30% damage and gaining +50% Evasion for 4 turns.",
    ],
    72 => ["Phoenix Soul",
      "Can always use Wing, Beast, and Breath skills.",
      "Once per fight, revive with 50% HP when defeated.",
      "Immune to Fire damage and Burn status.",
      "Wing skills deal +1% damage for every % of missing HP.",
    ],
    73 => ["Leech of Leeches",
      "+20% Counter Rate. Can always use Sword and Slime skills.",
      "Innate Bind Strike 20%. Immune to Slimed.",
      "Sword skills use the highest of Dexterity or Attack.",
      "Special skills that drain HP deal +30% damage.",
      "Counterattacks with Drain Hole.",
    ],
    74 => ["Hunter Bunny",
      "+30% Dexterity. Can always equip Hats, Bucklers, Clothes,",
      "Gi, Dresses, and Skimpy armor. Can always use Bow skills.",
      "Bow skills deal +30% damage and have a 30% chance to inflict",
      "Blind and Agility Down.",
    ],
    75 => ["Drunkard Sheep",
      "+25% Counter rate, +20% Critical Rate. Targeted by foes 75%",
      "as often. 10% chance to use Drunken Boxing instead of",
      "following orders (These effects are a removable ability).",
      "Can always use Beast skills. +15% to all stats if Barbun is",
      "in the main party.",
    ],
    76 => ["Lively Bubbles",
      "Innate Slimed Strike 50%. +15% Evasion. Can always use Ocean",
      "and Artificial skills. Skills using bubbles deal +30% damage",
      "(+100% to Slimed foes).",
    ],
    77 => ["Laser Eye & Scissor Legs",
      "Innate Shock/Bind Strike 15%. Can always use Makina and",
      "Artificial skills. Makina skills deal +100% damage to",
      "Shocked and/or Bound foes.",
    ],
    78 => ["Floating Girl",
      "+30% Max HP. +20% Evasion/Magic Evasion. Can always use",
      "Black Magic, Insect, and Artificial skills. Insect skills",
      "that drain HP have 50% SP cost and deal +30% damage",
    ],
    79 => ["Mysterious Being",
      "Innate Slimed Strike 50%. Can always use Tentacle skills,",
      "dealing +30% damage. Nullify attacks dealing 30 damage or",
      "less.",
    ],
    80 => ["An Orc Came To Town!",
      "Can always equip Hats, Helmets, Bucklers, Shields, Clothes,",
      "Breastplates, Armor, and Skimpy armor.",
      "Can always equip Clubs and use Club skills.",
      "Gain +20% to all stats while in towns.",
      "Club skills deal +1% damage for every % of missing HP.",
    ],
    81 => ["Honey Stinger",
      "Can always use Insect skills, dealing +100% damage to",
      "Poisoned foes. Skills using stingers have 50% SP cost and",
      "deal +30% damage. +15% to all stats if Miria is in the main",
      "party.",
    ],
    82 => ["Dancing Sparrow",
      "Can always use Dancing and Wing skills.",
      "Targeted by foes 75% as often. Immune to Sleep.",
      "+50% Evasion/+30% Magic Evasion when using dances.",
      "25% chance of using Sparrow Dance at the end of each turn.",
    ],
    83 => ["Sky Dancer",
      "Can always use Dancing and Wing skills. Dancing skills have",
      "66% SP cost, +15% status infliction rate, and increased",
      "priority.",
    ],
    84 => ["Close Sisters",
      "Can always use Wing skills. Normal attacks gain an extra hit.",
      "Wing skills execute an additional time, but have 150% SP cost."
    ],
    85 => ["Slimy Girl",
      "Can always equip Dresses and Skimpy armor. Can always use",
      "Rapier and Slime skills. Innate Slimed Strike 50%. Immune",
      "to Slimed status. Rapier skills deal +100% damage to Slimed",
      "foes. +15% to all stats if Melk is in the main party.",
    ],
    86 => ["Slimy Nun",
      "Can always use White Magic and Slime skills.",
      "Innate Slimed Strike 50%. Immune to Slimed.",
      "Curative White Magic imparts Dexterity Up.",
    ],
    87 => ["Triple Slime",
      "Normal attacks gain two extra hits. Can always use Slime",
      "skills, executing an additional time, but have 150% SP cost.",
      "Innate Slimed Strike 50%. Immune to Slimed.",
    ],
    88 => ["Pumpkin Power",
      "Can always use Black Magic and Nature skills. Black Magic",
      "deals +15% damage and has a 30% chance to inflict Mini.",
      "Regenerates 20% HP/SP and 4% MP each turn for 10 turns",
      "after falling below 20% HP.",
    ],
    89 => ["Predatory Tentacle",
      "Can always use Slime and Tentacle skills.",
      "Innate Slimed Strike 30% and Bind/Digestion Strike 15%.",
      "Dissolving Slime skills deal +30% damage. Tentacle skills",
      "deal +100% damage to partially digested foes.",
    ],
    90 => ["Cave-Dwelling Tentacle Insect",
      "Can always use Tentacle and Insect skills, which have a 30%",
      "chance to inflict Blind. Immune to Blind. Gain +20% to all",
      "stats while in caves.",
    ],
    91 => ["Short-Lived Flame",
      "Deal +30% Fire damage. Can always use Corpse skills.",
      "If above 30% HP, endure a lethal blow with 1 HP remaining",
      "once per battle. Corpse skills deal +1% damage for every %",
      "of missing HP.",
    ],
    92 => ["Flesh Petal Trap",
      "Can always use Plant and Artificial skills.",
      "Innate Bind/Digestion Strike 15%. 50% chance to eat a bound",
      "or partially digested foe at the end of each turn.",
    ],
    93 => ["Beast Apoptosis",
      "Can always use Beast and Artificial skills.",
      "Beast skills deal +30% damage and have a 15% chance of",
      "granting a Double Action state for two turns after use.",
    ],
    94 => ["Multi-Claw Restraint Device",
      "Normal attacks gain an extra hit. Innate Bind Strike 30%.",
      "Can always use Makina and Artificial skills, dealing",
      "+100% damage to Bound foes.",
    ],
    95 => ["Dark Elf Fencer",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword skills, which have a 30% chance to inflict Blind and",
      "Silence. Regenerates 20% SP per turn while below 75% HP.",
    ],
    96 => ["Dark Elf Magician",
      "Deal +30% Ice damage. Can always use Black Magic and",
      "Tentacle skills. Tentacle skills deal +15% damage.",
      "Black Magic has a 30% chance to inflict Blind and Silence.",
    ],
    97 => ["Forest Fairy",
      "Can always use Nature skills, dealing +30% damage with",
      "a 66% SP cost. Targeted by foes 75% as often.",
    ],
    98 => ["Bubble Novice",
      "Can always use Ocean skills. Innate Slimed Strike 50%.",
      "Skills using bubbles have 50% SP cost, deal +30% damage, and",
      "automatically guards afterwards. +15% to all stats if Soapy",
      "is in the main party.",
    ],
    99 => ["Electric Catfish",
      "Can always use Ocean and Nature skills. +20% Counter rate.",
      "Deal +30% Earth and Lightning damage. Nature skills can use",
      "Willpower in place of Magic. Counterattacks with Aqua-",
      "Electric Discharge.",
    ],
    100 => ["Devilish Rafflesia Scent",
      "Innate Trance Strike 15%. Can always use Plant skills,",
      "dealing +100% damage to Tranced foes. Skills using pollen",
      "have a +15% status infliction rate. 33% chance to use Aroma",
      "of Intoxication at the start of battle.",
    ],
    101 => ["Field Centaur",
      "Can always equip Spears and Heavy Spears.",
      "Can always use Spear skills, dealing +15% damage with a 25%",
      "chance to imbue Quick status to self.",
    ],
    102 => ["Novice Ninja",
      "Can always use Taoism, Beast, and Ninjutsu skills.",
      "Ninjutsu skills deal +30% damage, gaining +1% damage for",
      "every % of missing HP. +15% Critical Rate.",
      "+15% to all stats if Kamuro is in the main party.",
    ],
    103 => ["Novice Taoist",
      "Can always use Taoism, Beast, and Ninjutsu skills.",
      "Taoism skills deal +30% damage, gaining +1% damage for",
      "every % of missing HP. +15% to all stats if Kitsu is in the",
      "main party.",
    ],
    104 => ["Time Spinner",
      "Can always use Time Magic and Insect skills.",
      "Insect skills deal +100% damage to Slowed and Stopped foes.",
      "Time Magic has +15% status infliction rate.",
      "Skills using sticky thread have 50% SP cost.",
    ],
    105 => ["Maid in Mimic",
      "Can always use Slime and Corpse skills. Corpse skills deal",
      "+100% damage to stunned foes. Dissolving Slime skills deal",
      "+30% damage. Surprise Box has a +30% Stun infliction rate.",
    ],
    106 => ["Moonlight Kitsune",
      "+20% Counter/Magic Counter rate. Can always use Taoism and",
      "Beast skills, dealing +50% damage, but have 133% SP/MP cost.",
      "Regenerate 8% MP per turn for 10 turns after falling below",
      "50% HP. Reflects Earth-element attacks. Counterattacks with",
      "Kitsune Storm Talisman.",
    ],
    107 => ["Dreaming Sea Cucumber",
      "Innate Sleep/Bind Strike 15%. Can always use Ocean skills,",
      "dealing +100% damage to Sleeping foes. Immune to Sleep",
      "status. Special skills that drain foes deal +30% damage.",
      "+15% to all stats if Shelly is in the main party.",
    ],
    108 => ["Shell Bride",
      "Can always use Cooking, Service, and Ocean skills.",
      "Service skills have 66% SP cost. Auto-guards after using",
      "Ocean skills, and takes only 25% damage while guarding.",
      "+15% to all stats if Yume is in the main party.",
    ],
    109 => ["Bubble Master",
      "Innate Slimed Strike 50% and Trance Strike 15%. Can always",
      "use Service and Ocean skills. Skills using bubbles deal +50%",
      "damage (+100% to Slimed/Tranced foes) and have 66% SP cost.",
      "+15% to all stats if Amy is in the main party.",
    ],
    110 => ["Carnivorous Slime",
      "Innate Digestion Strike 15%. Can always use Slime skills,",
      "dealing +30% damage (+100% damage to partially digested",
      "foes).",
    ],
    111 => ["Miracle Watermelon",
      "Innate Sleep Strike 15%. Can always use Oracle and Plant",
      "skills. Healing skills using honey are 50% more effective",
      "and impart Attack Up.",
    ],
    112 => ["Melting Pitcher Plant",
      "Can always use Slime and Plant skills. Plant skills deal",
      "+100% damage to partially digested foes. Dissolving Slime",
      "skills deal +30% damage.",
    ],
    113 => ["Traditional Lamia",
      "Can always use Flail and Snake skills with 66% SP cost.",
      "Snake skills deal +15% damage, gaining +1% damage for every",
      "% of missing HP.",
    ],
    114 => ["Seaweed Soul",
      "Innate Slimed Strike 30%. Can always use Dancing and Ocean",
      "skills. Dancing skills have a +15% status infliction rate.",
      "33% chance to use Seaweed Dance at the start of battle.",
    ],
    115 => ["Stinging Jellyfish",
      "+10% Evasion. Innate Poison/Paralysis/Bind Strike 15%.",
      "Can always use Ocean and Tentacle skills. Tentacle skills",
      "deal +100% damage to Poisoned foes. Skills using stinging",
      "tentacles deal +30% damage.",
    ],
    116 => ["Stinging Sea Anemone",
      "Can always use Ocean and Tentacle skills. Innate Poison/",
      "Paralysis/Bind Strike 15%. Tentacle skills an additional",
      "time, but have 150% SP cost. Skills using stinging tentacles",
      "deal +30% damage.",
    ],
    117 => ["Immovable Angler",
      "+30% Max HP/Defense. Innate Bind Strike 25%. Can always use",
      "Ocean skills, dealing +100% damage to Bound foes. Immune to",
      "Blind, Sleep, Stun, and pleasure ailments.",
    ],
    118 => ["Versatile Mermaid",
      "Can always use White Magic, Ocean, and Singing skills,",
      "dealing +15% damage. 33% chance to use Mermaid Song at the",
      "start of battle.",
    ],
    119 => ["Numbing Book",
      "+15% Evasion/Magic Evasion. Innate Paralysis/Shock",
      "Strike 15%. Can always use Grimoire skills, dealing +100%",
      "damage to Paralyzed and/or Shocked foes. 50% chance to not",
      "consume a page when using Grimoire skills.",
    ],
    120 => ["Huge Arm Bodyguard",
      "+30% Attack. Normal attacks gain an extra hit. Can always",
      "use Unarmed and Grimoire skills. 50% chance to not consume a",
      "page when using Grimoire skills. Grimoire skills can use",
      "Attack in place of other stats.",
    ],
    121 => ["Tentacle Dictionary",
      "Can always use Grimoire, Demon Arts, and Tentacle skills.",
      "Grimoire skills deal +30% damage and imbue All Stats Up",
      "after use. 50% chance to not consume a page when using",
      "Grimoire skills.",
    ],
    122 => ["Holy Snake",
      "Can always use White Magic and Snake skills.",
      "Innate Stun Strike 15%. White Magic deals +30% damage.",
      "Curative White Magic imparts Defense Up",
    ],
    123 => ["Holy Succubus",
      "Can always use White Magic and Sexcraft skills.",
      "Innate Horny Strike 30%/Trance Strike 15%. White Magic deals",
      "+30% damage. Curative White Magic imparts Willpower Up.",
    ],
    124 => ["Licking Beast",
      "+20% Counter rate. Can always use Demon Arts and Beast",
      "skills. Skills using a tongue have 50% SP cost and deal +30%",
      "damage. Counters with Groin Lick. +15% to all stats if Ants",
      "or Antine Ann is in the main party",
    ],
    125 => ["Brutal Wild Animal",
      "+10% Critical Rate. Can always use Beast skills.",
      "Beast skills deal +30% damage and impart Attack Up on self.",
    ],
    126 => ["Life-Draining Machine",
      "Can always use Gun and Artificial skills. Artificial skills",
      "that drain HP have 50% SP cost and deal +30% damage.",
      "Artificial skills have a 60% chance of inflicting Attack",
      "Down to the target.",
    ],
    127 => ["Weakening Insect",
      "Can always use Insect and Artificial skills. Insect skills",
      "deal +100% damage to stat-weakened foes and have a 5% chance",
      "to weaken a stat. Special Break and Impact skills deal +30%",
      "damage with 50% SP cost.",
    ],
    128 => ["Gunner Cancer",
      "Can always use Gun and Artificial skills, dealing +15%",
      "damage. Gun skills have a 40% chance of imbuing Defense Up",
      "and Dexterity Up. 25% chance to use Full Gatling at the",
      "start of battle.",
    ],
    129 => ["Machine Commander",
      "Can always use Artificial, Makina, Gun, Holy, and Dark",
      "skills. Makina and Gun skills deal +30% damage. Can use",
      "some Makina skills without their required key items.",
    ],
    130 => ["Thirsty Ghost",
      "+10% Evasion. Can always use Black Magic and Corpse skills,",
      "dealing +30% damage. Black Magic has a 15% chance to",
      "inflict Instant Death.",
    ],
    131 => ["Growing-Hair Doll",
      "Can always use Demon Arts and Artificial skills.",
      "Skills using hair deal +30% damage with 50% SP cost,",
      "and gain +1% damage for every % of missing HP.",
    ],
    132 => ["Zombie Gale Swordsman",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword and Corpse skills, dealing +15% damage. Has a 50%",
      "chance to use Gale Thrust at the start of battle. Gale",
      "Thrust deals +1% damage for every % of missing HP.",
    ],
    133 => ["Zombie Group",
      "Can always use Corpse skills. Normal attacks hit four",
      "random foes. Corpse skills execute an additional time, but",
      "have 150% SP cost.",
    ],
    134 => ["I'm a Genius!",
      "Can always use Summoning, Makina, and Medicine skills.",
      "Summoning skills deal +30% damage, gain +1% damage for every",
      "% of missing HP, and have a 40% chance of imbuing Magic Up",
      "and Willpower Up to self.",
    ],
    135 => ["Ultimate Zombie",
      "Counterattacks deal 10x more damage. Can always use Unarmed",
      "and Corpse skills, dealing +50% damage but have 133% SP cost.",
      "Unarmed skills can use Attack in place of Agility.",
      "+30% to all stats if Chrome is in the main party.",
    ],
    136 => ["Forest Guardian",
      "Can always use Bow and Sexcraft skills. Bow skills deal +30%",
      "damage (+100% to Sleeping and/or Paralyzed foes) with 66%",
      "SP cost.",
    ],
    137 => ["Forest Craftsmen",
      "Can always use Club skills. Normal attacks gain an extra hit.",
      "Club skills execute an additional time, but have 150% SP",
      "cost. Targeted by foes 75% as often.",
    ],
    138 => ["Forest Fairies",
      "Can always use Oracle and Nature skills. Normal attacks gain",
      "an extra hit. Oracle skills execute an additional time, but",
      "have 150% SP cost. Targeted by foes 75% as often.",
    ],
    139 => ["Forest Fairy Group",
      "Normal attacks hit four random foes. Can always use Nature",
      "skills, executing an additional time, but have 150% SP cost.",
    ],
    140 => ["Tarantula Housemaid",
      "Can always use Service and Insect skills.",
      "Service skills deal +100% damage to Slimed and Bound foes.",
      "Skills using sticky thread deal +30% damage with 50% SP cost.",
    ],
    141 => ["Raging Cow's Axe",
      "Can always equip Axes and use Axe skills.",
      "Axe skills deal +30% damage, gaining +1% damage for every",
      "% of missing HP.",
    ],
    142 => ["Strong Arm",
      "+20% Counter rate. Can always use Unarmed skills, dealing",
      "+15% damage, and can use Attack in place of Agility.",
      "Counters with Drain Hand.",
    ],
    143 => ["Dexterous Poor Succubus",
      "Can always use Thievery, Mercantile, Oracle, Dancing,",
      "Singing, Talk, Cooking, Medicine, and Service skills, but",
      "may use certain Oracle skills instead of following orders.",
      "(This trait is a removable ability)",
    ],
    144 => ["Sables Phase",
      "Can always use Demon Arts, Insect and Piracy skills.",
      "Skills using a tongue have 50% SP cost and deal +30% damage.",
      "25% chance of gaining a double action.",
    ],
    145 => ["Armored Centipede",
      "Innate Paralysis/Bind Strike 15%. Can always use Insect",
      "skills. Takes only 25% damage when guarding. Insect skills",
      "deal +15% damage (+100% to Paralyzed and/or Bound foes).",
    ],
    146 => ["Armored Scorpion",
      "Innate Death Strike 15%. Can always use Insect skills.",
      "Takes only 25% damage when guarding. Skills using stingers",
      "deal +30% damage and have a 15% chance to inflict Instant",
      "Death.",
    ],
    147 => ["Prickly Cactus",
      "+75% Counter rate. Can always use Whip and Plant skills.",
      "Plant skills using needles deal +30% damage and have 50%",
      "SP cost. Counters with Thorn Shot.",
    ],
    148 => ["Brawling Ostrich",
      "Can always use Unarmed and Wing skills. Unarmed skills deal",
      "+30% damage with increased priority and can use Agility in",
      "place of Attack.",
    ],
    149 => ["Lucky Lamp",
      "+25% Magic Counter rate. Can always use Summoning and Oracle",
      "skills. Summoning skills have 66% MP cost. Deal +30%",
      "Lightning damage. Counters with Mega Thunder.",
    ],
    150 => ["Royal Mummy",
      "+20% Counter Rate. Can always equip Rapiers and use Rapier,",
      "Black Magic, and Corpse skills. Rapier skills and Black",
      "Magic deal +15% damage. Skills using bandages deal +30%",
      "damage. Counters with Bandage Strike.",
    ],
    151 => ["Venomous Snake",
      "Innate Death Strike 15%. Can always use Beast and Snake",
      "skills. Skills using fangs deal +30% damage. (+100% to Bound",
      "foes).",
    ],
    152 => ["Talkative Snakes",
      "Normal attacks hit four random foes. Can always use Talk and",
      "Snake skills. Snake skills execute an additional time, but",
      "cost 150% SP.",
    ],
    153 => ["Ancient Desert Goddess",
      "Innate Mini Strike 30% and Petrify Strike 20%. Can always",
      "use Demon Arts and Sexcraft skills, dealing +50% damage,",
      "with a 30% chance to inflict Mini and Petrify, but have",
      "133% SP cost. 25% chance of gaining an extra action.",
    ],
    154 => ["Alligator Fangs",
      "Innate Bind Strike 15%. Can always use Beast skills. Skills",
      "using fangs deal +30% damage (+100% to Bound foes).",
      "33% chance to eat a bound or partially digested foe at the",
      "end of turn.",
    ],
    155 => ["Everyone's Idol",
      "Can always use Dancing, Singing, and Sexcraft skills.",
      "Dancing and Singing skills have +15% status infliction rate",
      "and have a 20% chance to inflict Seduction. Targeted by foes",
      "75% as often.",
    ],
    156 => ["Shameful Swordsman",
      "Can always equip Swords and Knight Swords and use Sword",
      "skills. Sword skills deal +15% damage, have 66% SP cost,",
      "and have a 30% chance to inflict Defense Down.",
    ],
    157 => ["Earth Spider's Trap",
      "Innate Slimed Strike 30% and Bind Strike 15%. Can always use",
      "Demon Arts and Insect skills, dealing +100% damage to Bound",
      "foes. Skills that use sticky thread deal +30% damage and",
      "have 50% SP cost.",
    ],
    158 => ["Drain Suck",
      "Can always use Black Magic and Tentacle skills. Black Magic",
      "deals +100% damage to Bound foes. Tentacle skills that drain",
      "HP deal +30% damage and have 50% SP cost.",
    ],
    159 => ["Nightmare Maiden",
      "Can always use Demon Arts and Artificial skills. Innate Bind",
      "Strike 15%. Nightmare's Embrace deals +50% damage.",
      "33% chance to use Nightmare's Embrace at the start of battle.",
    ],
    160 => ["Ice Mage",
      "Deal +30% Ice damage. Can always use Tentacle and Summoning",
      "skills. Tentacle skills deal +15% damage (+100% to Frozen",
      "foes).",
    ],
    161 => ["Biting Cook",
      "Can always use Cooking, Beast, and Tentacle skills.",
      "Cooking skills deal +30% damage and have increased priority.",
    ],
    162 => ["Honey Tentacles",
      "Can always use Slime, Tentacle, and Corpse skills.",
      "Slime and Tentacle skills execute an additional time, but",
      "have 150% SP cost.",
    ],
    163 => ["Mad Mage",
      "Can always use Summoning, Magic Science, and Tentacle",
      "skills, dealing +30% damage. Summoning and Magic Science",
      "skills have a 30% chance to inflict Silence and Confusion.",
      "Tentacle skills can use Magic in place of Dexterity.",
    ],
    164 => ["Oni's Club",
      "Can always equip Clubs and use Club skills. Club skills deal",
      "+30% damage and have a 30% chance to inflict Confusion.",
    ],
    165 => ["Masturbation Assistant",
      "Can always use Slime and Sexcraft skills. Sexcraft skills",
      "using the hand deal +50% damage (+100% to Slimed foes).",
      "Sexcraft skills have a 30% chance to inflict Slimed.",
    ],
    166 => ["I'm A Nurse",
      "Can always use Medicine and Sexcraft skills. Medicine skills",
      "deal +30% damage. Curative Medicine skills impart status",
      "immunity for 10 turns. Targeted by foes 75% as often.",
    ],
    167 => ["Mad Alchemist",
      "Can always use Summoning, Alchemy, and Tentacle skills,",
      "dealing +30% damage. Alchemy skills imbue All Stats Up.",
      "25% chance of not consuming materials when using Alchemy",
      "skills. Automatically create Alchemy materials during battle.",
    ],
    168 => ["100 Eyes",
      "Can always use Demon Arts. Demon Arts that use eyes deal",
      "+30% damage and have +15% status infliction rate. 35% chance",
      "to use Demon Eyes of Poison, Darkness, Silence, Confusion,",
      "Sleep, Paralysis, or Death at start of battle. Demon Arts",
      "skills have a 30% chance to inflict Defense Down and",
      "Willpower Down.",
    ],
    169 => ["Lizard Thief",
      "Can always use Dagger, Thievery, and Breath skills.",
      "150% gold drop rate. Dagger skills deal +100% damage to",
      "Burned foes. +15% to all stats if Len or Miranda is in the", 
      "main party.",
    ],
    170 => ["Lizard Bandit",
      "Can always use Sword, Thievery, and Breath skills.",
      "Sword skills deal +15% damage (100% to Burned foes).",
      "All skills have 50% SP cost while below 50% HP.", 
      "+15% to all stats if Liru or Miranda is in the main party.",
    ],
    171 => ["Lizard Bandit Queen",
      "Can always use Sword, Thievery, and Breath skills.",
      "Sword skills deal +30% damage, and execute an additional time",
      "while below 20% HP. +15% to all stats if Len or Liru is in",
      "the main party.",
    ],
    172 => ["Desert Mirage",
      "+15% Evasion/Magic Evasion. Can always use Dancing,",
      "Sexcraft, and Corpse skills. Dancing skills have 30% chance",
      "to inflict Blind. +20% to all stats while in the desert.",
    ],
    173 => ["Desert Antlion",
      "+30% Dexterity. Innate Bind Strike 30%. Can always use",
      "Insect skills, dealing +15% damage. 25% chance of using",
      "Quicksand at start of battle. +20% to all stats while in the",
      "desert. Bow and Insect skills deal +100% damage to bound",
      "foes.",
    ],
    174 => ["Desert Sandworm",
      "+30% Max HP/Attack. Can always use Insect and Giant skills.",
      "Giant Skills inflict +30% damage and have 50% SP Cost.",
      "+20% to all stats while in the desert.",
    ],
    175 => ["Desert Tamer",
      "Can always use Whip, Talk, and Tentacle skills. Whip skills",
      "deal +30% damage and imbue Defense Up. +20% to all stats",
      "while in the desert.",
    ],
    176 => ["Vitae Aqua",
      "Deal +30% Water damage. Can always use Slime and Artificial",
      "skills. Slime skills deal +30% damage. Artificial skills",
      "deal +100% damage to Slimed foes.",
    ],
    177 => ["Big Mouth",
      "Innate Digestion Strike 15%. Can always use Unarmed, Beast,",
      "and Artificial skills. Unarmed skills deal +100% damage to",
      "partially digested foes. Skills using fangs deal +30%",
      "damage.",
    ],
    178 => ["Makina Gauge",
      "Innate Bind Strike 15%. Can always use Makina and Artificial",
      "skills. Makina skills deal +30% damage (+100% to Bound foes).",
    ],
    179 => ["Laughing Harlequin",
      "+10% Critical Rate/Evasion/Magic Evasion. Can always use",
      "Singing and Artificial skills. Singing skills have +15%",
      "status infliction rate and an additional 30% chance to",
      "inflict Sleep and Confusion.",
    ],
    180 => ["Magic Shadow",
      "+15% Evasion/Magic Evasion. Can always equip Scythes and",
      "use Black Magic, Scythe, and Corpse skills. Scythe skills",
      "and Black Magic deal +30% damage. Scythe skills increase",
      "Evasion and Magic Evasion by 50% for 4 turns after use.",
    ],
    181 => ["Talkative Art",
      "Can always use Talk, Demon Arts, and Corpse skills.",
      "Talk skills have +15% status infliction rate and increased",
      "priority.",
    ],
    182 => ["Gold-Creating Body",
      "Can always use Alchemy, Tentacle, and Artificial skills.",
      "25% chance of nullifying a physical or magical attack when",
      "using Alchemy skills. 25% chance of not consuming materials",
      "when using Alchemy skills. Automatically create Alchemy",
      "materials during battle.",
    ],
    183 => ["Autonomous Maiden",
      "Innate Bind Strike 15%. Can always use Demon Arts, Tentacle,",
      "and Artificial skills. Tentacle skills deal +100% damage to",
      "Bound foes. Nightmare's Embrace deals +30% damage.",
    ],
    184 => ["Junk Mind",
      "Can always use Service and Artificial skills. Normal attacks",
      "hit four random foes. Artificial skills execute an additional",
      "time, but have 150% SP cost.",
    ],
    185 => ["Robo Maid Prototype",
      "Can always use Service/Artificial skills.",
      "Service skills deal +30% damage, gaining +1% damage for",
      "every % of missing HP. +15% to all stats if Promestein or",
      "Chrome is in the main party.",
    ],
    191 => ["Versatile Widow",
      "Can always use Black Magic, Singing, Service, and Plant",
      "skills. 33% chance to use Lullaby at start of battle.",
    ],
    192 => ["Group Paizuri",
      "Can always use Sexcraft and Insect skills. Skills using",
      "breasts an additional time, but have 150% SP cost.",
    ],
    193 => ["Wolf Tentacle",
      "Can always use Beast and Tentacle skills, dealing +30%",
      "damage. 25% chance of gaining an additional action.",
    ],
    194 => ["Dissolving Cloth",
      "Innate Digestion Strike 30%. Can always use Demon Arts,",
      "dealing +100% damage to partially digested foes.",
      "+20% Evasion/Magic Evasion.",
    ],
    195 => ["Mermaid Mage",
      "Deal +30% Water damage. Can always use Black Magic/Ocean",
      "skills. Black Magic deals +15% damage and has a 30% chance",
      "to inflict Seduction.",
    ],
    196 => ["Sea Merchant",
      "Evasion +10%. Can always equip Abacuses.",
      "Can always use Mercantile/EX-Item/Ocean skills.",
      "Mercantile skills have 75% gold cost and increased priority.",
    ],
    197 => ["Novice Pirate",
      "Can always use Piracy/Ocean skills.",
      "Piracy skills deal +30% damage, gaining +1% damage for every",
      "% of missing HP. +15% to all stats if Ashel or Bonnie is in",
      "the main party.",
    ],
    198 => ["Cotton Group",
      "Normal attack hits four random foes. Can always use Dancing/",
      "Demon Arts. Dancing skills execute an additional time, but",
      "have 150% SP cost.",
    ],
    199 => ["Drifting Dagon",
      "Can always use Tentacle/Ocean skills.",
      "Ocean skills deal +15% damage and have a 30% chance to",
      "inflict Sleep. +20% Evasion/Magic Evasion.",
    ],
    200 => ["Hitodama Fire",
      "Innate Burn Strike 30%. Can always use Corpse skills.",
      "Deal +30% Fire damage. Immune to Fire damage.",
    ],
    201 => ["Versatile First Mate",
      "Can always use Thievery, Piracy, Cooking, Medicine, Service",
      "and Ocean skills. Cooking, Medicine, and Service skills",
      "deal +30% damage. Medicine and Service skills use the highest",
      "of Attack or Dexterity. 33% chance to use Support Bombardment",
      "at start of battle. +15% to all stats if Lolitta or Bonnie",
      "is in the main party.",
    ],
    202 => ["Tiny Pirate Queen",
      "Can always use Sword and Piracy skills. Piracy skills deal",
      "+50% damage, but have 133% SP cost. +15% to all stats if",
      "Lolitta or Ashel is in the main party.",
    ],
    203 => ["Pretend Dragonkin",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear, Piracy, and Breath skills, dealing +15% damage.",
      "+15% to all stats if Stacy or Levia is in the main party.",
    ],
    204 => ["Slimy Marine",
      "Innate Slimed Strike 50%. Can always use Piracy, Ocean,",
      "Slime, and Breath skills. Piracy, Ocean, and Slime skills",
      "deal +15% damage. Immune to Slimed status. 33% chance to use",
      "Sticky Hell at start of battle. Piracy skills deal",
      "additional damage to Slimed foes. +15% to all stats if",
      "Tatsuko or Levia is in the main party.",
    ],
    205 => ["Great Navy Admiral",
      "Deal +30% Water damage.",
      "Can always equip Spears and Heavy Spears.",
      "Can always use Spear, Piracy, Ocean and Giant skills.",
      "Spear, Piracy and Giant skills deal +30% damage, gaining",
      "+1% damage for every % of missing HP. +15% to all stats if",
      "Tatsuko or Stacy is in the main party.",
    ],
    206 => ["Slimy Brawler",
      "Innate Slimed Strike 50%. Can always use Unarmed, Singing,",
      "and Slime skills. Unarmed skills execute an additional time,",
      "but have 150% SP cost.",
    ],
    207 => ["Kleptomaniac Centaur",
      "Can always equip Spears and Heavy Spears.",
      "Can always use Spear and Thievery skills.",
      "Spear skills have 66% SP cost. +15% Critical/Evasion Rate.",
    ],
    208 => ["Gentle Alraune",
      "Can always use White Magic and Plant skills.",
      "Plant skills have 66% SP cost and deal +15% damage.",
    ],
    209 => ["Restless Insect",
      "Can always use Thievery, Service, and Insect skills.",
      "Thievery and Service skills have 66% SP cost.",
    ],
    210 => ["Taoist Ghost",
      "Can always use Taoism and Corpse skills. Taoism skills deal",
      "+15% damage and have 66% MP cost.",
    ],
    211 => ["Lewd Tentacle Box",
      "Can always equip Plates and Sex Toys. Can always use",
      "Service, Sexcraft, Tentacle, and Corpse skills. Service,",
      "Sexcraft, and Tentacle skills execute an additional time, but",
      "have 150% SP cost.",
    ],
    212 => ["Dullahan Swordsman",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword skills and Demon Arts. Sword skills deal +30% damage",
      "and have 66% SP cost.",
    ],
    213 => ["Hellhound",
      "Can always use Beast skills, executing two additional times,",
      "but with double SP cost.",
    ],
    214 => ["Slimy Snake",
      "Innate Slimed Strike 50%. Can always use Sexcraft and Snake",
      "skills. Sexcraft and Snake skills deal +15% damage.",
      "Snake skills deal +100% damage to Slimed.",
    ],
    215 => ["Powerful Onee-San",
      "Can always equip Great Swords, Helmets, Heavy Helmets,",
      "Bucklers, Shields, Heavy Shields, Armor, and Heavy Armor.",
      "Can always use Sword and Axe skills, dealing +30% damage.",
    ],
    216 => ["Powerful Service",
      "Can always equip Axes, Kitchen Knives, and Plates. Can",
      "always use Axe, Cooking, and Service skills. Axe and Service",
      "skills have 66% SP cost. Service skills use the highest of",
      "Attack or Dexterity.",
    ],
    217 => ["Mechanic Minotaur",
      "Can always use Gun and Makina skills, dealing +30% damage.",
    ],
    218 => ["Herculean Axe",
      "Can always equip Axes and Clubs.",
      "Can always use Axe, Club, and Giant skills, dealing +50%",
      "damage and gaining +1% damage for every % of missing HP,",
      "but have 133% SP cost.",
    ],
    219 => ["Economic Kunoichi",
      "Can always equip Ninja Swords.",
      "Can always use Ninjutsu skills, with 50% SP cost.",
    ],
    220 => ["Economic Samurai",
      "Can always equip Katanas and use Katana skills,",
      "with 50% SP cost.",
    ],
    221 => ["Yuki-Onna",
      "Deal +30% Ice damage. Can always use Taoism, Sexcraft, and",
      "Demon Arts. Taoism and Demon Arts deal +100% damage to",
      "Frozen foes. Demon Arts skills dealing Ice damage have 50%",
      "MP cost. Immune to Ice damage.",
    ],
    222 => ["Brawler Cat",
      "Can always equip Fists. Can always use Unarmed/Thievery/",
      "Beast skills. Unarmed skills deal +30% damage (+100% to",
      "Blinded foes). +15% Critical/Evasion Rate.",
    ],
    223 => ["Lick & Slurp",
      "Can always use Demon Arts. Innate Slimed Strike 50%.",
      "Skills using a tongue deal +30% damage and execute an",
      "additional time, but have 150% SP cost.",
    ],
    224 => ["Kappa Kenpo",
      "Can always equip Fists and Shells. Can always use Unarmed",
      "skills, dealing +15% damage with 66% SP cost.",
      "Innate Shell Mastery.",
    ],
    225 => ["Two-Mouth Cooking",
      "Can always use Cooking, Service, and Demon Arts. Cooking",
      "skills deal +30% damage. Skills using a tongue deal",
      "+30% damage. Has a 20% chance to attempt devouring all foes",
      "at the end of turn,.",
    ],
    226 => ["White Snake Kagura",
      "Can always equip Flails. Can always use Flail, Taoism,",
      "Dancing, and Snake skills. Flail, Taoism, and Dancing skills",
      "deal +30% damage. Taoism skills can use Defense in place of",
      "Magic. Dancing skills have increased priority.",
    ],
    227 => ["Dancing Snake Miko",
      "Can always use Taoism, White Magic, Dancing, and Snake",
      "skills. Dancing skills have 66% SP cost and have a 30%",
      "chance to inflict Bind.",
    ],
    228 => ["Time-Spinner Arachne Miko",
      "Can always use Taoism, Time Magic, and Insect skills.",
      "Time Magic has 66% MP cost. Insect skills have 66% SP cost",
      "and a 30% chance to inflict Slow or Stop.",
    ],
    229 => ["Chaotic Dancing Hair",
      "Innate Bind Strike 15%. Can always use Taoism, Dancing, and",
      "Demon Arts. Skills using hair deal +50% damage (+100% to",
      "Bound foes) and have 50% SP cost.",
    ],
    230 => ["Raging Eight-Headed Snake",
      "Normal attacks hit four random foes. Can always use Snake",
      "and Giant skills. Snake skills execute two additional times,",
      "but have double SP cost.",
    ],
    231 => ["Magical Underclassmen",
      "Can always use Black Magic and Insect skills.",
      "Black Magic executes an additional time, but has 150% MP",
      "cost.",
    ],
    232 => ["Magical Upperclassmen",
      "Can always equip Rods, Bows, and Sex Toys. Can always use",
      "Bow, Black Magic, Sexcraft, and Nature skills. Black Magic",
      "executes an additional time, but has 150% MP cost.",
    ],
    233 => ["Magical Teacher",
      "Can always use White Magic, Black Magic, Magic Science, and",
      "Grimoire skills, dealing +30% damage. White Magic and Black",
      "Magic have 66% MP cost. Magic Science has 66% SP cost.",
    ],
    234 => ["Scythe-Wielding Mantis",
      "Can always equip Scythes. Can always use Scythe and Insect",
      "skills. Scythe skills deal +30% damage (+100% to Poisoned",
      "and/or Paralyzed foes) with 50% SP cost. Innate Scythe ",
      "Mastery.",
    ],
    235 => ["Silky Silk",
      "Innate Slimed Strike 50% and Bind Strike 25%. Can always use",
      "Insect skills, dealing +100% damage to Tranced and/or Bound",
      "foes and have 66% SP cost. Skills using sticky thread deal",
      "+50% damage.",
    ],
    236 => ["Plant Pals",
      "Normal attacks gain an extra hit. Can always use Plant",
      "skills, dealing +100% damage to Bound foes and executing an",
      "additional time, but have 150% SP cost.",
    ],
    237 => ["Plant Group",
      "Normal attacks hit four random foes. Can always use Plant",
      "skills, executing two additional times, but have double SP",
      "cost.",
    ],
    238 => ["Supportive Youngest Sister",
      "Innate Digestion Strike 30%. Can always use White Magic,",
      "Thievery, and Plant skills. White Magic has 66% MP cost.",
      "Curative White Magic imparts Dexterity Up. Plant skills deal",
      "+100% damage to partially digested foes. +15% to all stats",
      "if Raffia or Deana is in the main party.",
    ],
    239 => ["Middle Sister",
      "Innate Digestion Strike 30%. Can always use Plant and Slime",
      "skills. Plant skills deal +100% damage to partially",
      "digested/Tranced foes, have 66% SP cost, and +15% status",
      "infliction rate. +15% to all stats if Dorothy or Deana is in",
      "the main party.",
    ],
    240 => ["Offensive Eldest Sister",
      "Innate Digestion Strike 30%. Can always equip Flails.",
      "Can always use Flail and Plant skills. Flail skills deal",
      "+30% damage and use the highest of Dexterity or Attack.",
      "Flail and Plant skills deal +100% damage to partially",
      "digested foes. +15% to all stats if Dorothy or Raffia is in",
      "the main party.",
    ],
    241 => ["Soothing Whip",
      "Can always use Whip, White Magic, and Plant skills.",
      "Whip skills deal +30% damage (+100% to Poisoned, Confused,",
      "and/or Paralyzed foes) and have 66% SP cost.",
      "White Magic has 66% MP cost.",
    ],
    242 => ["Queen of Whips",
      "Can always use Whip, White Magic, Ruling, and Plant skills,",
      "dealing +30% damage. Whip and Ruling skills deal +100%",
      "damage to Poisoned, Confused, and/or Paralyzed foes.",
    ],
    243 => ["Insect Army",
      "Normal attack hits four random foes. Can always use Insect",
      "skills, executing an additional time, but have 150% SP cost.",
    ],
    244 => ["Multi-Armed Brawling Bee",
      "Innate Poison/Paralysis Strike 30%. Can always equip Fists.",
      "Can always use Unarmed and Insect skills with 66% SP cost.",
      "+30% to all stats if Miria is in the main party.",
    ],
    245 => ["Queen Bee",
      "Innate Poison/Paralysis Strike 30%. Can always equip Fists.",
      "Can always use Unarmed and Insect skills, dealing +30%",
      "damage. Unarmed skills deal +100% damage to Paralyzed foes.",
      "+15% to all stats if Bii is in the main party.",
    ],
    246 => ["Jelly Body",
      "Innate Slimed Strike 50%. Can always use Slime skills, having",
      "66% SP cost and imbuing Defense Up.",
    ],
    247 => ["Blob Body",
      "+20% Counter rate. Innate Digestion Strike 25%. Can always",
      "use Slime skills, dealing +15% damage (+100% to partially",
      "digested foes). Counters with Digestive Slime.",
    ],
    248 => ["Slime Group",
      "Normal attacks hit four random foes. Can always use Slime",
      "skills, executing two additional times, but have double SP",
      "cost.",
    ],
    249 => ["Soldier Ant",
      "Can always equip Fists. Can always use Unarmed and Insect",
      "skills. Unarmed skills have 66% SP cost. 20% chance of",
      "gathering food at the end of each turn.",
      "+30% to all stats if Antine Ann is in the main party.",
    ],
    250 => ["Sexual Service Doll",
      "Can always use Service, Sexcraft, and Artificial skills.",
      "Service and Sexcraft skills deal +30% damage with 66% SP",
      "cost. Self-destruct skills deal +200% damage.",
    ],
    251 => ["Paizuri Doll",
      "+15% Evasion. Can always use Sexcraft and Artificial skills.",
      "Skills using breasts deal +50% damage with 66% SP cost,",
      "and gain +1% damage for every % of missing HP.",
    ],
    252 => ["Bonafide Scylla",
      "Can always use Tentacle skills, dealing +30% damage with 66%",
      "SP cost and gaining +1% damage for every % of missing HP.",
    ],
    253 => ["Gorgon's Gaze",
      "+20% Counter Rate. Innate Petrify Strike 20%. Can always use",
      "Demon Arts and Snake skills. Demon Arts and Special skills",
      "that inflict Petrify have +30% infliction rate. Counters",
      "with Petrifying Strike.",
    ],
    254 => ["Fluttering Butterfly",
      "+20% Evasion/Magic Evasion. Can always use Taoism and Insect",
      "skills. Insect skills have 66% SP cost and increase Evasion",
      "by 50% for 4 turns.",
    ],
    255 => ["Poisonous Slime",
      "Deal +30% Bio damage. Innate Poison Strike 25%. Can always",
      "use Slime and Breath skills. Immune to Poison status and",
      "absorb Bio damage. Slime skills have a 30% chance to",
      "inflict Poison. Poison Breath has +30% infliction rate.",
    ],
    256 => ["Slimy Zombie",
      "Innate Slimed Strike 50%. Can always use Slime and Corpse",
      "skills, dealing +30% damage. Corpse skills deal +100% damage",
      "to Slimed foes.",
    ],
    257 => ["Zombie Group",
      "Normal attacks hit four random foes. Can always use Club and",
      "Corpse skills. Corpse skills execute an additional time, but",
      "have 150% SP cost.",
    ],
    258 => ["Singing Jellyfish",
      "Can always use Singing and Tentacle skills with 66% SP cost.",
      "Singing skills imbue Defense Up to self. Nullify attacks",
      "dealing 300 damage or less.",
    ],
    259 => ["Sky-High Dancer",
      "Can always use Dancing and Wing skills with 66% SP cost.",
      "Wing skills deal +100% damage to Horny and/or Seduced foes.",
      "Dancing skills have +15% status infliction rate.",
    ],
    260 => ["Sky-High Lancer",
      "Can always use Spear and Wing skills. Spear skills deal +15%",
      "damage with 66% SP cost and have increased priority.",
    ],
    261 => ["Muddy Golem",
      "Innate Slimed Strike 50%. Normal attack is replaced with",
      "Drain Strike. Can always use Artificial and Giant skills.",
      "Giant skills deal +30% damage (+100% to Slimed foes).",
      "Immune to Earth damage.",
    ],
    262 => ["Powerful Golem",
      "Innate Drain Strike 50%. Can always use Artificial and Giant",
      "skills. Giant skills deal +50% damage, but have 133% SP cost.",
    ],
    263 => ["Dancing Mantis",
      "Can always use Katana, Dancing, and Insect skills, dealing",
      "+30% damage. Dancing skills have +15% status infliction rate.",
    ],
    264 => ["Magical Golem",
      "+30% Max MP/Magic. Innate Mana Drain Strike 20%. Can always",
      "use Black Magic and Artificial skills. Black Magic imbues",
      "Magic Up.",
    ],
    265 => ["Kitsune Schoolgirl",
      "Can always use Taoism and Beast skills, dealing +15% damage.",
      "Taoism can use Agility in place of Magic, and deals +100%",
      "damage to Blinded and/or Silenced foes.",
    ],
    266 => ["Kitsune Ninja",
      "Can always equip Ninja Swords. Can always use Ninjutsu",
      "skills, dealing +30% damage and gaining +1% damage for every",
      "% of missing HP.",
    ],
    267 => ["Kitsune Samurai",
      "Can always equip Katanas and use Katana skills, dealing +30%",
      "damage and gaining +1% damage for every % of missing HP.",
      "20% chance of Kudagitsune Support at the end of each turn.",
    ],
    268 => ["Mighty Queen Ant",
      "Normal attack hits four random foes. Can always equip Fists.",
      "Can always use Unarmed/Insect skills, dealing +30% damage.",
      "Insect skills deal +1% damage for every % of missing HP.",
      "+15% to all stats if Ants is in the main party.",
    ],
    269 => ["Boiling Lava",
      "Innate Burn Strike 30%. Deal +30% Fire Damage.",
      "Can always use Slime/Breath skills.",
      "Slime skills deal +100% damage to Burned foes.",
      "Immune to Fire damage and Burn status.",
    ],
    270 => ["Nightmare Lamia",
      "Can always use Demon Arts and Snake skills, dealing +30%",
      "damage.",
    ],
    271 => ["Nightmare Scylla",
      "Can always use Demon Arts and Tentacle skills, dealing +30%",
      "damage. Tentacle skills deal +100% damage to Burned foes.",
    ],
    272 => ["Enchanting Voice",
      "Can always use Dancing, Singing, and Wing skills.",
      "Wing skills deal +100% damage to Seduced foes.",
      "Singing skills have half SP cost and +15% status infliction",
      "rate.",
    ],
    273 => ["Coral Whip",
      "Innate Petrify Strike 20%. Can always equip Whips.",
      "Can always use Whip, Ocean, Tentacle, and Plant skills.",
      "Whip skills deal +30% damage.",
    ],
    274 => ["Sea Trickster",
      "Can always equip Daggers. Can always use Dagger, Thievery,",
      "and Ocean skills. Dagger skills deal +15% damage (+100% to",
      "Bound foes). Dagger and Thievery skills have 66% SP cost.",
    ],
    275 => ["Yellow Fly Queen",
      "Deal +30% Lightning damage. Can always use Sword, Black",
      "Magic, and Insect skills. Sword skills and Black Magic deal",
      "+15% damage. Black Magic uses the highest of Attack or Magic.",
      "Spellsword Sword skills impart their respective elemental",
      "imbues unto self. +15% to all stats if Striga or Media is in",
      "the main party.",
    ],
    276 => ["Red Fly Queen",
      "+30% Dexterity. Deal +30% Fire damage. Can always use Bow,",
      "Black Magic, and Insect skills. Bow skills and Black Magic",
      "deal +15% damage and can use Dexterity in place of other",
      "stats. +15% to all stats if Barbarella or Media is in the",
      "main party.",
    ],
    277 => ["Blue Fly Queen",
      "Deal +30% Ice damage. Can always use White/Black Magic and",
      "Insect skills. White Magic and Black Magic deal 15% damage.",
      "Insect skills use can use Magic in place of Attack. +15% to",
      "all stats if Barbarella or Striga is in the main party.",
    ],
    278 => ["Dizzy Jellyfish",
      "+20% Evasion/Magic Evasion. Innate Poison/Paralysis",
      "Strike 30%. Can always use Tentacle and Ocean skills.",
      "Tentacle skills deal +100% damage to Paralyzed foes and have",
      "66% SP cost.",
    ],
    279 => ["Slimy Scylla",
      "Innate Slimed Strike 50%.",
      "Can always use Tentacle and Ocean skills.",
      "Tentacle skills deal +30% damage",
      "(+100% to Slimed foes).",
    ],
    280 => ["Queen of the Northern Sea",
      "+30% Attack. Can always equip Spears and Heavy Spears.",
      "Can always use Spear, Tentacle, Ocean, and Giant skills.",
      "Spear and Tentacle skills deal +30% damage. Spear,",
      "Tentacle, and Ocean skills can use Attack in place of other",
      "stats. +15% to all stats if Kraken is in the main party.",
    ],
    281 => ["Harem of Pleasure",
      "Normal attack hits four random foes. Can always equip Whips",
      "and Sex Toys. Can always use Whip and Sexcraft skills,",
      "executing an additional time, but have 150% SP cost.",
    ],
    282 => ["Succubus Maid",
      "Can always use Service and Sexcraft skills, dealing +15%",
      "damage with 66% SP cost. Service skills have a 30% chance of",
      "inflicting Horny and Trance.",
    ],
    283 => ["Succubus Prostitute",
      "Can always use Sexcraft skills dealing +30% damage with 66%",
      "SP cost and gaining +1% damage for every % of missing HP.",
    ],
    284 => ["Punishing Succubus",
      "Can always use Whip and Sexcraft skills, dealing +15% damage.",
      "with 66% SP cost. Whip skills can use Dexterity in place of",
      "Attack. +15% to all stats if Nina is in the main party.",
    ],
    285 => ["Draining Succubus",
      "Innate Drain Strike 50%. Can always use Service/Sexcraft",
      "skills, dealing +15% damage. Has a 50% chance of gaining",
      "Dexterity Up and a 10% chance of gaining All Stats Up when",
      "using Sexcraft skills. +15% to all stats if Serra is in the",
      "main party.",
    ],
    286 => ["Magical Succubus",
      "Can always use Black Magic, White Magic, and Sexcraft",
      "skills. Black Magic and White Magic deal +15% damage and",
      "have 66% MP cost. Black Magic deals +100% damage to Horny,",
      "Tranced, and/or Seduced foes.",
    ],
    287 => ["Succubus Mayor",
      "Innate Horny/Trance Strike 30%.",
      "Can always use Oracle and Sexcraft skills.",
      "Sexcraft skills deal +30% damage",
      "(+100% to Horny/Tranced/Seduced foes).",
    ],
    288 => ["Nightmare Succubus",
      "Innate Climax Strike 20%. Can always use Sexcraft, Demon",
      "Arts, and Nature skills, dealing +15% damage. Nature skills",
      "deal +100% damage to Horny/Tranced/Seduced foes.",
    ],
    289 => ["Service Scylla",
      "Can always use Service and Tentacle skills, dealing +15%",
      "damage with 66% SP cost. Service skills deal +100% damage to",
      "Stunned/Slimed foes. +15% to all stats if Emily or Cassandra",
      "is in the main party.",
    ],
    290 => ["Suckling Madame",
      "Innate Drain Strike 50%. Can always use Insect skills.",
      "HP-draining Insect skills deal 50% more damage, have 66%",
      "SP cost, and a 75% Bind rate. +20% Counter rate.",
      "Counters with Bodily Fluid Drinking.",
    ],
    291 => ["Tentacle Madame",
      "Can always use Tentacle skills with 50% SP cost.",
    ],
    292 => ["Breast Paradise",
      "Innate Trance Strike 30%. Can always use Black Magic and",
      "Sexcraft skills. Skills using breasts deal +100% damage to",
      "Tranced foes and execute an additional time, but have 150%",
      "MP/SP cost.",
    ],
    293 => ["Hungry Princess",
      "Can always use Cooking, Service, and Giant skills.",
      "Service skills deal +30% damage (+100% to partially",
      "digested foes). 25% chance of an attempt to devour all",
      "foes at the start of battle.",
    ],
    294 => ["Idol Daughter",
      "Can always use Dancing, Singing, and Tentacle skills.",
      "Dancing and Singing skills have 66% SP cost. Tentacle skills",
      "deal +30% damage. Has a 33% chance of flashing a Sparkle☆",
      "pose at the start of battle. +15% to all stats if Cassandra",
      "is in the main party.",
    ],
    295 => ["Melting Lady",
      "Innate Digestion/Bind Strike 30%. Can always use Demon Arts",
      "and Slime skills, dealing +30% damage with 66% SP cost.",
      "+15% to all stats if Emily is in the main party.",
    ],
    296 => ["Melting Mademoiselle",
      "Immune to Physical damage. Innate Bind/Digestion Strike 30%.",
      "Can always use Demon Arts and Slime skills, dealing +50%",
      "damage, but with 133% SP cost. +15% to all stats if Emily is",
      "in the main party.",
    ],
    297 => ["Petrifying Basilisk",
      "Innate Petrify Strike 20%. Can always use Demon Arts and",
      "Wing skills. Demon Eyes of Petrification has +30% increased",
      "chance of petrification.",
    ],
    298 => ["Raging Dragon",
      "Can always use Beast, Breath and Giant skills.",
      "Beast and Breath skills deal +50% damage,",
      "but have 133% SP cost.",
    ],
    299 => ["Jiggly Cube",
      "+20% Counter rate. Can always use Slime skills, dealing",
      "+15% damage. Nullify attacks that deal 300 damage or less.",
      "Counters with Slime Splash.",
    ],
    300 => ["Oni Club",
      "Can always equip Clubs and use Club skills, dealing +50%",
      "damage, but have 133% SP cost.",
    ],
    301 => ["Tiger Sword",
      "Can always equip Katanas. Can always use Katana and Beast",
      "skills, dealing +30% damage. Katana skills deal +100% damage",
      " to Blinded foes and can use Attack in place of Dexterity.",
    ],
    302 => ["Vampire of Darkness",
      "Can always use Demon Arts. Demon Arts skills deal +15%",
      "damage (+100% to Shocked foes) with 66% SP cost.",
    ],
    303 => ["Orpheus Body",
      "Innate Confusion Strike 30%. Deal +30% Sonic damage.",
      "Can always use Singing and Artificial skills.",
      "Singing skills have 50% SP cost.",
    ],
    304 => ["Machine Capsule",
      "Can always use Gun, Makina, and Artificial skills.",
      "Gun and Makina skills deal +30% damage with 66% SP cost.",
    ],
    305 => ["Tentacle Fist",
      "Can always use Unarmed, Tentacle, and Artificial skills.",
      "Unarmed and Tentacle skills deal +30% damage with 66% SP",
      "cost.",
    ],
    306 => ["Twin Apoptosis",
      "Normal attacks gain an extra hit. Can always use Gun and",
      "Artificial skills. Artificial skills deal +100% damage to",
      "Shocked foes and execute an additional time, but have 150%",
      "SP cost.",
    ],
    307 => ["Dancing Anemone",
      "Innate Bind Strike 30%. Can always use Dancing, Tentacle,",
      "and Ocean skills. Tentacle skills deal +15% damage (+100% to",
      "Bound foes). Dancing skills have 66% SP cost.",
    ],
    308 => ["I'm a Sea Dragon!",
      "Deal +30% Ice and Water damage. Immune to Water damage.",
      "Can always use Ocean, Nature, and Breath skills.",
      "Ocean skills deal +1% damage for every % of missing HP.",
    ],
    309 => ["Ocean Champion",
      "Deal +30% Water damage. Immune to Water damage.",
      "Can always use Flail, Piracy, and Ocean skills.",
      "Flail and Piracy skills deal +30% damage with 66% SP cost.",
      "33% chance of using Maelstrom at the start of battle.",
    ],
    310 => ["Horned Sea Snake",
      "+50% Max HP. Can always use Ocean, Beast, Snake, Breath and",
      "Giant skills, dealing +30% damage. Snake, Breath and Giant",
      "skills have 66% SP cost. Immune to Water damage.",
    ],
    311 => ["Dancing Fairy",
      "Can always use Dancing and Nature skills.",
      "Dancing skills have +15% status infliction",
      "rate. Dancing skills have 66% SP cost.",
      "Targeted by foes half as often.",
    ],
    312 => ["Barbarian Elf",
      "Can always use Axe and Bow skills, dealing +15% damage with",
      "66% SP cost. Axe skills use the highest of Dexterity or",
      "Attack, and Bow skills can use Attack in place of Dexterity.",
    ],
    313 => ["Magical Beast",
      "100% Magic Reflect rate. Can always use Black Magic, White",
      "Magic, and Beast skills. Black and White Magic deal +30% ",
      "damage.",
    ],
    314 => ["Forest Giant",
      "+30% Max HP/Attack/Defense. Can always use Giant skills,",
      "dealing +30% damage and have 66% SP cost.",
    ],
    315 => ["Fairy Queen",
      "Can always use Summoning and Dancing skills, dealing +30%",
      "damage and having 50% SP and MP cost.",
    ],
    316 => ["Elf Queen",
      "Can always use Bow skills and White Magic, dealing +30%",
      "damage and having 50% SP and MP cost.",
    ],
    317 => ["Forest Flower Spirit",
      "+20% Counter rate. Can always use Plant skills, dealing +15%",
      "damage and having +15% status infliction rate. Counters with",
      "Flower Fragrance.",
    ],
    318 => ["Forest Tree Spirit",
      "Innate Drain Strike 50%. Can always use Plant skills,",
      "dealing +15% damage. Curative White Magic imparts Agility Up.",
    ],
    319 => ["Sadistic Alraune",
      "Can always use Plant skills, dealing +100% damage to Tranced",
      "and/or Seduced foes with +30% status infliction rate.",
    ],
    320 => ["White Dryad",
      "Can always use White Magic and Plant skills, dealing +30%",
      "damage. White Magic has 66% MP cost.",
    ],
    321 => ["Black Dryad",
      "Can always use Black Magic and Plant skills, dealing +30%",
      "damage. Black Magic has 66% MP cost.",
    ],
    322 => ["Queen of Alraunes",
      "Can always use Whip and Plant skills, dealing +30% damage",
      "with 50% SP cost.",
    ],
    323 => ["Queen of Harpies",
      "Can always use Dancing and Wing skills, dealing +30% damage",
      " with 50% SP cost.",
    ],
    324 => ["Chivalrous Mermaid",
      "Can always equip Swords, Knight Swords, Shields,",
      "Helmets, and Heavy Armor. Can always use Sword and",
      "Ocean skills. Sword skills deal +30% damage.",
    ],
    325 => ["Mermaid General",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear and Singing skills. Spear skills deal +30% damage",
      "(+100% to Seduced foes). Singing skills have 66% SP cost.",
    ],
    326 => ["Lorelei of the Ocean",
      "Can always use Singing and Ocean skills, dealing +15% damage",
      "with 66% SP cost. Singing skills have +15% status infliction",
      "rate. 30% chance of singing Mermaid Song at the start of",
      "battle.",
    ],
    327 => ["Mermaid Princess",
      "Deal +30% Water damage. Can always use Singing and Ocean",
      "skills with half SP cost. Singing skills have increased",
      "priority. +15% to all stats stats if Laura is in the main",
      "party.",
    ],
    328 => ["Queen Mermaid",
      "Can always use White Magic, Singing, and Ocean skills.",
      "White Magic and Ocean skills deal +30% damage and heal",
      "+30% HP with half MP and SP cost.",
      "+15% to all stats if El is in the main party.",
    ],
    329 => ["Queen of the Southern Sea",
      "+30% Attack. Can always equip Clubs. Can always use Club,",
      "Tentacle, Ocean, and Giant skills. Club and Tentacle skills",
      "deal +30% damage. Tentacle and Ocean skills can use Attack in",
      "place of other stats. +15% to all stats if Poseidoness is",
      "in the main party.",
    ],
    330 => ["Spider Group",
      "Normal attacks hit four random foes. Can always use Time",
      "Magic and Insect skills. Time Magic and skills using sticky",
      "thread execute an additional time, but have 150% MP and SP",
      "cost.",
    ],
    331 => ["Taoism Spinning Spider",
      "Can always use Taoism, Ninjutsu, Demon Arts, and Insect",
      "skills. Taoism, Ninjutsu, and Insect skills deal +15% damage.",
      "Taoism skills have 66% MP cost and deal +100% damage to",
      "Slimed and/or Bound foes",
    ],
    332 => ["Fighting Spider",
      "Innate Bind Strike 30%. Can always use Unarmed and Insect",
      "skills, dealing +15% damage. Unarmed skills have 66% SP cost",
      "and deal +100% damage to Slimed and/or Bound foes.",
    ],
    333 => ["Devilish Spider",
      "Can always use Black Magic, Time Magic, and Insect skills,",
      "dealing +30% damage. Time Magic has +15% status infliction",
      "rate. Black and Time Magic deal +100% damage to Slimed",
      "and/or Bound foes.",
    ],
    334 => ["Queen Spider",
      "Can always use Katana, Time Magic, and Insect skills,",
      "dealing +30% damage and have 50% SP/MP cost.",
    ],
    335 => ["Ferocious Vampire",
      "Can always equip Daggers, Swords, and Knight Swords.",
      "Can always use Demon Arts, Dagger, and Sword skills, dealing",
      "+30% damage. Bloodsucking skills deal +50% damage and have",
      "50% SP cost.",
    ],
    336 => ["Magical Vampire",
      "Can always equip Rods. Can always use Black Magic and Demon",
      "Arts, dealing +30% damage. Bloodsucking skills deal +50%",
      "damage and have 50% SP cost.",
    ],
    337 => ["Sucking Vampire",
      "+20% Counter rate. Innate Drain Strike 50%. Can always use",
      "Demon Arts, dealing +30% damage. Bloodsucking skills deal",
      "+50% damage and have 50% SP cost. Counters with Deadly",
      "Bloodsucking.",
    ],
    338 => ["Magical Edge",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword, Spellblade, and Demon Arts skills. Sword skills deal",
      "+30% damage (+100% to Shocked foes). Spellblade skills have",
      "50% MP cost.",
    ],
    339 => ["Bloody Elizabeth",
      "Deal +30% Lightning damage. Can always use Black Magic,",
      "Summoning, and Ninjutsu skills. Black Magic and Summoning",
      "have 66% MP cost and deal +100% damage to Shocked foes.",
    ],
    340 => ["Queen Vampire",
      "Can always use Sword skills and Demon Arts, dealing +30%",
      "damage. Sword skills have 50% SP cost. Demon Arts have half",
      "SP and MP cost.",
    ],
    341 => ["Queen Succubus Sisters",
      "Normal attacks gain an extra hit. Can always use Sexcraft and",
      "Nature skills, executing an additional time but have 150% SP",
      "cost.",
    ],
    342 => ["Noble Ghost",
      "Can always use Black Magic and Corpse skills.",
      "Corpse skills deal +30% damage and have 66% SP cost.",
    ],
    343 => ["Misty Ghost",
      "+15% Evasion/Magic Evasion rate. Can always use Taoism,",
      "Demon Arts, and Corpse skills, dealing +15% damage.",
      "Taoism skills have 66% MP cost.",
    ],
    344 => ["Soaring Kirin",
      "Innate Shock Strike 30%. Deal +30% Lightning damage.",
      "Can always use Spear and Nature skills, dealing +15% damage.",
      "Spear skills deal +100% damage to Shocked foes.",
    ],
    345 => ["Graceful Snake",
      "Can always equip Flails and Fans. Can always use Flail,",
      "Dancing, and Snake skills, dealing +15% damage.",
      "Flail skills deal +100% damage to Bound foes.",
    ],
    346 => ["Rampaging Behemoth",
      "Can always use Beast skills, dealing +50% damage and gaining",
      "+1% damage for every % of missing HP, but have 133% SP cost.",
    ],
    347 => ["Fire Dragon of the Sky",
      "+15% Evasion rate. Can always use Wing and Breath skills,",
      "dealing +30% damage. Breath skills increase Evasion by 50%",
      "for 4 turns.",
    ],
    348 => ["Colossal Dragon",
      "+50% Max HP. +20% Counter rate. Can always use Giant skills,",
      "dealing +50% damage, but have 133% SP cost. Counters with",
      "Megaton Press.",
    ],
    349 => ["Succubus Brawler",
      "Can always use Unarmed/Sexcraft skills. Unarmed skills deal",
      "+30% damage (+100% to Horny/Tranced/Seduced foes).",
    ],
    350 => ["Demon Brawler",
      "Can always use Demon Arts/Unarmed skills. Unarmed skills deal",
      "+15% damage (+100% to Burned foes) with 66% SP cost.",
    ],
    351 => ["Monster Lord's Castle Maid",
      "Can always use Service and Tentacle skills, dealing +15%",
      "damage with 66% SP cost. 30% chance of gaining Tentacle Up",
      "when using Service skills.",
    ],
    352 => ["Halfling of Light and Darkness",
      "Can always use Demon Arts, Holy, and Dark skills.",
      "Holy and Dark skills deal +15% damage. Randomly gain",
      "+30% Holy or Dark elemental damage at the start of battle.",
    ],
    353 => ["Ice Magician",
      "Deal +30% Ice damage. Can always use Black Magic and Demon",
      "Arts, dealing +15% damage. Black Magic deals +100% damage",
      "to Frozen foes. Immune to Ice damage.",
    ],
    354 => ["Raging Polar Bear",
      "Innate Freeze Strike 30%. Can always use Unarmed, Beast, and",
      "Breath skills, dealing +30% damage. Immune to Ice damage.",
    ],
    355 => ["Angel Army",
      "Normal attack hits four random foes. Can always use Sword",
      "and Holy skills. Holy skills execute an additional time, but",
      "have 150% MP and SP cost.",
    ],
    356 => ["Holy Trinity",
      "Normal attack hits four random foes. Can always use Singing,",
      "Sexcraft, and Holy skills. Singing and Sexcraft skills",
      "execute an additional time but have 150% MP and SP cost.",
    ],
    357 => ["Holy Beast",
      "Can always use Holy and Beast skills, dealing +30% damage",
      "with 66% SP cost.",
    ],
    358 => ["Elysium's Fruit",
      "Innate Sleep/Trance Strike 30%. Can always use Holy and",
      "Plant skills, dealing +30% damage with 66% SP cost.",
    ],
    359 => ["Cupid of Love",
      "Innate Seduction Strike 30%. Can always equip Bows.",
      "Can always use Bow, White Magic, and Holy skills, dealing",
      "+30% damage. +15% to all stats if Victoria is in the main",
      "party.",
    ],
    360 => ["Valiant War Maiden",
      "Can always equip Swords, Knight Swords, Spears, and Heavy",
      "Spears. Can always use Sword, Spear, and Holy skills,",
      "dealing +30% damage. +15% to all stats if Cupi is in the ",
      "main party.",
    ],
    361 => ["Angel Hair",
      "Can always use Black Magic, Time Magic, and Holy skills,",
      "dealing +30% damage. Skills using hair deal +50% damage and",
      "have +50% status infliction rate.",
    ],
    362 => ["Rumble Angel",
      "Normal attacks gain two extra hits. Can always use Holy",
      "skills, executing an additional time, but have 150% MP and SP",
      "cost.",
    ],
    363 => ["Chimeric Beast",
      "Can always use Beast, Artificial, and Breath skills, dealing",
      "+15% damage with 66% SP cost.",
    ],
    364 => ["Chimeric Slime",
      "Can always use Slime, Tentacle, and Artificial skills,",
      "dealing +15% damage with 66% SP cost.",
    ],
    365 => ["Chimeric Tentacle Angel",
      "Can always use Holy, Tentacle, and Artificial skills,",
      "dealing +15% damage with 66% SP cost.",
    ],
    366 => ["Chimeric Angel Corpse",
      "Can always use Holy, Corpse, and Artificial skills, dealing",
      "+15% damage with 66% SP cost.",
    ],
    367 => ["Circling Tentacle",
      "Can always use Ocean, Tentacle, and Artificial skills,",
      "dealing +15% damage with 66% SP cost.",
    ],
    368 => ["Revived Monster Swordswoman",
      "Can always equip Swords, Knight Swords, Helmets, Shields,",
      "and Heavy Armor. Can always use Sword, Spellblade, and",
      "Corpse skills. Sword and Corpse skills deal +50% damage,",
      "but cost 133% SP.",
    ],
    369 => ["Legendary Monster Swordsman",
      "Can always equip Swords, Knight Swords, Rapiers, and",
      "Heavy Armor. +20% Evasion, Magic Evasion, and Critical Rate.",
      "+50% Critical Damage. Can always use Sword, Rapier, and",
      "Spellblade skills. Sword and Rapier skills deal 50% more",
      "damage. Rapier skills chain into Sword skills.",
    ],	  
    370 => ["Revived Dark Fairy",
      "Can always use Black Magic, Dancing, Nature, and Corpse",
      "skills. Nature and Corpse skills deal +50% damage, but have",
      "133% SP cost.",
    ],	  
    371 => ["Notorious Dark Fairy",
      "50% Magic Reflect rate. Reflected attacks deal 100x more",
      "damage. Can always use Black Magic, Dancing, and Nature",
      "skills. Black Magic and Nature skills deal +50% damage.",
      "Black Magic has increased priority, and chains into Nature",
      "skills.",
    ],
    372 => ["Revived Pirate Queen",
      "Can always use Piracy, Singing, Ocean, and Corpse skills.",
      "Piracy and Corpse skills deal +50% damage but have 133% SP",
      "cost.",
    ],
    373 => ["Renowned Pirate Queen",
      "Can always equip Swords, Knight Swords, Great Swords, and",
      "Heavy Armor. Can always use Sword, Piracy, Singing, and Ocean",
      "skills. Sword and Piracy skills deal +50% damage. Sword",
      "skills chain into Piracy skills. Chained skills deal +30%",
      "damage.",
    ],
    374 => ["Revived Queen Lamia",
      "Can always equip Flails. Can always use Flail, Dancing,",
      "Snake, and Corpse skills. Flail, Snake, and Corpse skills",
      "deal +50% damage, but have 133% SP cost.",
    ],
    375 => ["Compassionate Queen Lamia",
      "Can always equip Flails. Can always use Flail, White Magic,",
      "Dancing, Medicine, and Snake skills. Flail, White Magic, and",
      "Snake skills deal +50% damage and have persistence.",
    ],
    376 => ["Revived Former Queen Harpy",
      "Can always equip Heavy Armor. Can always use Spear,",
      "Thievery, Wing, and Corpse skills. Spear and Corpse skills",
      "deal +50% damage, but have 133% SP cost.",
    ],
    377 => ["Queen Harpy, Goddess of War",
      "Can always equip Heavy Armor. Can always use Rapier, Spear,",
      "Thievery, and Wing skills. Rapier, Spear, and Wing skills",
      "deal +50% damage. Wing skills chain into Rapier, then Spear",
      "skills. Nullifies and counters attacks 30% of the time with",
      "Air Superiority.",
    ],
    378 => ["Revived Queen Scylla",
      "Can always use Tentacle and Corpse skills, dealing +50%",
      "damage but have 133% SP cost.",
    ],
    379 => ["Tranquil Queen Scylla",
      "Can always use White Magic, Mercantile, Talk, Tentacle, and",
      "Ocean skills. White Magic, Tentacle, and Ocean skills deal",
      "50% more damage and heal 30% more HP. White Magic skills use",
      "the highest of Dexterity or Willpower. White Magic chains",
      "into Tentacle skills.",
    ],
    382 => ["Aura Succubus",
      "Can always equip Swords, Knight Swords, and Magic Swords.",
      "Can always use Sword, Spellblade, Sexcraft, and Psychic",
      "skills. Sword, Sexcraft, and Psychic skills deal +50% damage",
      "(+100% to foes afflicted with pleasure ailments), gain +1%",
      "damage for every % of missing HP, have 133% MP/SP cost, and",
      "have a 20% chance to inflict Horny and Climax. 150% XP rate.",
    ],
    383 => ["The Third Seraph",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear and Holy skills, dealing +50% damage but have 133% SP",
      "cost and can use Attack in place of other stats. +30% to all",
      "stats if Ilias, Micaela-chan, or Lucifina-chan is in the",
      "party.",
    ],
    384 => ["Existence Unified with the Angelic Dominion",
      "Innate double action. Maximum HP +100%. Can always use Holy",
      "and Tentacle skills, dealing +50% damage and can use Attack",
      "in place of other stats, but have 133% SP cost. +30% to all",
      "stats if Ilias, Micaela-chan, or Lucifina-chan are in the",
      "party.",
    ],
    385 => ["Goddess's Right-Hand Seraph",
      "Innate Stigmata Strike 30%. Can always equip Spears and Heavy",
      "Spears. Can always use Spear, Throwing, and Holy skills.",
      "Spear and Holy skills deal +50% damage and can use Attack in",
      "place of other stats, but have 133% SP cost. Sacred Spear",
      "Longinus skills can be used without equipping the weapon, and",
      "deal +200% damage to enemies afflicted with status ailments.",
    ],
    386 => ["Seraph Embodied with Divine Will", #NOTE: Original description excludes mention of innate Stigmata Strike.
      "Innate Stigmata Strike 30%. Can always equip Spears and Heavy",
      "Spears. Can always use Spear, Throwing, and Holy skills.",
      "Spear and Holy skills deal +75% damage and can use Attack in",
      "place of other stats, but have 150% SP cost. Sacred Spear",
      "Longinus skills can be used without equipping the weapon, and",
      "deal +200% damage to enemies afflicted with status ailments.",
    ],
    387 => ["Seraph Who Abandoned the Goddess", #NOTE: Also pierces Carnage resistance, which isn't mentioned in the original text
      "+20% Critical Rate/+50% Critical Damage. Innate Physical/",
      "Carnage Element Pierce. Can always equip Spears and Heavy",
      "Spears. Can always use Spear and Gun skills, dealing +50%",
      "damage and can use Attack in place of other stats, but have",
      "133% SP cost.",
    ],
    388 => ["Trinity of Eden", #NOTE: Also pierces Carnage resistance, which isn't mentioned in the original text
      "Gets an additional action every turn. All Stats +20%.",
      "Innate Physical/Carnage Element Pierce. Can always equip",
      "Spears and Heavy Spears. Can always use Spear, Throwing, Gun,",
      "and Holy skills. Spear, Gun, and Holy skills deal +50% damage",
      "and can use Attack in place of other stats, but have 133% SP",
      "cost. Sacred Spear Longinus skills can be used without",
      "equipping the weapon, and deal +200% damage to enemies",
      "afflicted with status ailments. +30% to all stats if Ilias,",
      "Micaela-chan, or Lucifina-chan is in the party.",
    ],
    391 => ["Angry Magic Teacher",
      "Can always use Black/White Magic and Snake skills, dealing",
      "+15% damage and gaining +1% damage for every % of missing",
      "HP. Snake skills have 66% SP cost.",
    ],
    392 => ["Magic Teacher From Another World",
      "Can always use White Magic, Black Magic, Magic Science, and",
      "Grimoire skills, dealing +50% damage. White Magic chains into",
      "Black Magic, then Magic Science skills.",
    ],
    393 => ["Angry Magic Teacher",
      "Can always use White Magic, Black Magic, and Snake skills,",
      "dealing +75% damage and gaining +1% damage for every % of",
      "missing, but have 133% MP/SP cost. White Magic chains into",
      "Black Magic, then Snake skills.",
    ],
    394 => ["Supportive Middle Sister",
      "Can always equip Fans. Can always use White Magic, Black",
      "Magic, Dancing, Singing, Talk, and Psychic skills. White",
      "Magic, Black Magic, Dancing, Singing, and Psychic skills",
      "deal +50% damage, but have 133% MP and SP cost. Black Magic,",
      "Dancing, Singing, Talk, and Psychic skills inflict status",
      "ailments 15% more often. White Magic, Black Magic, and",
      "Psychic skills can use Dexterity in place of other stats.",
      "150% Job XP Rate.",
    ],
    395 => ["Wind-manipulating Eldest Sister",
      "Can always equip Whips. Wind attacks also inflict Pleasure",
      "damage. Can always use Whip, Black Magic, Time Magic,",
      "Service, Nature, and Psychic skills, dealing +30% damage,",
      "and can use Dexterity in place of other stats. Whip, Nature,",
      "and Psychic skills deal +100% damage to foes afflicted with",
      "pleasure ailments and have a 20% chance to inflict Trance",
      "and Seduction. Whip skills chain into Nature skills.",
      "150% XP/Job XP Rate.",
    ],
    396 => ["Primordial Lilith",
      "Gets an additional action every turn. All Stats +20%.",
      "Wind and Pleasure attacks inflict Hadron and Nightmare",
      "damage. Can always equip Whips. Can always use Whip, Black",
      "Magic, Sexcraft, Nature, and Psychic skills, dealing +50%",
      "damage. Whip, Black Magic, Nature, and Psychic skills have",
      "133% MP/SP cost, and can use Dexterity in place of other",
      "stats. Chains Whip skills into Psychic then Nature skills.",
    ],
    397 => ["Iron-Blooded Seraph", #NOTE: Also pierces Carnage resistance, which isn't mentioned in the original text
      "Deal +50% Gravity damage. Innate Physical/Carnage Element",
      "Pierce. Can always equip Fists. Can always use Unarmed and",
      "Artificial skills, dealing +50% damage, but have 133%",
      "SP cost. Artificial skills can use Agility in place of",
      "other stats.",
    ],
    398 => ["Iron-Blooded Seraph: Limit Break", #NOTE: Also pierces Carnage resistance, which isn't mentioned in the original text
      "Deal +50% Physical/Gravity damage. Innate Physical/Carnage",
      "Element Pierce. Can always equip Fists. Can always use",
      "Unarmed and Artificial skills, dealing +50% damage, but have",
      "doubled SP cost. Artificial skills can use Agility in place",
      "of other stats. HP decreases by 10% each turn.",
    ],
    399 => ["Iron-Blooded Seraph: Over-Break",
      "Deal +75% Carnage/Gravity damage. Physical attacks inflict",
      "Carnage damage and pierce resistances to them. Can always",
      "equip fists. Can always use Unarmed and Artificial skills,",
      "dealing +75% damage, but have tripled SP cost. Artificial",
      "skills can use Agility in place of other stats. HP decreases",
      "by 30% each turn.",
    ],
    400 => ["Iron-Blooded Seraph: Ultimate",
      "Deal +100% Carnage/Gravity damage. Physical attacks inflict",
      "Carnage damage and pierce resistances to them. Can always",
      "equip fists. Can always use Unarmed and Artificial skills,",
      "dealing +75% damage, but have 5x SP cost. Artificial skills",
      "can use Agility in place of other stats. HP decreases by 80%",
      "each turn.",
    ],
    401 => ["Abominable Deformed Seraph",
      "Maximum HP +50%. Can always use Black Magic, Time Magic,",
      "Holy, and Makina skills, dealing +30% damage and healing",
      "30% more HP. Black Magic, Time Magic, and Makina skills can",
      "use Willpower in place of other stats. Black Magic, Time",
      "Magic, and Makina skills chain into Holy skills. Twice per",
      "battle, revive when defeated.",
    ],
    403 => ["Majestic Divine Bird",
      "Maximum HP +100%. Can always use Dancing, Wing, and Giant",
      "skills. Dancing and Wing skills deal +50% damage and have",
      "persistence. Immune to Wind.",
    ],
    404 => ["Brawling Master Cockroach",
      "Can always equip Fists. +15% Evasion/Magic Evasion Rate.",
      "Can always use Unarmed skills, dealing +30% damage.",
    ],
    405 => ["Cockroach Ninja",
      "Can always equip Ninja Swords. +15% Critical Rate/",
      "+25% Critical Damage. Can always use Ninjutsu, dealing",
      "+30% damage.",
    ],
    406 => ["Cockroach Queen",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword and Ruling skills, dealing +50% damage, but have 133%",
      "SP cost.",
    ],
    407 => ["Pot Hikikomori",
      "Can always equip Staves and Rods. Can always use Black Magic,",
      "Time Magic, and Slime skills. Black and Time Magic execute",
      "an additional time, but have 133% MP cost, and automatically",
      "guards afterwards. Targeted by foes 25% as often.",
    ],
    408 => ["Bean Merchant Tanuki",
      "Can always equip Abacus. Can always use Mercantile skills",
      "with 75% gold cost, and automatically guards afterwards.",
    ],
    409 => ["Taoist Tanuki",
      "Can always equip Rods. Can always use Taoism skills, dealing",
      "+30% damage with 66% MP cost.",
    ],
    410 => ["Ninja Tanuki",
      "Can always equip Ninja Swords. Can always use Ninjutsu",
      "skills, dealing +30% damage with 66% MP cost.",
    ],
    411 => ["Ferocious Tanuki",
      "Can always equip Fists and Fangs. +15% Critical/Evasion Rate.",
      "Can always use Unarmed and Beast skills, dealing +30%",
      "damage.",
    ],
    412 => ["Drunken Tao Swordsman",
      "Can always equip Swords and Magic Swords. Can always use",
      "Sword and Taoism skills. Tao Swordsman skills deal +50%",
      "damage. Taoism skills can use Attack in place of other stats.",
      "+50% to all stats while in the Gadabout job. (This trait is a",
      "removable ability)",
    ],
    413 => ["Tanuki Clan Leader",
      "Can always equip Ninja Swords. Can always use Taoism,",
      "Ninjutsu, and Sorcery skills, dealing +50% damage but have",
      "133% MP and SP cost.",
    ],
    414 => ["Ninja Group",
      "Normal attack hits four random foes. Can always equip Ninja",
      "Swords. Can always use Ninjutsu, Cooking, and Service skills.",
      "Ninjutsu skills execute an additional time, but have 133% SP",
      "cost.",
    ],
    415 => ["Kunoichi Succubus",
      "Can always equip Ninja Swords. Can always use Ninjutsu and",
      "Sexcraft skills. Pleasure-based Ninjutsu skills deal +50%",
      "damage and have 66% SP cost.",
    ],
    416 => ["Kunoichi Harpy",
      "Can always equip Ninja Swords. Can always use Ninjutsu and",
      "Wing skills, dealing +30% damage with 66% SP cost.",
    ],
    417 => ["Kunoichi Scylla",
      "Can always equip Ninja Swords. Can always use Ninjutsu and",
      "Tentacle skills, dealing +30% damage with 66% SP cost.",
    ],
    418 => ["Kunoichi Arachne",
      "Can always equip Ninja Swords. Can always use Ninjutsu and",
      "Insect skills, dealing +30% damage with 66% SP cost.",
    ],
    419 => ["Hikikomori Musou",
      "Can equip three weapons at once (The third weapon is equipped",
      "in the Accessory slot). Can equip all types of weapons and",
      "armor. Can always use Sword, Katana, Bow and Ninjutsu skills,",
      "dealing +30% damage. Sword skills use the highest of",
      "Dexterity or Attack.",
    ],
    420 => ["Eight-Tailed Senko",
      "+20% Magic Evasion/+10% Magic Critical Rate. Can always use",
      "Taoism and Ninjutsu skills, dealing +50% damage but have",
      "+133% MP and SP cost. Regenerates 20% of max SP each turn",
      "when below 50% HP. Counterattacks with Fox Ninpo:Roaring",
      "Flame Wheel. Reflects Earth damage.",
    ],
    421 => ["Devilish Succubus",
      "Can always use Black Magic and Sexcraft skills, dealing +30%",
      "damage. Black Magic deals +100% damage to foes affected by ",
      "pleasure ailments.",
    ],
    422 => ["Speed is Power!",
      "Can always equip Spears, Heavy Spears, and Heavy Armor.",
      "Can always use Spear skills, dealing +30% damage.",
      "Deals +50% damage if acting first in the turn order.",
    ],
    423 => ["Ferocious Aevis",
      "Can always equip Fangs. Can always use Beast and Breath",
      "skills, dealing +30% damage, with 25% more damage when at",
      "full SP.",
    ],
    424 => ["Supreme Taoist Kitsune",
      "Can always use Taoism, Talk, and Sorcery skills. Taoism and",
      "Sorcery skills deal +30% damage. 50% chance of Shikigami",
      "Support at the beginning and end of turn.",
    ],
    425 => ["Supreme Courtesan Kitsune",
      "Can always equip Fans and Harps. Can always use Singing,",
      "Dancing, Talk, and Sexcraft skills with 66% SP cost and",
      "+15% status infliction rate.",
    ],
    426 => ["Black Flower",
      "Can always equip Whips and Sex Toys. Can always use Whip and",
      "Sexcraft skills, dealing +50% damage but have 133% SP cost.",
      "+15% to all stats if Black Mamba or Black Rose is in the main",
      "party.",
    ],
    427 => ["Black Snake",
      "Can always equip Spears, Heavy Spears, and Heavy Armor.",
      "Can always use Spear and Snake skills, dealing +50% damage",
      "but have 133% SP cost. +15% to all stats if Black Dahlia or",
      "Black Rose is in the main party.",
    ],
    428 => ["Black Rose",
      "Can always equip Rods. Can always use Black Magic, Time",
      "Magic, and Demon Arts, dealing +50% damage but have 133%",
      "MP cost. +15% to all stats if Black Dahlia or Black Mamba is",
      "in the main party.",
    ],
    429 => ["Puppeteer of Nothingness",
      "Can always use Summoning skills. Puppet Summoning skills deal",
      "+30% damage with 66% SP cost. At the end of turn, Amor Rahm",
      "and Amor Rihm will provide supporting attacks.",
    ],
    430 => ["Split Pomegranate",
      "Can always equip Scalpels. Can always use Time Magic, Magic",
      "Science, and Medicine skills, dealing +30% damage and have.",
      "persistence.",
    ],
    431 => ["Trinihility Flower",
      "Can always equip Flails. Can always use Flail and Plant ",
      "skills, executing an additional time but have 133% SP cost.",
      "50% of Dexterity is added to Flail skill power.",
    ],
    432 => ["Greatest Red Shikigami",
      "Can always equip Clubs. Can always use Club skills, dealing",
      "+30% damage with 66% SP cost. Deals +25% damage with Club",
      "skills when at full SP.",
    ],
    433 => ["Greatest Blue Shikigami",
      "Can always equip Rods. Can always use Taoism skills,",
      "dealing +30% damage with 66% MP cost. Deals +25% damage with",
      "Taoism skills when at full MP.",
    ],
    435 => ["Impish Angel",
      "Can always equip Bows. Can always use Bow and Sexcraft",
      "skills, dealing +30% damage. Bow skills deal +100% damage",
      "to foes afflicted with pleasure ailments. Chains Sexcraft",
      "skills into Bow skills.",
    ],
    436 => ["Huge-Breasted Brawling Angel",
      "Can always equip Fists. Can always use Unarmed and Mercantile",
      "skills. Unarmed skills deal +30% damage and follow up with",
      "a breast slap.",
    ],
    437 => ["Tentacle Complex",
      "Can always equip Whips. Can always use Whip and Tentacle",
      "skills, dealing +30% damage. Chains Whip skills into Tentacle",
      "skills.",
    ],
    438 => ["Blitz of Retribution",
      "Deal +30% Lightning damage. Can always equip Swords and",
      "Knight Swords. Can always use Sword skills, dealing +30%",
      "damage. Sword skills are followed up with Demon Slaying",
      "Thunder and deal +100% to Shocked foes. Starts battles with",
      "Spellblade Thunder active. Immune to Lightning.",
    ],
    439 => ["Trinity of Ivy and Tentacles",
      "Normal attack hits four random foes. Can always use Tentacle",
      "and Plant skills, dealing +30% damage. Uses Tentacle Storm at",
      "the start of turn, and Frantic Ivy Hell at the end of turn.",
    ],
    440 => ["Cruel Serpent Angel",
      "Can always equip Flails. Can always use Flail and Snake",
      "skills, dealing +30% damage. Snake skills deal +100% damage",
      "to Paralyzed and Bound foes. Automatically uses Snake",
      "Punisher at the end of turn.",
    ],
    441 => ["Medusa + Dullahan",
      "Normal attack hits an additional time. Snake skills execute",
      "an additional time, but have 133% SP cost. 25% chance of",
      "gaining an additional action each turn.",
    ],
    442 => ["Taciturn Plant Angel",
      "Can always equip Whips. Can always use Whip, White Magic, and",
      "Plant skills, dealing +30% damage with 50% MP/SP cost. May",
      "use Cleansing Honey on allies at the end of turn.",
    ],
    443 => ["Heavenly Flower of Supreme Bliss",
      "Can always equip Harps. Can always use Holy, Singing, and",
      "Plant skills, dealing +30% damage. Plant skills execute",
      "twice. Chains Singing skills into Holy or Plant skills.",
    ],
    444 => ["Valiant Angel of the Cutting Charge",
      "Innate Dual Wield, and increases stats of equipped weapons by",
      "50% while dual wielding. +10% Critical Rate/+25% Critical",
      "Damage. Can always equip Swords and Knight Swords. Can always",
      "use Sword and Multiweapon skills, dealing +30% damage and",
      "have increased priority. Chains Sword skills into Multiweapon",
      "skills.",
    ],
    445 => ["Energy-Sucking Trooper",
      "Can always equip Guns. Normal attack is replaced with Drain",
      "Strike. Can always use Gun skills, dealing +30% damage, have",
      "50% SP cost, and restore own HP by 25% of damage dealt.",
    ],
    446 => ["Ultimate Fighter Angel",
      "Can always equip Swords, Knight Swords, and Heavy Armor.",
      "Can always use Sword and Unarmed skills, dealing +30% damage.",
      "Unarmed skills can use Attack in place of Agility. Chains",
      "Sword skills into Unarmed skills.",
    ],
    447 => ["Strong Armed Insect Angel",
      "Can always equip Fists. Can always use Unarmed and Insect",
      "skills, dealing +30% damage with 66% SP cost. Insect skills",
      "execute twice.",
    ],
    448 => ["Ecstasy Cocoon Execution Angel", #NOTE: Original description states 20% SP cost on sticky thread skills, but is actually 50%
      "Innate Trance Strike 30%. Can always use Insect skills,",
      "dealing +100% damage to Tranced foes and have a 30% chance of",
      "inflicting Trance. Skills using sticky thread have 50% SP",
      "cost and deal +50% damage.",
    ],
    449 => ["Forbidden Fruit",
      "Can always use Black Magic, Cooking, and Plant skills,",
      "dealing +30% damage. Plant skills have a 30% chance to",
      "inflict Trance. Black Magic deals +100% damage to Tranced",
      "foes. 50% chance to prey upon poisoned, paralyzed, tranced,",
      "or partially digested foes at the end of turn.",
    ],
    450 => ["Verdant Plant",
      "Innate Sleep+Bind Strike 30%. Can always use Alchemy and",
      "Plant skills. Plant have a 30% chance to inflict Sleep and",
      "Bind, and deal +150% damage to sleeping or bound foes. 50%",
      "chance of not consuming materials when using Alchemy skills.",
    ],
    451 => ["Angel of Motherly Renewal",
      "Can always equip Staves. Can always use White Magic and Time",
      "Magic, dealing +30% damage. White Magic has persistence.",
      "Revival White Magic imbues allies with All Stats Up.",
    ],
    452 => ["Lewd Tongue Chimera",
      "Innate Slimed Strike 50%. Skills using tongues deal",
      "+30% damage and execute two additional times. Club skills",
      "deal +150% damage to Slimed foes.",
    ],
    453 => ["Gunner Chimera",
      "Can always equip Guns. Can always use Gun, Service, and",
      "Insect skills, dealing +30% damage with 66% SP cost.",
      "Chains Insect skills into Gun or Service skills.",
    ],
    454 => ["Knife Slug",
      "Innate Slimed Strike 100%. Can always equip Daggers.",
      "Can always use Dagger skills, dealing +30% damage",
      "(+150% damage to Slimed foes).",
    ],
    455 => ["Rampaging Alraune",
      "Critical Rate +15%/Critical Damage +50%. Can always equip",
      "Flails. Can always use Flail and Plant skills, dealing +30%",
      "damage with 66% SP cost. 50% of Dexterity is added to Flail",
      "skill power. Flail skills deal +150% damage to Poisoned,",
      "Paralyzed, or Tranced foes. Chains Plant skills into Flail",
      "skills.",
    ],
    456 => ["Curse of the Catoblepas",
      "Innate Poison+Petrify Strike 30%. Can always equip Axes.",
      "Can always use Axe and Breath skills, dealing +30% damage.",
      "Breath skills have a 30% chance to inflict Poison and",
      "Petrify. Axe skills deal +150% damage to Poisoned or",
      "Petrified foes. Chains Axe skills into Breath skills.",
    ],
    457 => ["Greedy Typhon",
      "Can always equip Flails. Can always use Flail skills,",
      "dealing +30% damage. Flail and Breath skills have a 30%",
      "chance to inflict Stun. Chains Flail skills into Breath",
      "skills. 33% chance to prey upon all bound or partially",
      "digested foes at the end of turn.",
    ],
    458 => ["High-Consumption + Energy Tank",
      "Can always equip Guns. Can always use Gun, Makina, and",
      "Artificial skills, dealing +75% damage but have 150% SP cost.",
      "Starts battles with 200% SP (Excess SP cannot be restored",
      "once used). Takes halved damage from Physical element",
      "attacks.",
    ],
    459 => ["Singing Stone Statue",
      "Innate Horny+Seduction Strike 30%. Can always equip Harps.",
      "Can always use Singing skills and automatically guards",
      "afterwards. Singing skills have a 30% chance to inflict",
      "Horny and Seduction. Targeted 25% as often by enemies.",
    ],
    460 => ["Scientist Angel",
      "Can always equip Grimoires. Can always use Magic Science,",
      "Alchemy, and Grimoire skills, dealing +30% damage. Magic",
      "Science skills have 50% SP cost. 50% chance to not consume",
      "materials or pages when using Alchemy or Grimoire skills.",
      "Absorbs Fire, Ice, and Lightning damage.",
    ],
    461 => ["Medic Plant",
      "Takes 25% less damage from physical and magical attacks.",
      "Can always equip Scalpels. Can always use Medicine skills,",
      "dealing +30% damage, have persistence, and imbue allies with",
      "All Stats Up.",
    ],
    462 => ["Drain-specialized Roid",
      "Max HP +30%. Innate Trance Strike 30%. Normal attack is",
      "replaced with Drain Strike. Can always use Makina and",
      "Artificial skills, dealing +30% damage. Makina skills deal",
      "+150% damage to Tranced foes. Artificial skills have a 30%",
      "chance to inflict Trance and restore own HP by 25% of damage",
      "dealt.",
    ],
    463 => ["Handjob Machine",
      "Can always equip Sex Toys. Can always use Sexcraft skills.",
      "Pleasure skills that make use of hands deal +50% damage",
      "and execute two additional times.",
    ],
    464 => ["Ultimate Angel Maid", #NOTE: Also has Holy Skill use, which isn't mentioned in original description
      "Can always equip Plates. Can always use Holy and Service",
      "skills, dealing +50% damage. 50% of Dexterity is added to",
      "Holy skill power. Chains Service skills into Holy skills.",
      "Starts battles with 130% SP (Excess SP cannot be restored",
      "once used).",
    ],
    465 => ["Supreme Angel Cook",
      "Can always equip Kitchen Knives. Can always use Cooking",
      "skills, dealing +50% damage and have persistence. 50% chance",
      "to not consume ingredients when using Cooking skills. Cooks",
      "a random dish at the end of turn (This does not consume",
      "ingredients).",
    ],
    466 => ["Angelic Dominion's Mascot",
      "Can always use Unarmed, White Magic, Black Magic, and Holy",
      "skills, dealing +30% damage. Unarmed skills can use Willpower",
      "in place of other stats. Automatically defends after using",
      "Holy skills. Chains Unarmed, White Magic, and Black Magic",
      "into Holy skills. Flashes a Sparkle☆ pose at the start of",
      "battle.",
    ],
    467 => ["Machine Snake",
      "Can always equip Guns. Can always use Gun, Makina, and Snake",
      "skills, dealing +30% damage. Gun and Makina skills can use",
      "Defense in place of Dexterity, and deal +100% damage to bound",
      "foes. Chains Snake skills into Gun or Makina skills.",
    ],
    468 => ["Angel of Nightly Visits",
      "Innate Bind Strike 30%. Can always equip Sex Toys. Can always",
      "use Sexcraft skills, dealing +30% damage (+100% to Bound",
      "foes) and have a 30% chancec to inflict Bind. Chains Sexcraft",
      "skills into Sexcraft skills. Immune to Pleasure damage and",
      "takes 75% Nightmare damage.",
    ],
    469 => ["Experimental Invader",
      "Innate Digestion Strike 30%. Can always equip Scalpels.",
      "Can always use Mercantile and Medicine skills.",
      "Medicine skills deal +30% damage (+150% to partially",
      "digested foes) and have a 30% chance to inflict",
      "Digestion. Deals +150% damage with species slayer and +100%",
      "damage with conditional effects. 50% chance to prey upon all",
      "bound or partially digested foes at the end of turn.",
    ],
    470 => ["Flying Cage",
      "Innate Bind Strike 30%. Can always use Spear, Wing, and",
      "Tentacle skills. Spear and Wing skills deal +30% damage.",
      "Wing skills have a 30% chance to inflict Bind. Spear skills",
      "deal +150% damage to Bound foes. Binds last two turns longer.",
      "Counters all attacks with Infinity Binding. Takes 25% damage",
      "from physical element attacks.",
    ],
    471 => ["Mushroom Artisan",
      "Can always equip Kitchen Knives. Can always use Dancing,",
      "Singing, and Cooking skills, dealing +30% damage with 66% SP",
      "cost. 30% chance to not consume ingredients when using",
      "Cooking skills. Chains Dancing or Singing skills into Cooking",
      "skills.",
    ],
    472 => ["Multiplying Matango",
      "Maximum HP +100%. 33% chance to counter with Division.",
      "Plant skills deal +30% damage. 50% chance of gaining an",
      "extra action; 35% chance of gaining an extra action. (These",
      "chances are rolled separately and can yield two extra",
      "actions)",
    ],
    473 => ["Grappler Caterpillar",
      "Can always equip Fists. Can always use Unarmed and Insect",
      "skills, dealing +30% damage, have 66% SP cost and",
      "persistence. Unarmed skills can use Defense in place of other",
      "stats. Automatically guards after using Unarmed skills.",
    ],
    474 => ["Licking Rose",
      "Innate Slimed Strike 50%. Can always use Demon Arts and Plant",
      "skills. Skills using tongues deal +50% damage with 50% SP",
      "cost. Plant skills deal +150% damage to Slimed foes. Chains",
      "Demon Arts skills into Plant skills.",
    ],
    475 => ["Rampaging Carnivorous Plant",
      "Innate Digestion Strike 30%. Can always equip Flails.",
      "Can always use Flail and Plant skills, dealing +30% damage",
      "(+100% to partially digested foes). 50% of Dexterity is",
      "added to Flail skill power. Chains Plant skills into Flail",
      "skills. 50% chance of devouring all Slimed or partially",
      "digested foes at the end of turn.",
    ],
    476 => ["Yomotsu Shikome",
      "Innate Bind Strike 30%. Skills using hair deal +50% damage",
      "with 50% SP cost, and execute two additional times. Taoism",
      "skills deal +100% damage to Bound foes. Takes halved damage",
      "from Dark attacks and 75% damage from Demise attacks.",
    ],
    477 => ["Noble Queen's Corpse",
      "Magic +30%. Can always equip Rods. Can always use Black",
      "Magic, Ruling, and Corpse skills, dealing +30% damage. Black",
      "Magic and Ruling skills deal +150% damage to Poisoned and",
      "Zombified foes. Chains Corpse skills into Black Magic or",
      "Ruling skills.",
    ],
    478 => ["Angel Corpse",
      "Can always use Holy and Corpse skills, dealing +30% damage",
      "(+150% to Poisoned and Zombified foes). Corpse skills can use",
      "Willpower in place of other stats. Chains Corpse skills into",
      "Holy skills. Takes halved damage from Holy attacks and 75%",
      "damage from Eternal attacks.",
    ],
    479 => ["Rampaging Dragon Zombie", #NOTE: Original description only mentions Breath-Axe chain, but is actually Axe-Corpse-Breath chain.
      "Normal attack hits an additional time. Can always equip Axes.",
      "Can always use Axe, Corpse, and Breath skills, dealing +30%",
      "damage. Axe skills deal +150% damage to Burned or Frozen",
      "foes. Chains Axe skills into Corpse then Breath skills.",
    ],
    480 => ["Terrifying Alien Lifeform.",
      "Max HP and Attack +30%.  Innate Digestion Strike 30%. Can",
      "always use Giant skills, dealing +50% damage (+150% to",
      "partially digsted foes) with 66% SP cost. Takes halved",
      "damage from Galactic attacks.",
    ],
    481 => ["Succubus Angel's Ascension",
      "Can always equip Whips and Sex Toys. Can always use Whip,",
      "Holy, Sexcraft, and Psychic skills, dealing +30% damage.",
      "Whip and Holy skills deal +150% damage to foes suffering from",
      "pleasure ailments. Chains Sexcraft or Psychic skills into",
      "Whip then Holy skills. Immune to Pleasure damage and takes",
      "halved Nightmare damage.",
    ],
    482 => ["Egg of Reincarnation",
      "Regenerates 30% HP/8% MP/30% SP each turn. Takes 75% damage",
      "from physical and magical attacks. Can always use Throwing,",
      "Time Magic, and Holy skills. Time Magic and Holy skills deal",
      "+30% damage. Holy skills deal +150% damage to Slowed/Stopped",
      "foes.",
    ],
    483 => ["Giant Face Rider",
      "Can always equip Whips. Can always use Whip and Giant skills,",
      "dealing +50% damage. Chains Whip skills into Giant skills.",
      "Chained skills deal +50%, and their MP/SP cost is further",
      "halved.",
    ],
    484 => ["Cyborg Knight",
      "Can always equip Spears, Heavy Spears, and Heavy Armor.",
      "Can always use Spear skills, dealing +30% damage, have",
      "persistence, and execute an additional time, but have 133%",
      "SP cost.",
    ],
    485 => ["Cyborg Ninja",
      "Can always equip Ninja Swords. Can always use Ninjutsu",
      "skills, dealing +30% damage, have increased priority, and",
      "execute an additional time, but have 133% SP cost.",
    ],
    486 => ["Angel Sage",
      "Can always equip Staves and Rods. Can always use White Magic,",
      "Black Magic, and Summoning skills, dealing +30% damage, and",
      "another +25% damage when used at full MP. Chains White Magic",
      "skills into Black Magic then Summoning skills.",
    ],
    487 => ["Slime Angel",
      "Can always equip Kitchen Knives and Plates. Can always use",
      "Mercantile, Talk, Cooking, Medicine, Service, and Slime",
      "skills. Talk, Cooking, Medicine, Service, and Slime skills",
      "deal +30% damage. Talk, Cooking, Medicine and Service skills",
      "deal +150% damage to foes affected by Slimed or Stigmata.",
      "Slime skills inflict Stigmata 30% of the time. Chains Slime",
      "skills into Mercantile, Talk, Cooking, Medicine, or Service",
      "skills.",
    ],
    488 => ["Blade-Bodied Angel", #NOTE: Original text implies the sword/rapier booster was nerfed in 3.03, but is intact from 3.02
      "Can always equip Swords, Knight Swords, Great Swords, and",
      "Rapiers. Can always use Sword and Rapier skills, dealing",
      "+50% damage and have persistence. Chains Rapier skills into",
      "Sword then Sword skills. Starts battles with Attack Up",
      "active.",
    ],
    489 => ["Holy Guardian Angel",
      "Can always equip Fists. Can always use Throwing, Unarmed,",
      "White Magic, and Holy skills. Unarmed, White Magic, and Holy",
      "skills deal +30% damage. Unarmed and Holy skills deal 150%",
      "damage to enemies afflicted with Stigmata. Chains Throwing",
      "or White Magic skills into Unarmed then Holy skills. Takes",
      "25% Holy damage and 75% Eternal damage.",
    ],
    490 => ["Angel of Nihility",
      "Can always use Holy and Dark skills, dealing +50% damage.",
      "Chains Holy skills into Dark skills. Dark skills can use",
      "Willpower in place of other stats. Immune to Holy and Dark",
      "damage and takes 75% Eternal and Demise damage.",
    ],
    491 => ["Drifting Ice Angel",
      "Innate Nano/Freeze strike 30%. Can always equip Bows.",
      "Can always use Bow and Holy skills, dealing +30% damage",
      "(+150% to Frozen foes). Holy skills have a 30% chance to",
      "inflict Freeze. Chains Holy skills into Bow skills. Immune to",
      "Nano damage. 33% chance to prey upon all bound or partially",
      "digested foes at the end of turn.",
    ],
    492 => ["Timekeeper Angel",
      "Deal +50% Galactic damage. Holy attacks inflict Galactic",
      "damage as well. Can always use Time Magic and Holy skills,",
      "dealing +50% damage (+150% to foes afflicted with Slow, Stop,",
      "or pleasure ailments), and have +15% status infliction rate.",
      "Chains Time Magic skills into Holy skills. Immune to Galactic",
      "damage.",
    ],
    493 => ["Cube Angel",
      "Deal +50% Galactic damage. Physical and Holy attacks inflict",
      "Galactic damage as well. Can always equip Bows. Can always",
      "use Bow, Summoning, Holy, and Slime skills, Bow, Summoning,",
      "and Holy skills deal +30% damage, have persistence, and",
      "automatically guards afterwards. Takes only 25% damage while",
      "guarding. Bow and Summoning skills can use Willpower in place",
      "of other stats. Chains Holy skills into Bow then Summoning",
      "skills. Immune to Galactic damage.",
    ],
    494 => ["Tentacle Cluster Angel",
      "Max HP +30%. Innate Bind Strike 30%. Can always use Holy and",
      "Tentacle skills, dealing +50% damage (+150% to Bound foes).",
      "Tentacle skills execute two additional times and have a 30%",
      "chance to inflict Bind. Tentacle skills can use Willpower in",
      "place of other stats. Chains Tentacle skills into Holy",
      "skills.",
    ],
    496 => ["Artificial Wind Spirit",
      "Deal +50% Hadron damage. All attacks inflict Hadron damage",
      "and pierce resistance to it. Evasion/Magic Evasion/Auto-Hit",
      "Evasion +15%. Can always use Thievery and Nature skills,",
      "dealing +30% damage. Chains Nature skills into Thievery",
      "skills. Gain Devastating Gale status (+300% Accuracy, 100%",
      "Evasion/50% Magic Evasion) while below 20% HP. Reflects",
      "Hadron damage. +15% to all stats for each Artificial Spirit",
      "in the party.",
    ],
    497 => ["Artificial Earth Spirit", #NOTE: Original description mentions counter rate+normal attack booster, but is absent in her actor data
      "Deal +50% Terra damage. All attacks inflict Terra damage",
      "and pierce resistance to it. Can always equip Heavy Armor.",
      "Can always use Club, Throwing, and Nature skills, dealing",
      "+30% damage. Chains Throwing or Nature skills into Club",
      "skills. Gain Wild Lands status (+100% Defense/Critical Rate/",
      "Magical Critical Rate) while below 20% HP. Reflects Terra",
      "damage, immune to Physical element damage, and takes halved",
      "Carnage damage. +15% to all stats for each Artificial Spirit",
      "in the party.",
    ],
    498 => ["Artificial Water Spirit",
      "Deal +50% Nano damage. All attacks inflict Nano damage and",
      "pierce resistance to it. Can always use White Magic, Slime,",
      "and Nature skills. Slime and Nature skills deal +30% damage,",
      "Slime skills can use Willpower in place of other stats.",
      "Chains White Magic or Nature skills into Slime skills.",
      "Reflects Nano damage. Immune to Slimed. Takes 75% damage from",
      "all types of attacks. +15% to all stats for each Artificial",
      "Spirit in the party.",
    ],
    499 => ["Artificial Fire Spirit",
      "Deal +50% Nuclear damage. All attacks inflict Nuclear damage",
      "and pierce resistance to it. Innate Burn Strike 30%. +10%",
      "Critical Rate/+50% Critical Damage. Can always use Unarmed,",
      "Nature, and Breath skills. Unarmed and Nature skills deal",
      "+30% damage. Unarmed skills deal +100% damage to Burning",
      "foes. Chains Nature skills into Unarmed skills, Reflects",
      "Nuclear damage. Immune to Burn. +15% to all stats for each",
      "Artificial Spirit in the party.",
    ],
    500 => ["Tyrannical Next Doll",
      "+10% Critical Rate/+50% Critical Damage. Can always equip",
      "Fists. Can always use Unarmed skills, dealing +100% damage",
      "and executing an additional time, but have doubled SP cost.",
    ],
    501 => ["Soaring Next Doll",
      "Immune to Nightmare damage. Can always use Wing skills,",
      "dealing +100% damage and executing an additional time, but",
      "have doubled SP cost.",
    ],
    502 => ["Armored Next Doll",
      "Counters with Vibration Armor. Can always use Makina skills,",
      "dealing +100% damage and executing an additional time, but",
      "have doubled SP cost.",
    ],
    503 => ["Magisonant Next Doll",
      "Magic Critical Rate +15%/Critical Damage +50%. Can always use",
      "Taoism skills, dealing +100% damage and executing an",
      "additional, but have doubled MP cost.",
    ],
    504 => ["Infestive Next Doll",
      "Evasion/Magic Evasion/Auto-Hit Evasion +15%. Can always use",
      "Insect skills, dealing +100% damage and executing an",
      "additional time, but have doubled SP cost.",
    ],
    505 => ["Clone Hero",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword and Heroism skills, dealing +30% damage, gaining +1.5%",
      "damage for each % of missing HP. Chains Sword skills into",
      "Heroism skills.",
    ],
    506 => ["Clone Holly",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword and Heroism skills, dealing +30% damage with 50% SP",
      "cost, gaining +1% damage for each % of missing HP, and have",
      "increased priority. Chains Sword skills into Heroism skills.",
    ],
    507 => ["Clone Rinoa", #NOTE: Original description states increased critical rate, but has higher evasion rate instead.
      "+15% Evasion Rate, +50% Critical Damage. Can always equip",
      "Swords and Knight Swords. Can always use Sword and Heroism",
      "skills, dealing +50% damage and gaining +1% damage for each",
      "% of missing HP. Chains Sword skills into Heroism skills.",
    ],
    508 => ["Clone Heine",
      "Can always equip Axes and Clubs. Can always use Axe, Club,",
      "and Heroism skills, dealing +75% damage and have persistence,",
      "but have 133% SP cost. Axe and Heroism skills gain +1% damage",
      "for each % of missing HP. Chains Axe skills into Club then",
      "Heroism skills.",
    ],
    509 => ["Clone Kyrie",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear, Holy, and Heroism skills, dealing +50% damage.",
      "Spear and Heroism skills gain +1% damage for each % of",
      "missing HP. Holy skills have an additional 50% chance to",
      "inflict Stigmata. Chains Holy skills into Spear then Heroism",
      "skills.",
    ],
    510 => ["Guardian of the Law",
      "Deal +75% Eternal/Nightmare damage. Holy attacks inflict",
      "Eternal damage. Can always equip Staves. Can always use White",
      "Magic, Black Magic, Holy, and Sexcraft skills, dealing +75%",
      "damage, and have a 25% chance to inflict Stigmata. Black",
      "Magic and Sexcraft skills can use Willpower in place of other",
      "stats. Chains White Magic or Black Magic into Holy then",
      "Sexcraft skills.",
    ],
    511 => ["Holy Lily of Compassion",
      "Deal +75% Eternal damage. Holy attacks inflict Eternal",
      "damage. Can always equip Whips. Can always use Whip, White",
      "Magic, Holy, and Plant skills, dealing +75% damage. White",
      "Magic, Holy, and Plant skills can use Dexterity in place of",
      "other stats. Chains Plant skills into Holy then Whip skills.",
    ],
    512 => ["Dominion's Decisive Weapon",
      "Deal +75% Nuclear damage. All attacks inflict Nuclear damage.",
      "Can always equip Fists. Can always use Unarmed, Holy, Makina,",
      "and Artificial skills, dealing +75% damage, have 50% SP cost,",
      "and can use Attack in place of other stats. Chains Unarmed",
      "skills into Holy then Makina or Artificial skills. Chained",
      "skills deal +50% damage. Deals +30% damage to Bosses.",
    ],
    513 => ["Warden of Death",
      "Deal +75% Nuclear damage. Fire attacks inflict Nuclear",
      "damage. Can always equip Scythes. Can always use Scythe,",
      "Holy, Demon Arts, and Corpse skills, dealing +75% damage.",
      "Holy and Corpse skills use Magic in place of other stats.",
      "Scythe skills chain into Holy then Corpse skills.",
      "If incapacitated, automatically revives at the end of turn.",
    ],
    514 => ["Nuclear-Powered Angels Elder Sister",
      "Deal +75% Eternal damage. Holy attacks inflict Eternal",
      "damage. Can always equip Bows. Can always use Bow, Holy, and",
      "Artificial skills, dealing +75% damage. Bow and Holy skills",
      "use Dexterity in place of other stats. Chains Bow skills into",
      "Artificial then Holy skills. +15% to all stats if Sandalphone",
      "is in the party.",
    ],
    515 => ["Nuclear-Powered Angels Younger Sister",
      "Deal +75% Eternal damage. Holy attacks inflict Eternal",
      "damage. Can always equip Guns. Can always use Gun, Holy, and",
      "Artificial skills, dealing +75% damage. Holy skills use",
      "use Dexterity in place of other stats. Chains Gun skills into",
      "Artificial then Holy skills. +15% to all stats if Metatronne",
      "is in the party.",
    ],
    516 => ["Slime Angel Protecting the Goddess",
      "Can always equip Boomerangs. Can always use Throwing, Holy,",
      "and Slime skills, dealing +50% damage. Chains Throwing skills",
      "into Slime skills then Holy skills. +30% to all stats if",
      "Ilias is in the party.",
    ],
    517 => ["Dog Angel Protecting the Goddess",
      "Auto-Hit Evasion +30%. Can always equip Fists. Can always use",
      "Holy and Beast skills, dealing +50% damage, have increased",
      "priority, and execute an additional time. Chains Beast skills",
      "into Holy skills. +30% to all stats if Ilias is in the party.",
    ],
    520 => ["Don Father",
      "Can always equip Guns and use Gun skills, dealing +30%",
      "damage and gaining +1% damage for every % of missing HP.",
      "+50% Evasion and Magic Evasion for 4 turns when falling",
      "below 20% HP.",
    ],
    521 => ["Leader of Ilias Kreuz",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword skills, dealing +30% damage and gaining +1% damage for",
      "every % of missing HP. Gain +50% Evasion/Magic Evasion/Auto-",
      "Hit for 4 turns when falling below 20% HP.",
    ],
    522 => ["Skilled Magical Swordsman",
      "Can always equip Swords and Magic Swords. Can always use",
      "Sword, Spellblade, and Black Magic. Sword skills and Black",
      "Magic deal +30% damage and impart Attack Up and Magic Up",
      "to self.",
    ],
    523 => ["Monster Lord Slayer",
      "Can always equip Magic Swords. Can always use Sword,",
      "Spellblade, Makina, and Heroism skills. Sword, Makina, and",
      "Heroism skills deal +50% damage. Deals +100% damage to and",
      "take 50% less damage from Apoptosis and Monster Lords.",
    ],
    525 => ["Club Girl",
      "Can always equip Clubs and Staves, inflicting +30% damage",
      "with normal attacks. Can always use Club skills and White",
      "Magic, dealing +30% damage and healing +30% HP.",
      "Club skills deal +1% damage for every % of missing HP.",
      "Club skills and White Magic use the highest of Attack or",
      "Willpower.",
    ],
    526 => ["Mighty King of the Burning Sands",
      "Can always use Sword and Ruling skills, dealing +50% damage",
      "with 50% SP cost. Single-hit skills deal +50% damage. Chains",
      "Ruling skills into Sword skills. 30% chance to use Focused",
      "Spirit at the start of turn.",
    ],
    527 => ["Our Hero SabasaMan",
      "Can always use Unarmed and Ruling skills. Unarmed, Justice,",
      "and Ruling skills deal +50% damage with 50% SP cost.",
      "Multi-hit skills deal 20% more damage with each consecutive",
      "hit. Chains Ruling skills into Justice skills. 30% chance to",
      "use Focused Spirit at the start of turn.",
    ],
    528 => ["Queen of the Sky Pirates",
      "Can always equip Heavy Armor. Can always use Piracy and",
      "Ruling skills, dealing +50% damage with 50% SP cost.",
      "Multi-hit skills deal 20% more damage with each consecutive",
      "hit. Chains Ruling skills into Piracy skills. 30% chance to",
      "use Focused Spirit at the start of turn.",
    ],
    529 => ["Tomboy Princess Swordsman",
      "Can always equip Swords and Knight Swords.",
      "Can always use Sword and Ruling skills, dealing +30% damage,",
      "healing +30% HP, and have a 50% chance of imbuing Attack Up",
      "to self.",
    ],
    530 => ["Fallen Princess",
      "Deal +30% Pleasure damage. Can always use Ruling and",
      "Sexcraft skills, dealing +30% damage and have a 50% chance",
      "of imbuing Dexterity Up. Ruling skills can use Dexterity in",
      "place of Attack.",
    ],
    531 => ["Mecha Pope",
      "Can always equip Guns. Can always use Gun, Holy, Makina,",
      "and Artificial skills. Can use some Makina skills without",
      "their required key items. Gun and Makina skills imbue",
      "Defense Up to self.",
    ],
    533 => ["Whip Queen",
      "Can always equip Whips. Can always use Whip and Ruling",
      "skills, dealing +30% damage. Ruling skills can use Dexterity",
      "in place of other stats. 20% chance of imbuing All Stats Up",
      "when using Ruling and Whip skills."
    ],
    534 => ["Top Gun Queen", #NOTE: Original description mentions increased Agility and Evasion, but is not present in actor data
      "+15% Evasion Rate. Can always equip Guns. Can always use Gun,",
      "Makina, and Artificial skills, dealing +30% damage. Chains",
      "Gun skills into Makina then Artificial skills. Chained skill",
      "SP cost is further halved.",
    ],
    535 => ["Return of the Magic King",
      "Can always use Black Magic, Time Magic, Magic Science, and",
      "Ruling skills, dealing +30% damage. Regenerates 10% HP and",
      "2% MP every turn. Once per fight, revive at 100% HP when",
      "defeated.",
    ],
    536 => ["Legendary Pirate Queen",
      "Can always equip any armor except Heavy equipment.",
      "Can always use Piracy and Corpse skills, dealing +30% damage.",
      "Immune to Water damage.",
    ],
    538 => ["Legendary Hero",
      "Can always equip Swords and Knight Swords.",
      "Can always use Sword and Heroism skills.",
      "Heroism skills deal +50% damage but have 133% SP cost.",
    ],
    539 => ["Hero of the Unified Trinity",
      "Physical attacks inflict Carnage damage. Can always equip",
      "Swords and Knight Swords. Can always use Sword and Heroism",
      "skills. Heroism skills deal +75% damage and execute two",
      "additional times.",
    ],
    540 => ["Unfortunate Lamia",
      "Targeted 25% as often by enemies. Can always use Talk and",
      "Snake skills. Talk skills have +30% status infliction rate.",
    ],
    541 => ["Unfortunate Harpy",
      "+30% Magic/Magic Evasion. Targeted 25% as often by enemies.",
      "Can always use Wing skills.",
    ],
    542 => ["Unfortunate Mermaid",
      "Targeted 25% as often by enemies. Can always use Mercantile",
      "and Ocean skills. Mercantile skills have 50% gold cost.",
      "3% chance to die instead of following orders. (This trait is",
      "a removable ability)",
    ],
    543 => ["Unfortunate Nekomata",
      "Targeted 25% as often by enemies. Can always use Beast",
      "skills, dealing +30% damage. 20% chance of dividing at the",
      "end of turn.",
    ],
    544 => ["Disciple of Pleasure",
      "Innate Pleasure Strike and Horny/Trance Strike 15%.",
      "Can always use Sexcraft skills. Take 50% reduced Pleasure",
      "damage.",
    ],
    545 => ["Civilian",
      "Targeted 50% as often by enemies. +20% to all stats while in",
      "towns. +50% Evasion rate while below 20% HP.",
    ],
    546 => ["Resentment of the Streets",
      "Targeted 50% as often by enemies.",
      "Gain gold equal to damage taken.",
    ],
    547 => ["Dahlia of Criminal Underworld",
      "Can always equip Guns. Can always use Gun and Mercantile",
      "skills. Gun skills deal +30% damage.",
    ],
    548 => ["Lucky Bunny",
      "Targeted 25% as often by enemies.",
      "150% Gold Drop and Recruit Rate.",
    ],
    549 => ["Expert Thief",
      "Can always use Thievery skills.",
      "+50% to item drop and steal rate.",
    ],
    550 => ["Chi-Focusing Technique",
      "Can always use Unarmed skills.",
      "+50% Critical/Evasion rate while below 20% HP.",
    ],
    551 => ["Legendary Maid's Apprentice",
      "Can always use Service skills, dealing +30% damage.",
      "Gain 200% Job XP when winning a battle while below 20% HP.",
    ],
    552 => ["Gentle Elf",
      "Targeted 50% as often by enemies. Can always use Bow skills,",
      "dealing +30% damage.",
    ],
    553 => ["Apprentice Scholar",
      "Targeted 50% as often by enemies. Can always use Magic",
      "Science skills, dealing +15% damage.",
    ],
    554 => ["Lewd Nurse",
      "Can always use Medicine and Sexcraft skills, dealing +15%",
      "damage and healing +15% more HP.",
    ],
    555 => ["Gentle Soul",
      "Targeted 50% as often by enemies. Gain MP equal to 10% of",
      "damage taken.",
    ],
    556 => ["Virtuous Priestess",
      "Can always use White Magic with 66% MP cost.",
    ],
    557 => ["Justice Kaiser",
      "Targeted 200% as often by enemies. 50% chance to use",
      "Transform at the start of battle.",
    ],
    558 => ["Roadside Fortune Teller",
      "Targeted 50% as often by enemies. Can always use Oracle",
      "skills. Uses Tarot of Fate at the end of turn.",
    ],
    559 => ["Master Assassin",
      "Death Strike 20%. Targeted 50% as often by enemies.",
      "Can always use Ninjutsu skills.",
    ],
    560 => ["Enchanting Dancer",
      "Can always use Dancing skills. 50% chance to use Sexy Dance",
      "at the start of battle.",
    ],
    561 => ["Pettanko Witch",
      "Can always use Black Magic. Regenerate 4% of max MP each",
      "turn while below 20% HP.",
    ],
    562 => ["Mighty Blacksmith",
      "Can always use Club skills. Regenerate 20% of max SP each",
      "turn while below 20% HP. Normal attacks attempt to steal",
      "materials.",
    ],
    563 => ["Temple Soldier",
      "Gain Defense Up and Willpower Up while below 20% HP.",
    ],
    564 => ["Lightning of San Ilia",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear skills. Spear skills execute an additional time while",
      "below 20% HP.",
    ],
    565 => ["Hammer of Sabasa",
      "Can always equip Clubs and use Club skills.",
      "25% chance to use Rock Drop at the start of battle.",
    ],
    566 => ["Red Sleeveless",
      "+30% Evasion/+20% Accuracy. 20% chance to play around",
      "instead of following orders.",
    ],
    567 => ["Gentleman Pervert",
      "Normal attacks attempt to steal panties. 50% chance to steal",
      "panties at the start of battle. 25% chance to attempt to",
      "steal panties at the end of turn.",
    ],
    569 => ["Stardust Crusaders",
      "As all the stardust comes together",
      "It has been summoned from one hundred years of slumbering",
      "These men are bravely facing onwards",
      "They race against the sands of time along their journey",
    ],
    570 => ["Lively Swordsman",
      "Can always equip Swords and Knight Swords.",
      "Can always use Sword skills with 50% SP cost.",
    ],
    571 => ["Dancing Sailor",
      "Can always equip Fans. Can always use Piracy and Dancing",
      "skills with 66% SP cost.",
    ],
    572 => ["Story Loving Villager",
      "+15% Evasion rate. Targeted 50% as often by enemies.",
      "Can always use Talk skills with 50% SP cost.",
    ],
    573 => ["Reckless Warrior",
      "+10% Critical rate. Can always equip Clubs and Axes and use",
      "Club and Axe skills, dealing +30% damage.",
    ],
    574 => ["Aloof Miko",
      "Targeted 50% as often by enemies. Can always use White Magic",
      "and Dancing skills. Dancing skills have +15% status",
      "infliction rate.",
    ],
    575 => ["Blade on the Brink of Death",
      "Can always equip Katanas and use Katana skills, executing",
      "an additional time while below 20% HP.",
    ],
    576 => ["Magical Freshman",
      "Can always equip Grimoires. Can always use Magic Science and",
      "Grimoire skills, dealing +30% damage.",
    ],
    577 => ["Magical☆Mari-chan",
      "Can always equip Rods. Can always use Black Magic.",
      "66% chance of Transforming at the start of battle.",
    ],
    578 => ["Clanking Soldier",
      "Can always equip Swords, Knight Swords, and Heavy Armor.",
      "Takes only 25% damage when guarding.",
    ],
    579 => ["Spirited Bandit",
      "Can always equip Axes and use Axe skills, dealing +50%",
      "damage, but have 133% SP cost.",
    ],
    580 => ["Game of Pleasure",
      "Can always equip Sex Toys. Can always use Sexcraft skills,",
      "dealing +50% damage but have 133% SP cost.",
    ],
    581 => ["Leisurely Noble",
      "Can always equip Rapiers. Can always use Rapier and Sexcraft",
      "skills, dealing +30% damage.",
    ],
    582 => ["Item Master",
      "Can always equip Abacus. Can always use Mercantile and",
      "EX-Item skills. Gain gold equal to damage taken.",
    ],
    583 => ["Raider Pirate",
      "Can always equip Swords and Knight Swords. Can always use",
      "Thievery and Piracy skills. Piracy skills deal +30% damage.",
    ],
    584 => ["Bullseye Pirate",
      "Can always equip Guns. Can always use Gun and Piracy skills,",
      "dealing +30% damage.",
    ],
    585 => ["Drunkard Captain",
      "Can always use Piracy skills, dealing +30% damage.",
      "10% chance to use Drunken Boxing instead of following",
      "orders. (This trait is a removable ability)",
    ],
    586 => ["Assassin Prostitute",
      "Innate Death Strike 20%. Can always equip Ninja Swords.",
      "Can always use Ninjutsu, dealing +15% damage.",
    ],
    587 => ["Hunter Kunoichi",
      "Can always use Bow and Ninjutsu skills, dealing +30% damage.",
    ],
    588 => ["Water Specter",
      "Physical attacks inflict Nano damage. Can always equip Ninja",
      "Swords. Can always use Ninjutsu and Sexcraft skills, dealing",
      "+30% damage.",
    ],
    589 => ["Destitute Battle Fucker",
      "Can always use Thievery and Sexcraft skills, dealing +30%",
      "damage. Attempts to steal items when using Sexcraft skills.",
    ],
    590 => ["Healing Maid",
      "Can always equips Staves and Plates. Can always use White",
      "Magic and Service skills, dealing +30% damage.",
    ],
    591 => ["Dark Gambler",
      "Can always use Gun and Oracle skills, dealing +30% damage.",
    ],
    592 => ["Petite Fucker",
      "+15% Evasion/Magic Evasion Rate. Can always use Sexcraft",
      "skills, dealing +30% damage.",
    ],
    593 => ["Divine Blade Miko",
      "Can always equip Katanas and Fans. Can always use Katana,",
      "Fan, and Dancing skills, dealing +30% damage.",
    ],
    594 => ["Angelic Dominion's Strongest Battle Fucker",
      "Deal +30% Pleasure damage. Can always equip Plates and Sex",
      "Toys. Can always use Service and Sexcraft skills, dealing",
      "+30% damage. Chains Service skills into Sexcraft skills.",
    ],
    595 => ["Wind Specter",
      "Innate Hadron Strike. Can always equip Daggers and Ninja",
      "Swords. Can always use Dagger and Ninjutsu skills, dealing",
      "+30% damage.",
    ],
    596 => ["Diner Poster Girl",
      "Can always use Cooking and Service skills, dealing +30%",
      "damage. Cooks a random dish at the end of turn.",
    ],
    597 => ["Prophetic Miko",
      "Can always use Taoism and Talk skills, dealing +30% damage.",
      "Chains Taoism skills into Talk skills.",
    ],
    598 => ["Little Assassin Girl",
      "Innate Death Strike 30%. Can always use Ninjutsu skills,",
      "dealing +30% damage.",
    ],
    599 => ["Dairy Battle Fucker",
      "Can always use Sexcraft skills, dealing +30% damage.",
      "Attempts to milk an enemy at the end of turn.",
    ],
    600 => ["Model Citizen",
      "Can always use Medicine and Service skills, dealing +30%",
      "damage. Service skills chain into Medicine skills.",
    ],
    601 => ["Prostitute of the Peach Blossom Spring",
      "Deal +30% Pleasure damage. Can always use Sexcraft skills,",
      "dealing +30% damage with 50% SP cost.",
    ],
    602 => ["Heavenly Sakaki Miko",
      "Deal +30% Pleasure damage. Can always use Dancing, Singing,",
      "and Sexcraft skills, dealing +30% damage. Chains Dancing or",
      "Singing skills into Sexcraft skills.",
    ],
    603 => ["High Priestess of Iliasville",
      "Can always use White Magic, dealing +30% damage. Can use the",
      "Book of Job Change skill to allow changing jobs anywhere.",
    ],
    604 => ["Hero of the North",
      "Innate Ice Strike. Deal +30% Ice damage. Can always equip",
      "Swords and Knight Swords. Can always use Sword, Spellblade,",
      "and Heroism skills. Sword and Heroism skills deal +30%",
      "damage.",
    ],
    605 => ["Queen with Heros Blood",
      "Can always use Sword, Ruling, and Heroism skills, dealing",
      "+50% damage.",
    ],
    606 => ["Legendary Phantom Wolf",
      "Can always equip Fists. Can always use Unarmed and Beast",
      "skills, dealing +30% damage with 66% SP cost. Beast skills",
      "execute an additional time.",
    ],
    607 => ["Monster Realm Imp",
      "+30% Auto-Hit Evasion. Can always equip Daggers and",
      "Boomerangs. Attempts to steal items when using normal",
      "attacks, Dagger skills, and Throwing skills. Can always use",
      "Dagger, Throwing, Black Magic, and Thievery skills. Dagger,",
      "Throwing, and Thievery skills deal +30% damage. 200% Steal",
      "Success and Item Drop Rate.",
    ],
    608 => ["Bandit Orc",
      "Can always equip Clubs and Heavy Armor. Can always use Club",
      "skills, dealing +50% damage. Deals +25% damage with",
      "single-hit skills. Attempts to steal items when using normal",
      "attacks and Club skills.",
    ],
    609 => ["Flight Succubus",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear and Sexcraft skills, dealing +30% damage with 66% SP",
      "cost. Sexcraft skills use Agility in place of other stats.",
      "Spear skills chain into Sexcraft skills.",
    ],
    610 => ["Sage Succubus",
      "Can always equip Staves and Rods. Can always use White Magic,",
      "Black Magic, and Sexcraft skills, dealing +30% damage with",
      "66% MP/SP cost. Chains White Magic or Black Magic skills into",
      "Sexcraft skills.",
    ],
    611 => ["Successful Poor Succubus",
      "Can always use Thievery, Mercantile, Oracle, Dancing,",
      "Singing, Talk, Cooking, Medicine, Service, Ruling, and",
      "Sexcraft skills, dealing +50% damage, but may use certain",
      "Oracle skills instead of following orders. (This trait is a",
      "removable ability)",
    ],
    612 => ["Half-Beast Demon Summoner",
      "Regenerates 4% of Max MP every turn. Can always equip Rods.",
      "Can always use Black Magic, Summoning, Demon Arts, and",
      "Sorcery skills, dealing +30% damage with 66% MP cost.",
      "Deals +33% damage with Magic-type and Sorcery skills when at",
      "full MP.",
    ],
    613 => ["Beast Fencer",
      "Can always equip Rapiers. Can always use Rapier and Beast",
      "skills, dealing +30% damage with 66% SP cost. Beast skills",
      "deal +150% damage to Burned foes. Chains Rapier skills into",
      "Beast skills.",
    ],
    614 => ["Magus Doctor",
      "Can always equip Rods and Abacus. Can always use Black Magic,",
      "Mercantile, EX-Item, and Plant skills. Black Magic and Plant",
      "skills deal +30% with 66% MP/SP cost. May use Cleansing Honey",
      "on allies at the end of turn.",
    ],
    615 => ["Alraune of Mercy and Predation",
      "Innate Digestion Strike 30%. Can always equip Bows and",
      "Scalpels. Can always use Bow, Medicine, and Plant skills,",
      "dealing +30% damage. Bow and Medicine skills deal +150%",
      "damage to Digested foes and have a 30% chance to inflict",
      "Digestion. Chains Plant skills into Bow or Medicine skills.",
    ],
    616 => ["Noble Alraune",
      "Innate Horny+Trance+Seduction Strike 30%. Can always equip",
      "Whips. Can always use Whip and Plant skills, dealing +30%",
      "damage. Whip skills deal +150% damage to foes afflicted with",
      "Horny, Trance, and Seduction and have a 30% chance to inflict",
      "Horny, Trance, and Seduction. Chains Plant skills into Whip",
      "skills.",
    ],
    617 => ["Break Bomb",
      "Agility +30%. Can always equip Fists. Can always use Unarmed",
      "and Slime skills, dealing +30% damage and following them up",
      "with Slime Bomb. Chains Slime skills into Unarmed skills.",
      "Immune to Fire damage and takes halved Nuclear damage.",
    ],
    618 => ["Chemical Slime",
      "Can always equip Grimoires. Can always use Magic Science,",
      "Alchemy, and Slime skills, dealing +30% damage. Alchemy ",
      "skills have persistence, and a 65% chance to not consume",
      "materials when used. Immune to Fire, Ice, and Lightning",
      "damage and takes 75% Nuclear, Quantum, and Ion damage.",
    ],
    619 => ["Slime Idol",
      "+30% Evasion/Magic Evasion/Auto-Hit Evasion Rate. Can always",
      "equip Harps and Fans. Can always use Dancing, Singing, and",
      "Slime skills. Dancing and Singing skills deal +30% damage and",
      "have persistence. Chains Dancing skills into Singing skills.",
    ],
    620 => ["Ashura's Multiple Slashes",
      "Innate Dual Wield, and increases stats of equipped weapons by",
      "50% while dual wielding. Can always equip Katanas. Can always",
      "use Katana and Multiweapon skills, dealing +30% damage.",
      "Multi-hit Katana and Multiweapon skills inflict two",
      "additional hits. Multi-hit skills deal +15% damage for each",
      "successive hit.",
    ],
    621 => ["Large Colony Slime",
      "Max HP +50%. Can always equip Flails. Can always use",
      "Throwing, Flail, and Slime skills, dealing +50% damage.",
      "Throwing and Flail skills can use Dexterity in place of",
      "Attack. Slime skills execute an additional time. Chains",
      "Throwing or Flail skills into Slime skills. 50% chance of",
      "gaining an extra action; 25% chance of gaining an extra",
      "action. (These chances are rolled separately and can yield",
      "two extra actions)",
    ],
    622 => ["Nightmare Lamia",
      "Can always equip Flails. Can always use Flail, Sexcraft, and",
      "Snake skills, dealing +30% damage. Sexcraft skills can use",
      "Attack in place of Dexterity. Chains Flail or Snake skills",
      "into Sexcraft skills. Immune to Pleasure damage and takes",
      "halved Nightmare damage.",
    ],
    623 => ["Medusa Knight",
      "Can always equip Spears, Heavy Spears, and Bows. Can always",
      "use Spear, Bow, and Snake skills, dealing +30% damage.",
      "Spear and Bow skills deal +150% damage to Bound foes and can",
      "use Defense in place of other stats. Chains Snake skills into",
      "Spear or Bow skills.",
    ],
    624 => ["Pandora's Box", #NOTE: Slow conditional damage is applied through Plant skills instead of Sorcery.
      "Can always equip Rods. Can always use White Magic, Black",
      "Magic, Time Magic, and Sorcery skills, dealing +50% damage.",
      "White Magic, Black Magic, and Sorcery skills deal +150%",
      "damage to Slowed/Stopped foes. Chains Time Magic into White",
      "Magic, then Black Magic or Sorcery. Chained skills deal +50%",
      "damage and have their MP/SP costs further halved.",
    ],
    625 => ["Fragmented Identity",
      "Can always use Ocean, Tentacle, and Snake skills, dealing",
      "+30% damage with 50% SP cost. Chains Ocean skills into",
      "Tentacle and Snake skills. Immune to Water damage and takes",
      "halved Nano damage.",
    ],
    626 => ["Ancient Scylla",
      "Can always equip Katanas and Whips. Can always use Katana,",
      "Whip, and Tentacle skills, dealing +50% damage with 66% SP",
      "cost. Katana and Whip skills deal +150% damage to Bound foes.",
      "Chains Tentacle skills into Katana or Whip skills.",
    ],
    627 => ["Y'golonac",
      "Normal attack hits two additional times. Pleasure attacks",
      "deal Nightmare damage. Can always use Demon Arts and Sorcery",
      "skills, dealing +50% damage (+150% to Slimed foes). Skills",
      "using tongues execute two additional times. Takes 75% damage",
      "from all chaos elements.",
    ],
    628 => ["The Great Cat",
      "+10% Critical Rate/+50% Critical Damage, +30% Auto-Hit",
      "Evasion Rate. Can always equip Fists. Can always use Unarmed,",
      "Dancing, and Beast skills, dealing +30% damage with 66% SP",
      "cost. Dancing skills use Agility in place of Dexterity.",
      "Chains Dancing skills into Unarmed or Beast skills.",
    ],
    629 => ["Kishin's Unyielding Strength",
      "Can always equip Clubs. Can always use Club, Taoism, and",
      "Sorcery skills, dealing +50% damage. Club skills deal +150%",
      "damage to foes affected by Element Weak effects. Taoism",
      "skills can use Attack in place of other stats. Chains Taoism",
      "skills into Club or Sorcery skills",
    ],
    630 => ["Scorpion Taoist",
      "Can always equip Rods. Can always use Taoism, Talk, and",
      "Insect skills, dealing +30% damage. Insect skills can use",
      "Magic in place of other stats. Taoism deals +150% damage to",
      "Poisoned, Blind, and Silenced foes. Chains Insect skills into",
      "Taoism or Talk skills. Immune to Wind, Earth, and Water",
      "damage, and takes halved Hadron, Terra, and Nano damage.",
    ],
    631 => ["Cat-Type Robot",
      "Can always equip Guns. Can always use Gun, Makina, Cooking,",
      "Service, Beast, and Artificial skills, dealing +30% damage",
      "with 50% SP cost. Chains Gun or Makina skills into Cooking or",
      "Service skills.",
    ],
    632 => ["Mecha Taoist Swordsman",
      "Deal +30% Wind/Earth/Water damage. Can always equip Swords",
      "and Magic Swords. Can always use Sword, Taoism, and Makina",
      "skills, dealing +50% damage. Chains Sword skills into Taoism",
      "or Makina skills. Immune to Wind/Earth/Water damage, and",
      "takes 75% Hadron, Terra, and Nano damage.",
    ],
    633 => ["Aevis Knight",
      "Deal +30% Wind damage. +25% Critical Rate/+50% Critical",
      "Damage. Can always equip Spears and Heavy Spears. Can always",
      "use Spear and Wing skills, dealing +30% damage with 66% SP",
      "cost. Chains Spear into Wing skills. Immune to Wind damage,",
      "and takes halved Hadron damage.",
    ],
    634 => ["Savage Dragon Martial Artist",
      "Critical Rate +25%/Critical Damage +50%. Can always equip",
      "Fists. Can always use Unarmed, Wing, and Breath skills,",
      "dealing +30% damage with 65% SP cost. Chains Unarmed skills",
      "into Wing or Breath skills. Chained skills deal +50% damage.",
    ],
    635 => ["Versatile Succubus",
      "Can always equip Bows. Can always use Bow, Dancing, and",
      "Sexcraft skills, dealing +30% damage with 66% SP cost.",
      "Bow and Sexcraft skills deal +150% damage to foes afflicted",
      "with pleasure ailments. Chains Dancing skills into Bow or",
      "Sexcraft skills.",
    ],
    636 => ["Embodiment of a Noble Demon",
      "Can always equip Rapiers. Can always use Rapier and Demon",
      "Arts skills, dealing +75% damage, but have 133% MP/SP cost.",
      "Rapier skills deal +150% damage to Burned, Shocked, or Frozen",
      "foes. Chains Demon Arts skills into Rapier skills. Takes",
      "halved Dark damage and 75% Demise damage.",
    ],
    637 => ["Elite Pirate", #NOTE: Original description claims Piracy/Ocean skills use can Attack, but is actually Dexterity.
      "Can always use Gun, Piracy, and Ocean skills, dealing +30%",
      "damage with 66% SP cost. Gun skills deal +150% damage to foes",
      "affected by Element Weak effects. Piracy and Ocean skills can",
      "use Dexterity in place of other stats. Chains Piracy or Ocean",
      "skills into Gun skills.",
    ],
    638 => ["Power Pirate",
      "Attack +30%. Can always equip Great Swords. Piracy skills",
      "deal +50% damage. Starts battles with Attack Up active.",
      "Immune to Water damage and takes halved Nano damage.",
      "33% chance to use Focused Spirit at the start of turn.",
    ],
    639 => ["Gigantic Plant",
      "Maximum HP +100%. Attack +50%. Can always use Plant and Giant",
      "skills, dealing +75% damage and have persistence, but have",
      "150% SP cost. Plant skills use Attack in place of other stats.",
      "Giant skills deal +150% damage to Poisoned, Bound, and",
      "Tranced foes. Chains Plant skills into Giant skills.",
    ],
    640 => ["Alchemy Succubus",
      "Can always equip Grimoires. Can always use Magic Science and",
      "Alchemy skills, dealing +30% damage with 50% SP cost and have",
      "increased priority. 50% chance to not consume materials when ",
      "using Alchemy skills.",
    ],
    641 => ["Punishing Succubus", #NOTE: Same trait name in Japanese as Actor 284
      "Can always equip Bows and Whips. Can always use Bow, Whip,",
      "and Sexcraft skills, dealing +30% damage. Bow and Sexcraft",
      "skills deal 150% damage to foes that are bound or afflicted",
      "with pleasure ailments. Whip skills have a 50% chance to",
      "inflict Horny and Seduction. Chains Whip skills into Bow",
      "or Sexcraft skills. Immune to Pleasure damage and takes 75%",
      "Nightmare damage.",
    ],
    642 => ["Retainer of Babylon",
      "Deal +50% Pleasure damage and pierce resistance to it.",
      "Can always equip Rods and Sex Toys. Can always use Black",
      "Magic, Sexcraft, Demon Arts, and Psychic skills, dealing +30%",
      "damage. Sexcraft and Psychic skills deal +150% damage to",
      "Blind and Silenced foes. Chains Black Magic or Demon Arts",
      "skills into Sexcraft or Psychic skills. Absorbs Pleasure",
      "damage and takes 50% Nightmare damage.",
    ],
    643 => ["Man-Eating Beast Puppeteer",
      "Normal attack hits an additional time. Can always equip",
      "Whips. Can always use Whip and Beast skills, dealing +30%",
      "damage. Beast skills deal +150% damage to Bound foes. Chains",
      "Whip skills into Beast skills. 33% chance to devour all",
      "stunned, bound, or partially digested foes at the end of",
      "turn.",
    ],
    644 => ["Puppet Saint's Judgement",
      "Willpower +30%. Can always equip Staves. Can always use White",
      "Magic, Holy, and Artificial skills, dealing +30% damage.",
      "Artificial skills have a 50% chance to inflict Bind and can",
      "use Willpower in place of other stats. White Magic and Holy",
      "skills deal +150% damage to Bound foes. Chains Artificial",
      "skills into White Magic or Holy skills.",
    ],
    645 => ["Runaway Slicing Doll",
      "Can always equip Katanas. Can always use Katana skills,",
      "executing an additional time, and have a 30% chance to",
      "inflict Stun, but have 133% SP cost. Multi-hit Katana skills",
      "inflict two additional hits.",
    ],
    646 => ["Shouting Doll",
      "Deal +50% Sonic damage. Can always equip Harps. Can always",
      "use Singing skills, dealing +50% damage, have persistence and",
      "increased priority, have a 30% chance to inflict Sonic Weak,",
      "and deal +150% damage to Sonic Weak foes.",
    ],
    647 => ["Gigantic Doll", #NOTE: Original text states Artificial skills inflict stun, but notes indiciate Giant skills do this
      "Max HP +50%/Attack +30%. Can always use Artificial and Giant",
      "skills, dealing +75% damage, but have 150% SP cost. Giant",
      "skills have a 50% chance to inflict Stun and deal +150%",
      "damage to Stunned foes. 50% of Dexterity is added to Giant",
      "skill power. Chains Artificial skills into Giant skills.",
    ],
    648 => ["Improved Paizuri Doll",
      "Can always equip Plates and Sex Toys. Can always use Service",
      "and Sexcraft skills, dealing +30% damage with 66% SP cost.",
      "Skills using breasts deal +50% damage and execute an",
      "additional time. Chains Service skills into Sexcraft skills.",
    ],
    649 => ["Ultimate Love Doll",
      "Can always equip Fans and Sex Toys. Can always use Dancing",
      "and Sexcraft skills, dealing +30% damage with 50% SP cost.",
      "Sexcraft skills deal +150% damage to foes afflicted with",
      "pleasure ailments. Chains Dancing or Sexcraft skills into",
      "Sexcraft skills. Immune to Pleasure damage and takes halved",
      "Nightmare damage.",
    ],
    650 => ["Puppet Medium",
      "Can always equip Rods. Can always use Black Magic, Summoning,",
      "Corpse, and Psychic skills, dealing +30% damage. Ghost",
      "Summoning skills execute an additional time. Chains Black",
      "Magic or Psychic skills into Summoning skills. Immune to Dark",
      "damage and takes halved Demise damage.",
    ],
    651 => ["Humanoid Decisive Weapon",
      "Can always equip Guns and Heavy Armor. Can always use Gun,",
      "Makina, and Artificial skills, dealing +50% damage. Chains",
      "Gun skills into Makina then Artificial skills. Immune to",
      "Physical element damage and takes halved Carnage damage.",
    ],
    652 => ["Elegant Doll's Hospitality",
      "Normal attack hits an additional time. Can always equip Sex",
      "Toys. Can always use Sexcraft skills, dealing +30% damage and",
      "executing two additional times, but have 133% SP cost. Immune",
      "to Pleasure damage and takes halved Nightmare damage.",
    ],
    653 => ["Dancing Succubus",
      "Evasion/Magic Evasion/Auto-Hit Evasion Rate +30%. Can always",
      "equip Fans. Can always use Dancing and Sexcraft skills,",
      "dealing +30% damage with increased priority. Chains Dancing",
      "skills into Sexcraft skills.",
    ],
    654 => ["Ancestor of Insect Monsters",
      "Defense +30%. Can always equip Fists. Can always use Unarmed",
      "and Insect skills, dealing +50% damage with 50% SP cost.",
      "50% of Defense is added to Unarmed skill power.",
    ],
    655 => ["Semen-Sucking Girl",
      "Normal attack is replaced with Drain Strike. Can always use",
      "Summoning and Tentacle skills, dealing +30% damage.",
      "Tentacle skills restore own HP by 25% of damage dealt, and",
      "have a 30% chance to inflict Trance, All Stats Down, and",
      "Climax. Summoning skills deal +150% damage to Tranced and",
      "staat-weakened foes. Chains Tentacle skills into Summoning",
      "skills.",
    ],
    656 => ["Ancient Celestial Dragon",
      "Max HP +30%. Can always equip Spears and Heavy Spears. Can",
      "always use Spear and Breath skills, dealing +50% damage.",
      "50% of Agility is added to Breath skill power. Breath skills",
      "deal +150% damage to stat-weakened foes. Chains Spear skills",
      "into Breath skills.",
    ],
    657 => ["Gatekeeper of the Angelic Dominion",
      "Innate Dual Shielding. +30% Defense/Willpower. Takes 36% less",
      "damage. Can always equip Bucklers, Shields, and Heavy Shields.",
      "Can always use Throwing, Holy, Breath, and Giant skills.",
      "Throwing, Holy and Giant skills deal +50% damage and can use",
      "Defense in place of other stats. Chains Throwing skills into",
      "Holy or Giant skills.",
    ],
    658 => ["Runaway Armed Train", #NOTE: Has +125% Agility due to having two Agility +50% traits in her data.
      "Agility +125%. Can always equip Guns. Can always use Gun,",
      "Makina, and Artificial skills, dealing +30% damage with 66%",
      "SP Cost, and 50% of Agility added to their skill power.",
      "Chains Artificial skills into Makina then Gun skills.",
    ],
    659 => ["Apex Baphomet",
      "Can always equip Rapiers. Can always use Rapier, Black Magic,",
      "Time Magic, and Sorcery skills. Rapier, Black Magic, and Time",
      "Magic skills deal +50% damage. Rapier skills deal +150%",
      "damage to slowed or stopped foes. Black Magic and Time Magic",
      "can use Agility in place of Magic. Chains Black Magic or Time",
      "Magic skills into Rapier skills.",
    ],
    660 => ["Villainous Gal Elf",
      "Can always equip Daggers and Bows. Can always use Dagger,",
      "Bow, and Thievery skills, dealing +30% damage. Deals +150%",
      "damage with species slayer and +100% damage with conditional",
      "effects. Chains Dagger or Bow skills into Thievery skills.",
      "150% Steal Success/Item Drop/Gold Drop/Recruit Rate.",
    ],
    661 => ["Moving Stone Statue",
      "Can always equip Fists. Black Magic and Sorcery have a 30%",
      "chance to inflict Paralysis and Petrification. Can always use",
      "Unarmed, Black Magic, and Sorcery skills, dealing +30% damage",
      "and have persistence. Unarmed and Sorcery skills deal +150%",
      "damage to Paralyzed or Petrified foes. Chains Black Magic",
      "into Unarmed or Sorcery skills. Immune to Physical element",
      "damage and takes 75% Carnage damage.",
    ],
    662 => ["Sacred Beast Knight",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear, Throwing, and Holy skills. Spear and Holy skills deal",
      "+30% damage. 50% of Agility is added to Holy skill power.",
      "Holy skills have a 30% chance to inflict Stigmata. Spear",
      "skills deal +150% damage to foes afflicted with Stigmata.",
      "Chains Holy skills into Spear skills. Takes halved Holy",
      "damage and 75% Eternal damage.",
    ],
    663 => ["In Perfect Sync",
      "Max HP +30%. Normal attack hits an additional time. Can",
      "always use Unarmed, Ninjutsu, and Beast skills, executing an",
      "additional time, but have 133% SP cost. Chains Ninjutsu or",
      "Beast skills into Unarmed skills.",
    ],
    664 => ["Dragon's Head Knight",
      "Can always equip Swords and Knight Swords. Can always use",
      "Sword and Breath skills, dealing +50% damage. Sword skills",
      "deal +150% to Burned foes. Chains Breath skills into Sword",
      "skills.",
    ],
    665 => ["Big Whale",
      "Maximum HP +100%, Attack +50%. Innate Water Strike.",
      "Can always use Ocean and Giant skills, dealing +75% damage",
      "but have 133% SP cost. Ocean skills use Attack in place of",
      "other stats. Giant skills deal +150% damage to foes affected",
      "by Element Weak effects. Immune to Nano damage.",
    ],
    666 => ["Mutli-Armed God of Destruction",
      "Innate Dual Wield, and increases stats of equipped weapons by",
      "75% while dual wielding. Can always equip Katanas. Can always",
      "use Katana and Multiweapon skills, dealing +30% damage and",
      "executing an additional time. Chains Katana skills into",
      "Multiweapon skills.",
    ],
    667 => ["Ruler of the Seas",
      "Max HP/Attack +30%. Can always equip Spears and Heavy Spears.",
      "Can always use Spear and Ocean skills, dealing +50% damage.",
      "Ocean skills can use Attack in place of Dexterity. Ocean",
      "skills have a 30% chance to inflict All Stats Down. Chains",
      "Ocean skills into Spear skills. Absorbs to Water damage and",
      "is immune to Nano damage.",
    ],
    668 => ["Pearl of the Undead",
      "Max HP/Attack +30%. Can always equip Fists. Can always use",
      "Unarmed, Taoism, Dancing, Talk, and Corpse skills. Unarmed,",
      "Taoism, and Corpse skills deal +50% damage and can use Attack",
      "in place of other stats. Unarmed skills deal +150% damage to",
      "Poisoned, Zombified, and foes afflicted by Element Weak.",
      "Chains Taoism skills into Corpse then Unarmed skills. Immune",
      "to Dark damage and takes 75% Demise damage.",
    ],
    669 => ["Giant Alraune of Pollution",
      "Max HP/Attack +30%. Can always equip Flails. Can always use",
      "Flail, Plant, and Breath skills, dealing +50% damage. Flail",
      "skills deal +150% damage to foes afflicted with any status",
      "ailments. Bad Breath has no SP cost. Breath skills have a 75%",
      "chance to inflict various status ailments. 50% of Dexterity",
      "is added to Flail and Breath skill power. Chains Breath",
      "skills into Plant then Flail skills.",
    ],
    670 => ["Ancient Great Bird Monster",
      "Can always equip Spears and Heavy Spears. Can always use",
      "Spear, Dancing, and Wing skills, dealing +50% damage. Spear",
      "and Dancing skills use Agility in place of other stats. Spear",
      "and Wing skills deal +150% damage to foes afflicted with",
      "Slow, Stop, or Element Weak effects. Chains Dancing skills",
      "into Wing then Spear skills. Immune to Hadron damage.",
    ],
    671 => ["Noble Great Scylla",
      "Max HP +30%. Can always equip Rapiers and Whips. Can always",
      "use Rapier, Whip, Ocean, and Tentacle skills. Rapier, Whip,",
      "and Tentacle skills deal +50% damage. Rapier and Whip skills",
      "can use Dexterity in place of other stats. Rapier and",
      "Tentacle skills deal +150% damage to Bound foes. Chains Whip",
      "skills into Tentacle then Rapier skills. Immune to Nano",
      "damage.",
    ],
    672 => ["Valiant Great Lamia",
      "Max HP +30%. Can always equip Swords, Knight Swords, and",
      "Rapiers. Can always use Sword, Rapier, and Snake skills,",
      "dealing +50% damage. Sword and Rapier skills deal +150%",
      "damage to Bound foes and can use Defense in place of other",
      "stats. Chains Snake skills into Sword then Rapier skills.",
    ],
    674 => ["Monster Realm Wind Spirit",
      "Deal +50% Hadron damage. All attacks inflict Hadron damage.",
      "Evasion/Magic Evasion/Auto-Hit Evasion Rate +30%. Can always",
      "use Spear, Thievery, and Nature skills. Spear and Nature",
      "skills deal +30% damage. Chains Nature skills into Spear or",
      "Thievery skills. Gain Devastating Gale status (+300%",
      "Accuracy, 100% Evasion/50% Magic Evasion) while below 20% HP.",
      "Absorbs Hadron damage. Uses Wind Guard Kill at the start of",
      "battle. +15% to all stats for each Monster Realm Spirit in",
      "the party.",
    ],
    675 => ["Monster Realm Earth Spirit",
      "Deal +50% Terra damage. All attacks inflict Terra damage.",
      "Counter Rate +75%. Normal attacks deal 30x more damage. ",
      "Can always use Unarmed and Nature skills, dealing +30%",
      "damage. Unarmed skills can use Attack in place of Agility.",
      "Chains Nature skills into Unarmed skills. Gain Wild Lands",
      "status (+100% Defense/Critical Rate/Magical Critical Rate)",
      "while below 20% HP. Absorbs Terra damage, immune to Physical",
      "element damage, and takes halved Carnage damage. Uses Earth",
      "Guard Kill at the start of battle. +15% to all stats for each",
      "Monster Realm Spirit in the party.",
    ],
    676 => ["Monster Realm Water Spirit",
      "Deal +50% Nano damage. All attacks inflict Nano damage.",
      "Critical Rate +25%/Critical Damage +50%. Can always use Axe,",
      "Club, and Nature skills, dealing +30% damage. Chains Nature ",
      "skills into Axe or Club skills. Absorbs Nano damage. Immune",
      "to Slimed. Uses Water Guard Kill at the start of battle.",
      "+15% to all stats for each Monster Realm Spirit in the party.",
    ],
    677 => ["Monster Realm Fire Spirit",
      "Deal +50% Nuclear damage. All attacks inflict Nuclear damage.",
      "Evasion/Magic Evasion/Auto-Hit Evasion Rate +30%. Can always",
      "use Black Magic and Nature skills, dealing +30% damage.",
      "Chains Nature skills into Black Magic skills. Absorb Nuclear",
      "damage. Immune to Burn. Counters with Gamma Tempest after",
      "successfully evading an attack. Uses Fire Guard Kill at the",
      "start of battle. +15% to all stats for each Monster Realm",
      "Spirit in the party.",
    ],
    678 => ["Great Whore of Babylon",
      "Deal +75% Hadron/Nightmare damage. Physical and Wind attacks",
      "inflict Hadron damage. Pleasure attacks inflict Nightmare",
      "damage. Can always equip Fists and Sex Toys. Can always use",
      "Unarmed, Sexcraft, Nature, and Psychic skills, dealing +75%",
      "damage. Unarmed and Nature skills can use Dexterity in place",
      "of other stats. Chains Psychic skills into Sexcraft then",
      "Unarmed skills.",
    ],
    679 => ["Kanade",
      "Can always equip Boomerangs. Can always use Throwing and",
      "Slime skills, dealing +75% damage. Chains Throwing skills",
      "into Slime skills. 50% chance to counter any type of attack",
      "with Division. Stats are not reduced when dividing. Starts",
      "the battle with Kanade's Wall for 3 turns (75% HP/SP Regen,",
      "quarters all normal element/halve all chaos element damage,",
      "immune to all status ailments).",
    ],
    680 => ["Unidentified Tentacle Disaster",
      "Innate Digestion Strike 50%. Can always equip Fangs.",
      "Can always use Slime and Tentacle skills, dealing +75%",
      "damage with no SP cost. Chains up to three Tentacle skills",
      "in a row. 50% chance to devour all bound, entranced, or",
      "partially digested foes at the end of turn. Stats are not",
      "reduced when dividing.",
    ],
    681 => ["Thousand Trees Kanon",
      "Innate Poison/Blind/Silence/Paralysis/Sleep/Confusion",
      "Strike 30% Can always equip Whips. Can always use Whip and",
      "Plant skills, dealing +75% damage (+150% to foes suffering",
      "from any status ailments). Chains Whip skills into Whip then",
      "Plant skills.",
    ],
    682 => ["White-Faced Golden-Furred Nine-Tailed Kitsune",
      "Maximum HP/Defense +50%. Deal +75% Nuclear damage.",
      "Fire attacks inflict Nuclear damage. Can always equip Rods,",
      "Fans, Robes, and Magic Hats. Can always use White Magic,",
      "Black Magic, Time Magic, Summoning, Taoism, Ninjutsu, and",
      "Beast skills. White Magic, Black Magic, Taoism, and Ninjutsu",
      "deal +75% damage. Chains Beast skills into Taoism then",
      "Ninjutsu skills, or Dancing then Fan skills. Ninjutsu skills",
      "can use magic in place of other stats. Magic skills and",
      "Ninjutsu skills execute an additional time.",
    ],
    683 => ["Great Monster Lord",
      "Deal +75% Nuclear/Demise damage. Fire attacks inflict Nuclear",
      "damage. Dark attacks inflict Demise damage. Can always equip",
      "Rapiers. Can always use Rapier, Dark, Demon Arts, and Beast",
      "skills, dealing +75% damage. Dark, Demon Arts, and Beast",
      "skills can use Agility in place of other stats. Chains Dark",
      "skills into Demon Arts, then Rapier or Beast skills.",
    ],
    684 => ["Petite Dark Goddess",
      "Deal +30% Dark damage. Physical attacks inflict Dark damage.",
      "Can always equip Rapiers. Can always use Rapier, Black Magic,",
      "Dark, and Demon Arts skills, dealing +30% damage with 50%",
      "MP/SP cost. Dark skills consume only half as much HP.",
      "Takes halved damage from the Dark element. Chains Rapier or",
      "Black Magic skills into Dark skills.",
    ],
    685 => ["Goddess of Darkness",
      "Deal +75% Demise damage. Physical and Dark attacks inflict",
      "Demise damage. Can always equip Rapiers. Can always use",
      "Rapier, Black Magic, Dark, and Demon Arts skills, dealing",
      "+75% damage. Dark skills do not cost any HP. Immune to Dark",
      "damage, and takes halved damage from Demise attacks.",
      "Chains Rapier skills into Rapier, then Demon Arts, then Dark",
      "skills.",
    ],
    686 => ["Chaos Dark Goddess",
      "Gets an additional action every turn. Deal +100% Demise",
      "damage. Physical and Dark attacks inflict Demise damage. All",
      "skills have 150% MP/SP cost. Can always equip Rapiers. Can",
      "always use Rapier, Black Magic, Holy, Dark, Demon Arts, and",
      "Chaos skills, dealing +100% damage. Dark skills do not cost",
      "any HP. Immune to Holy and Dark damage and takes halved",
      "damage from Demise attacks. Chains Rapier skills into Rapier,",
      "then Demon Arts, then Holy or Dark, then Chaos skills.",
    ],
    692 => ["Fourth Law",
      "Can equip Great Swords",
      "Critical Rate, Critical Damage, Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Added Carnage, Nuclear and  Demise  attributes to physical attributes.",
      "The power of Carnage, Nuclear Heat, and Apocalypse attribute attacks is increased by 50% and penetrates enemy resistance.",
      "Able to use Sword skills, Holy skills, Dark skills and Chaos",
      "The power of Sword skills, Holy skills, Dark skills, and Chaos is increased by 50%.",
      "The power of Holy skills depends on ATK and Sword skills activate twice in a row",
      "Chain activation possible in the order of Sword skills → Holy skills or Dark skills → Chaos",
      "Automatically revives up to three times when incapacitated",
      "Ignores time stop",
    ],
    693 => ["Close Combat Specialization Fourth Law",
      "Can equip Great Swords",
      "Critical Rate, Critical Damage, Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Added Carnage, Nuclear and  Demise  attributes to physical attributes.",
      "The power of Carnage, Nuclear Heat, and Apocalypse attribute attacks is increased by 50% and penetrates enemy resistance.",
      "Able to use Sword skills, Holy skills, Dark skills and Chaos",
      "The power of Sword skills, Holy skills, Dark skills, and Chaos is increased by 50%.",
      "SP consumption for Sword skills, Holy skills, Dark skills and Chaos increases by 1/3",
      "The power of Holy skills depends on ATK and Sword skills activate three times in a row",
      "Chain activation possible in the order of Sword skills → Holy skills or Dark skills → Chaos",
      "Activates Desperate Strike when evading or countering an enemy attack",
      "Automatically revives up to two times when incapacitated",
      "Ignores time stop",
    ],
    694 => ["Ultimate Fourth Law",
      "Can equip Great Swords",
      "Critical Rate, Critical Damage, Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Added Carnage, Nuclear and  Demise  attributes to physical attributes.",
      "The power of Carnage, Nuclear Heat, and Apocalypse attribute attacks is increased by 100% and penetrates enemy resistance.",
      "Able to use Sword skills, Holy skills, Dark skills and Chaos",
      "The power of Sword skills, Holy skills, Dark skills, and Chaos is increased by 100%.",
      "The SP consumption of Sword skills, Holy skills, Dark skills and Chaos is increased by 1/2",
      "The power of Holy skills depends on ATK and Sword skills activate three times in a row",
      "Chain activation possible in the order of Sword skills → Holy skills or Dark skills → Chaos",
      "Activate Witch Time when avoiding or countering enemy attacks",
      "Automatically revive once when incapacitated",
      "Ignores time stop",
    ],
    695 => ["The Eraser",
      "Can act twice",
      "Can equip Great Swords",
      "Adds Carnage and Nuclear attributes to physical attacks",
      "Adds Nuclear attribute to Fire attribute",
      "Ashura, Nuclear Heat, and Galactic attribute attacks deal +100% damage and penetrate resistance",
      "Allows the use of Sword skills, Holy skills and Dark skills",
      "Sword, Holy, and Dark skills deal +100% damage",
      "Power of Holy skills depends on ATK",
      "Ignores time stop",
    ],
    696 => ["Time-traveling Rabbit",
      "Can equip Fists",
      "Adds Galaxy attribute to all attacks",
      "Galactic attribute attacks deal +50% damage and penetrate resistance",
      "Able to use White Magic, Time magic and Beast skills",
      "White Magic, Time Magic, and Beast skills deal +50% damage",
      "The power of White Magic and Time magic depends on agility",
      "The MP and SP consumption of White Magic, Time magic and Beast skills is halved",
      "Ignores time stop",
    ],
    697 => ["The One Who Governs Eternity",
      "Can act twice",
      "Can equip Fists",
      "Add Eternal attributes to Physical and Holy attributes",
      "Eternal and Galactic attribute attacks deal +100% damage and penetrate resistance",
      "Able to use White Magic, Time magic and Beast skills",
      "White Magic, Time Magic, and Beast skills deal +100% damage",
      "The power of White Magic and Time magic depends on agility",
      "Ignores time stop",
    ],
    698 => ["Manager of the Underworld",
      "Can equip Scythes",
      "Adds death attribute to all attacks",
      " demise attribute attacks deal +50% damage and penetrate resistance",
      "Can use scythe skills, Black magic and corpse skills",
      "Scythe skills, Black Magic, and Corpse skills deal +50% damage",
      "The power of Corpse skills depends on magical power.",
      "The MP and SP consumption of Sickle skills, Black magic and Corpse skills are halved.",
      "Ignores time stop",
    ],
    699 => ["The thing that governs the end",
      "Can act twice",
      "Can equip Scythes",
      "Adds Demise attribute to Physical and Dark attributes",
      "Adds Nuclear attribute to Fire attribute",
      "Nuclear Heat and  demise attribute attacks deal +100% damage and penetrate resistance",
      "Can use scythe skills, Black magic and corpse skills",
      "Scythe skills, Black Magic, and Corpse skills deal +100% damage",
      "The power of Corpse skills depends on magical power.",
      "Ignores time stop",
    ],
    700 => ["Ideal Hero Image",
      "Can act twice",
      "Can always equip Swords, Knight Swords and Heavy Armor",
      "Adds Carnage attribute to physical attacks",
      "Carnage attribute attacks deal +100% damage and penetrate resistance",
      "Can use Sword skills and Hero skills",
      "Sword skills and Heroism skills deal +100% damage",
    ],
    702 => ["NEET Glasses",
      "Can equip Scythes",
      "Adds eternal attribute to holy attribute and Demise attribute to dark attribute",
      "Eternal and Demise attribute attacks deal +50% damage and penetrate resistance",
      "Able to use Taoism skills, Holy skills, Dark skills and Chaos",
      "Taoism, Holy skills, Dark skills, and Chaos deal +50% damage",
      "The power of Holy skills depends on magic power",
      "Taoism skills, Holy skills, Dark skills and Chaos can be chain activated in order",
      "When evading an enemy attack, Witch Time Zero activates",
      "HP and SP recover each turn",
      "Ignores time stop",
    ],
    703 => ["Super Neet Glasses",
      "Can equip Scythes",
      "Adds eternal attribute to holy attribute and Demise attribute to dark attribute",
      "Eternal and Demise attribute attacks deal +75% damage and penetrate resistance",
      "Able to use Taoism skills, Holy skills, Dark skills and Chaos",
      "Taoism, Holy skills, Dark skills, and Chaos deal +75% damage",
      "The SP consumption of Taoism skills, Holy skills, Dark skills and Chaos is increased by 1/3",
      "The power of Holy skills depends on magic power",
      "Taoism skills, Holy skills, Dark skills and Chaos can be chain activated in order",
      "When evading an enemy attack, Witch Time Zero activates",
      "HP and SP recover each turn",
      "Ignores time stop",
    ],
    704 => ["Seventeenth Monster Lord",
      "Can equip Swords, Knight Swords and Great Swords",
      "Adds eternal attribute to holy attribute and Demise attribute to dark attribute",
      "Eternal and Demise attribute attacks deal +50% damage and penetrate resistance",
      "Able to use Sword skills, Holy skills, Dark skills and Chaos",
      "The power of Sword skills, Holy skills, Dark skills, and Chaos is increased by 50%.",
      "Power of Holy skills depends on ATK",
      "Chain activation possible in the order of Sword skills, Holy skills, Dark skills and Chaos",
      "When evading an enemys attack, Kenkons bullet time is activated.",
      "HP and SP recover each turn",
      "Ignores time stop",
    ],
    705 => ["Super 17th Monster Lord",
      "Can equip Swords, Knight Swords and Great Swords",
      "Adds eternal attribute to holy attribute and Demise attribute to dark attribute",
      "Eternal and Demise attribute attacks deal +75% damage and penetrate resistance",
      "Able to use Sword skills, Holy skills, Dark skills and Chaos",
      "Sword skills, Holy skills, Dark skills, and Chaos deal +75% damage",
      "SP consumption for Sword skills, Holy skills, Dark skills and Chaos increases by 1/3",
      "Power of Holy skills depends on ATK",
      "Chain activation possible in the order of Sword skills, Holy skills, Dark skills and Chaos",
      "When evading an enemys attack, Kenkons bullet time is activated.",
      "HP and SP recover each turn",
      "Ignores time stop",
    ],
    706 => ["Spirit of Chaos",
      "Eternal and Demise attribute attacks deal +75% damage",
      "Special damage to apoptosis",
      "Can use Sacred skills, Dark skills, Tentacle skills and Chaos",
      "Holy skills, Dark skills, Tentacle skills, and Chaos deal +75% damage",
      "The power of Sacred skills, Dark skills and Chaos depends on dexterity",
      "Chain can be activated in the order of Tentacle skills, Sacred skills, Dark skills and Chaos",
      "Activates nullification counter during enemys time stop",
      "Ignores time stop",
    ],
    707 => ["God of Chaos",
      "Can act twice",
      "All attributes become chaotic",
      "Chaos attribute attacks deal +100% damage and penetrate resistance",
      "Can use Holy Arts, Dark Arts and Chaos",
      "The power of Holy skills, Dark skills, and Chaos is increased by 100%",
      "Can chain Holy Arts → Dark Arts → Holy Arts → Dark Arts → Chaos",
      "Nullifies damage from non-Chaos attributes",
      "Damage taken from Chaos attribute is reduced to 1/4",
      "Ignores time stop",
    ],
    709 => ["Eighth Monster Lord", #NOTE: All Black Alice forms except Third God form have boosted Dark damage instead of Demise like original text suggests.
      "Deal +50% Dark damage. Can always use Rapier, Katana, Black",
      "Magic, Time Magic, and Dark skills. Black Magic and Time",
      "Magic execute two additional times, but cost twice as much",
      "MP. Rapier and Katana skills can use Magic in place of other",
      "stats. Always has Rapier and Katana-type skill compatability",
      "in addition to currently equipped weapon.",
    ],
    710 => ["Eighth Monster Lord: Second Form",
      "Deal +50% Dark damage. Can always use Black Magic, Time",
      "Magic, Dark, and Tentacle skills. Black Magic and Time",
      "Magic deal +30% damage and execute two additional times, but",
      "have 2.5x MP cost. Tentacle skills can use Magic in place of",
      "other stats.",
    ],
    711 => ["Eighth Monster Lord: Third Form",
      "Deal +50% Dark damage. Can always use Black Magic, Time",
      "Magic, Dark, and Tentacle skills. Black Magic and Time",
      "Magic deal +50% damage and execute two additional times, but",
      "have 3x MP cost. Tentacle skills can use Magic in place",
      "of other stats.",
    ],
    712 => ["Eighth Monster Lord: Rampage Form",
      "Deal +50% Dark damage. Can always use Black Magic, Time",
      "Magic, Dark, and Tentacle skills. Black Magic and Time",
      "Magic deal +50% damage and execute three additional times,",
      "but have 5x MP cost. Tentacle skills can use Magic in place",
      "of other stats.",
    ],
    713 => ["The Third God",
      "Gets an additional action every turn. Deal +50% Eternal/",
      "Demise damage and pierces resistances to them. Holy attacks",
      "deal Eternal damage and Dark attacks deal Demise damage.",
      "All skills cost twice as much MP/SP. Can always use Black",
      "Magic, Time Magic, Holy, Dark, and Chaos skills, dealing +30%",
      "damage and executing three additional times. Chains White",
      "Magic or Holy skills into Black Magic or Dark skills, then",
      "Time Magic then Chaos skills. Immune to Holy and Dark damage.",
      "Takes halved damage from Eternal and Demise attacks.",
    ],
    714 => ["Mutant Monster Lord",
      "Deal +30% Dark damage. Can always use Dark, Slime, and",
      "Tentacle skills, executing two additional times, but have",
      "133% SP cost.",
    ],
    715 => ["Pretend Thief",
      "Deal +30% Dark damage. Can always use Dagger, Dark, and",
      "Thievery skills. Dagger and Thievery skills execute an",
      "additional time, but have 133% SP cost.",
    ],
    716 => ["Pretend Maid",
      "Deal +30% Dark damage. Can always use Dark and Service",
      "skills. Service skills execute an additional time, but have",
      "133% SP cost.",
    ],
    717 => ["Pretend Doctor",
      "Deal +30% Dark damage. Can always use Dark and Medicine",
      "skills. Medicine skills execute an addition time, but have",
      "133% SP cost.",
    ],
    718 => ["Pretend Merchant",
      "Deal +30% Dark damage. Can always use Dark and Mercantile",
      "skills. Mercantile skills execute an additional time, but",
      "have 133% Gold cost.",
    ],
    719 => ["Pretend Swordswoman",
      "Deal +30% Dark damage. Can always use Sword and Dark skills.",
      "Sword skills execute an additional time, but have 133%",
      "SP cost.",
    ],
    720 => ["Pretend Martial Artist",
      "Deal +30% Dark damage. Can always use Unarmed and Dark",
      "skills. Unarmed skills execute an additional time, but have",
      "133% SP cost.",
    ],
    721 => ["Pretend Hunter",
      "Deal +30% Dark damage. Can always use Bow and Dark skills.",
      "Bow skills execute an additional time, but have 133% SP cost.",
    ],
    722 => ["Pretend Nun",
      "Deal +30% Dark damage. Can always use White Magic and Dark",
      "skills. White Magic executes an additional time, but has 133%",
      "MP cost.",
    ],
    723 => ["Pretend Samurai",
      "Deal +30% Dark damage. Can always use Katana and Dark skills.",
      "Katana skills execute an additional time, but have 133%",
      "SP cost.",
    ],
    724 => ["Pretend Ninja", #NOTE: Was improperly assigned Medicine skill use in her actor data instead ofn Ninjutsu skill use
      "Deal +30% Dark damage. Can always use Dark and Medicine",
      "skills. Ninjutsu skills execute an additional time, but have",
      "133% SP cost.",
    ],
    725 => ["Pretend Dancer",
      "Deal +30% Dark damage. Can always use Fan, Dark and Dancing",
      "skills. Fan and Dancing skills execute an additional time,",
      "but have 133% SP cost.",
    ],
    726 => ["Pretend Pirate",
      "Deal +30% Dark damage. Can always use Dark and Piracy skills.",
      "Piracy skills execute an additional time, but have 133%",
      "SP cost.",
    ],
    727 => ["Pretend Medium",
      "Deal +30% Dark damage. Can always use Summoning and Dark",
      "skills. Oracle skills execute an additional time, but have",
      "133% MP/SP cost.",
    ],
    728 => ["Pretend Rabbit", #NOTE: Oracle skill use and double execution, but SP cost increase applied to Holy skills not mentioned in original text.
      "Deal +30% Dark damage. Can always use Dark, Oracle, and",
      "Beast skills. Oracle and Beast skills execute an additional",
      "time. Holy and Beast skills have 133% SP cost.",
    ],
    729 => ["Pretend Magical Girl",
      "Deal +30% Dark damage. Can always use Dark and Justice",
      "skills. Justice skills can be used without transforming.",
      "Magical Justice skills execute an additional time, but have",
      "133% MP cost.",
    ],
    730 => ["Third Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Rapiers. Can always use",
      "Rapier, Dark, Wing, and Artificial skills, dealing +50%",
      "damage (+100% to foes afflicted with Corruption). Rapier and",
      "Dark skills have an additional 15% chance to inflict",
      "Corruption. Dark and Artificial skills can use Agility in",
      "place of other stats. Chains Dark or Artificial skills into",
      "Wing then Rapier skills.",
    ],
    731 => ["Third Monster Lord",
      "Deal +50% Nuclear/Demise damage. Physical attacks also",
      "inflict Nuclear+Demise damage. Can always equip Rapiers. Can",
      "alwaysuse Rapier, Dark, and Wing skills, dealing +50% damage",
      "(+100% foes afflicted with Corruption). Rapier and Dark",
      "skills have an additional 15% chance to inflict Corruption.",
      "Dark skills can use Agility in place of other stats. Chains",
      "Dark skills into Wing then Rapier skills.",
    ],
    732 => ["Fourth Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Fists and Rods. Can always",
      "use Unarmed, Time Magic, Dark, and Artificial skills, dealing",
      "+50% damage (+100% to foes afflicted with Slow, Stop, or",
      "Corruption). Unarmed and Dark skills have an additional 15%",
      "chance to inflict Corruption. Unarmed and Artificial skills",
      "can use Magic in place of other stats. Chains Dark or",
      "Artificial skills into Time Magic then Unarmed skills.",
    ],
    733 => ["Fourth Monster Lord",
      "Deal +50% Demise/Galactic damage. Physical attacks also",
      "inflict Demise+Galactic damage. Can always equip Fists and",
      "Rods. Can always use Unarmed, Time Magic, and Dark skills,",
      "dealing +50% damage (+100% to foes afflicted with Slow, Stop,",
      "or Corruption). Unarmed and Dark skills have an additional",
      "15% chance to inflict Corruption. Unarmed skills can use",
      "Magic in place of other stats. Chains Dark skills into Time",
      "Magic then Unarmed skills.",
    ],
    734 => ["Fifth Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Katanas. Can always use",
      "Katana, Dark, Slime, and Artificial skills, dealing +50%",
      "damage (+100% to foes. afflicted with Corruption). Katana and",
      "Dark skills have an additional 15% chance to inflict",
      "Corruption. Katana and Dark skills can use Dexterity in place",
      "of other stats. Chains Katana, Slime, or Artificial skills",
      "into Dark skills.",
    ],
    735 => ["Fifth Monster Lord",
      "Deal +50% Nuclear/Demise damage. Physical attacks also",
      "inflict Nuclear+Demise damage. Can always equip Katanas.",
      "Can always use Katana, Dark, and Slime skills, dealing +50%",
      "damage (+100% to foes afflicted with Corruption). Katana and",
      "Dark skills have an additional 15% chance to inflict",
      "Corruption. Katana and Dark skills can use Dexterity in place",
      "of other stats. Chains Dark skills into Slime then Katana",
      "skills.",
    ],
    736 => ["Sixth Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Rods. Can always use Taoism,",
      "Dark, Artificial, and Breath skills, dealing +50% damage",
      "(+100% to foes afflicted with Corruption). Taoism and Dark",
      "skills have an additional 15% chance to inflict Corruption.",
      "Artificial and Breath skills can use Magic in place of other",
      "stats. Chains Dark or Artificial skills into Taoism then.",
      "Breath skills.",
    ],
    737 => ["Sixth Monster Lord",
      "Deal +50% Quantum/Demise damage. Physical attacks also",
      "inflict Quantum+Demise damage. Can always equip Rods. Can",
      "always use Taoism, Dark, and Breath skills, dealing +50%",
      "damage (+100% to foes afflicted with Corruption). Taoism and",
      "Dark skills have an additional 15% chance to inflict",
      "Corruption. Breath skills can use Magic in place of other",
      "stats. Chains Dark skills into Taoism then Breath skills.",
    ],
    738 => ["Seventh Monster Lord Puppet",
      "Deal +50% Bio/Carnage damage. Physical attacks also inflict",
      "Bio+Carnage damage. Can always equip Whips. Can always use",
      "Whip, Dark, Plant, and Artificial skills, dealing +50% damage",
      "(+100% to foes afflicted with Poison, Blind, or Corruption).",
      "Whip and Dark skills have an additional 15% chance to inflict",
      "Corruption. Dark skills can use Dexterity in place of other",
      "stats. Chains Dark or Artificial skills into Plant then Whip",
      "skills.",
    ],
    739 => ["Seventh Monster Lord",
      "Deal +50% Bio/Demise damage. Physical attacks also inflict",
      "Bio+Demise damage. Can always equip Whips. Can always use",
      "Whip, Dark, and Plant skills, dealing +50% damage (+100% to",
      "afflicted with Poison, Blind, or Corruption). Whip and Dark",
      "skills have an additional 15% chance to inflict Corruption.",
      "Dark skills can use Dexterity in place of other stats. Chains",
      "Dark skills into Plant then Whip skills.",
    ],
    740 => ["Ninth Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Spears and Heavy Spears. Can",
      "always use Spear, Dark, and Artificial skills, dealing +50%",
      "damage (+100% to foes afflicted with Corruption). Spear and",
      "Dark skills have an additional 15% chance to inflict",
      "Corruption. Dark and Artificial skills can use Agility in",
      "place of other stats. Chains Dark or Artificial skills into",
      "Spear then Spear skills.",
    ],
    741 => ["Ninth Monster Lord",
      "Deal +50% Demise damage. Physical attacks also inflict Demise",
      "damage. Can always equip Spears and Heavy Spears. Can always",
      "use Spear and Dark skills, dealing +50% damage (+100% to foes",
      "afflicted with Corruption) and have an additional 15% chance",
      "to inflict Corruption. Dark skills can use Agility in place",
      "of other stats. Chains Dark skills into Spear then Spear.",
      "skills.",
    ],
    742 => ["Tenth Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage Can always equip Rods. Can always use Summoning,",
      "Dark, Corpse, and Artificial skills, dealing +50% damage",
      "(+100% to foes afflicted with Corruption). Summoning, Dark,",
      "and Corpse skills have an additional 15% chance to inflict",
      "Corruption. Corpse and Artificial skills can use Magic in",
      "place of other stats. Chains Dark or Artificial skills into",
      "Corpse then Summoning skills.",
    ],
    743 => ["Tenth Monster Lord",
      "Deal +50% Demise damage. Physical attacks also inflict Demise",
      "damage. Can always equip Rods. Can always use Summoning,",
      "Dark, and Corpse skills, dealing +50% damage (+100% to foes",
      "afflicted with Corruption) and have an additional 15% chance",
      "to inflict Corruption. Corpse skills can use Magic in place",
      "of other stats. Chains Dark skills into Corpse then Summoning",
      "skills.",
    ],
    744 => ["Eleventh + Twelfth Monster Lord Puppets",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Fists. Can always use",
      "Unarmed, Dark, and Artificial skills, dealing +50% damage",
      "(+100% to foes afflicted with Corruption). Unarmed and Dark",
      "skills have an additional 15% chance to inflict Corruption.",
      "Dark skills can use Agility in place of other stats. Chains",
      "Dark or Artificial skills into Unarmed then Unarmed skills.",
    ],
    745 => ["Eleventh Monster Lord",
      "Deal +50% Demise damage. Physical attacks also inflict Demise",
      "damage. Can always equip Staves. Can always use White Magic,",
      "Dark, and Ocean skills, dealing +50% damage (+100% to foes",
      "afflicted with Corruption) and have an additional 15% chance",
      "inflict Corruption. Dark skills can use Willpower in place of",
      "other stats. Chains Dark skills into Ocean then White Magic",
      "skills.",
    ],
    746 => ["Twelfth Monster Lord",
      "Deal +50% Demise damage. Physical attacks also inflict Demise",
      "damage. Can always equip Fists. Can always use Unarmed, Dark,",
      "and Beast skills, dealing +50% damage (+100% to foes",
      "afflicted with Corruption) and have an additional 15% chance",
      "to inflict Corruption. Dark skills can use Agility in place ",
      "of other stats. Chains Dark skills into Beast then Unarmed",
      "skills.",
    ],
    747 => ["Thirteenth Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Scalpels. Can always use",
      "Dark, Medicine, Beast, and Artificial skills, dealing +50%",
      "damage (+100% to foes afflicted with Corruption). Dark and",
      "Medicine skills have an additional 15% chance to inflict",
      "Corruption. Dark and Beast skills can use Dexterity in place",
      "of other stats. Chains Dark or Artificial skills into",
      "Medicine then Beast skills.",
    ],
    748 => ["Thirteenth Monster Lord", #NOTE: Does not have added Corruption chance on skills
      "Deal +50% Demise damage. Physical attacks also inflict Demise",
      "damage. Can always equip Scalpels. Can always use Dark,",
      "Medicine, and Beast skills, dealing +50% damage (+100% to",
      "foes afflicted with Corruption). Dark and Beast skills can",
      "use Dexterity in place of other stats. Chains Dark skills",
      "into Medicine then Beast skills.",
    ],
    749 => ["Fourteenth Monster Lord Puppet",
      "Deal +50% Carnage damage. Physical attacks also inflict",
      "Carnage damage. Can always equip Fans. Can always use Fan,",
      "Dark, Dancing, Singing, and Artificial skills, dealing +50%",
      "damage (+100% to foes afflicted with Corruption). Fan, Dark,",
      "Dancing, and Singing skills have an additional 15% chance to",
      "inflict Corruption. Dark skills can use Dexterity in place of",
      "other stats. Chains Dark or Artificial skills into Dancing",
      "or Singing then Fan skills.",
    ],
    750 => ["Fourteenth Monster Lord",
      "Deal +50% Demise damage. Physical attacks also inflict Demise",
      "damage. Can always equip Fans. Can always use Fan, Dark,",
      "Dancing, and Singing skills, dealing +50% damage (+100% to",
      "foes afflicted with Corruption) and have an additional 15%",
      "chance to inflict Corruption. Dark skills can use Dexterity",
      "in place of other stats. Chains Dark skills into Dancing",
      "or Singing then Fan skills.",
    ],
    751 => ["Fifteenth Monster Lord", #NOTE: Is missing increased Critical Chance, and only gets Critical Damage boost
      "Deal +50% Demise damage. Physical attacks also inflict Demise",
      "damage. +50% Critcal Damage. Can always equip Flails. Can",
      "always use Flail, Dark, and Snake skills, dealing +50%",
      "damage (+150% to foes afflicted with Corruption). Chains Dark",
      "skills into Snake then Flail skills.",
    ],
    752 => ["Fifteenth Monster Lord Zombie",
      "+15% Critical Rate/+50% Critical Damage. Can always equip",
      "Flails. Can always use Flail, Dark, and Corpse skills,",
      "dealing +50% damage (+150% to foes afflicted with ",
      "Corruption). Chains Dark or Corpse skills into Snake then",
      "Flail skills.",
    ],
    753 => ["Sun Wukong, Great Sage Equal to Heaven",
      "Innate Triple Wield. Can always equip Swords, Knight Swords,",
      "Great Swords, Axes, and Clubs. Can always use Sword, Axe,",
      "Club, Multiweapon, and Taoism skills, dealing +30% damage.",
      "Chains Sword, Multiweapon, or Taoism skills into Club then",
      "Axe skills. Chained skill MP/SP cost is further halved.",
    ],
    754 => ["Feathered Serpent",
      "Can always equip Fans. Can always use White Magic, Dancing,",
      "Snake, Wing, and Breath skills, dealing +50% damage.",
      "Chains White Magic or Dancing skills into Wing or Breath",
      "skills. Chained skill MP/SP cost is further halved.",
    ],
    755 => ["Smoke-Emitting Mirror",
      "Max MP and Magic +30%. Can always equip Scythes, Rods, and",
      "Magic Hats. Can always use Scythe, Black Magic, Time Magic,",
      "and Beast skills. Beast skills can use Magic in place of",
      "other stats. Chains Black Magic or Scythe skills into Beast",
      "skills.",
    ],
    756 => ["Ancient dragon serpent god",
      "Can always equip Flails. Can always use Flail, Snake, and",
      "Breath skills, dealing +50% damage. Breath skills have 50% SP",
      "cost, 50% of Attack added to their skill power, and deal",
      "+150% damage to foes afflicted with Burn/Shock/Freeze/",
      "Stigmata/Corruption. Chains Flail, Snake, or Breath skills",
      "into Breath skills.",
    ],
    757 => ["Amaterasu Land God",
      "Can equip Katanas and Fans",
      "Dual-wielding possible",
      "Can use Sword skills, Fan skills, Taoism skills, Dance and Sexcraft skills",
      "The power of Sword skills, Fan skills, Taoism, Dance, and Lewd skills increases by 30%",
      "Can chain activate from Sword skills and Fan skills to Taoism skills, Dance and Sexcraft skills",
      "Adds Burn and Stigma effects to Sword skills, Fan skills, Taoism skills and Dance",
      "Massive special attack damage to enemies in burn/stigmata state with sword skills, Fan skills, Taoism skills, dancing and Sexcraft skills",
      "Significantly increases the occurrence rate of status abnormalities for dancing and Sexcraft skills",
    ],
    758 => ["Queen of the Underworld",
      "Innate Dual Wield. Can always equip Scythes, Ninja Swords,",
      "and Kitchen Knives. Can always use Scythe, Taoism, Ninjutsu,",
      "Cooking, Corpse, and Sorcery skills, dealing +50% damage",
      "Scythe, Taoism, Ninjutsu, Cooking, and Corpse skills have a",
      "25% chance to inflict Freeze, Zombie, Corruption, and Instant",
      "Death. Scythe, Taoism, Ninjutsu, and Cooking skills deal",
      "+150% damage to Frozen, Zombified, and Corrupted foes. Chains",
      "Corpse skills into Scythe, Taoism, Ninjutsu, or Cooking",
      "skills.",
    ],
    759 => ["The God of Mechanical Devices",
      "Adds Carnage attribute to Physical attacks, Eternal attribute to Holy attacks and Doom attribute to Dark attacks",
      "The power of Carnage, Eternity, and demise attribute attacks increases by 75%",
      "Can use Gun skills, Sacred skills, Dark skills, Makina, Artificial skills and Chaos",
      "The power of Gun skills, Holy skills, Dark skills, Machina, Artificial, and Chaos increases by 75%",
      "Nullifies damage from Holy and Dark attributes, halves damage from Eternity and Demise attributes",
      "Chain can be activated in the order of Gun skills → Machina or Artificial skills → Sacred skills → Dark skills → Chaos",
    ],
    760 => ["Machine impregnated with God",
      "All MP and SP costs are 1.5 times",
      "Adds Carnage attribute to Physical attacks, Eternal attribute to Holy attacks and Doom attribute to Dark attacks",
      "The power of Carnage, Eternity, and demise attribute attacks increases by 75%",
      "Can use Gun skills, Sacred skills, Dark skills, Makina, Artificial skills and Chaos",
      "The power of Gun skills, Holy skills, Dark skills, Machina, Artificial, and Chaos increases by 75%",
      "Nullifies damage from Holy and Dark attributes, halves damage from Eternity and Demise attributes",
      "Sacred skills, Dark skills and Makina are activated twice in a row.",
      "Chain can be activated in the order of Gun skills → Machina or Artificial skills → Sacred skills → Dark skills → Chaos",
    ],
    761 => ["Anti-apoptosis annihilator",
      "Adds Carnage attribute to physical attacks",
      "The power of Carnage attribute attacks increases by 50% and penetrates resistance",
      "Can use Gun skills, Makina and Artificial",
      "The power of Gun skills, Machina, and Artificial increases by 50%",
      "Causes special damage against apoptosis",
      "Halve damage taken from physical, holy and dark attributes.",
    ],
    762 => ["The Ultimate Zombie Final Form",
      "SP gradually recovers.",
      "Can equip Fist and Heavy Armor",
      "Can use Unarmed, Gun skills and Makina",
      "Unarmed, Gun skills, and Makina skills deal +50% damage and activate Sturdy.",
      "The power of Unarmed, Gun skills and Makina depends solely on ATK",
      "Chain activation possible in the order of Makina → Unarmed → Gun skills",
      "Abilities increase by 50% if Chrome is in the party",
    ],
    763 => ["Nameless Sister: White",
      "Can always equip Spears and Staves. Can always use Spear and",
      "White Magic skills, dealing +30% damage. 50% of Willpower is",
      "added to Spear skill power. Chains White Magic into Spear",
      "skills. +30% to all stats if Chrome is in the party.",
    ],
    764 => ["Nameless Sister: Black",
      "Can always equip Swords, Magic Swords, and Rods. Can always",
      "use Sword and Black Magic skills, dealing +30% damage. 50% of",
      "Magic is added to Sword skill power. Chains Black Magic into",
      "Sword skills. +30% to all stats if Chrome is in the party.",
    ],
    765 => ["Chrome's Craft: Ultimate Doll",
      "Can equip Guns",
      "Triple-wielding possible, and equipment effects are enhanced when triple-wielding.",
      "Gun skills, Makina, Medical skills, Service and Artificial skills can be used.",
      "The power of Gun skills, Makina, Medical skills, Service, and Artificial skills is increased by 50%.",
      "Chain activation possible in the order of Artificial or Medicine or Service → Gun skills → Makina",
      "Abilities increase by 50% if Chrome is in the party",
    ],
    766 => ["White Magicraft Master",
      "Innate Dual Wield. Can always equip Scalpels and Guns.",
      "Can always use Gun, Summoning, Medicine, and Corpse skills,",
      "dealing +50% damage with 50% MP/SP cost. Summoning skills",
      "execute an additional time. Summoning, Medicine, and Corpse",
      "skills can use Dexterity in place of other stats. Chains",
      "Medicine or Corpse skills into Gun then Summoning skills.",
      "Counters with Bullet Time after evading an attack.",
    ],
    767 => ["Outlaw puppeteer",
      "Can equip Guns",
      "Dual-wielding possible",
      "You can use Gun skills, Summoning and Artificial skills",
      "Power of Gun skills, Summoning, and Artificial increases by 50%",
      "MP and SP consumption for Gun skills, Summoning and Artificial skills are halved.",
      "Chain can be activated in the order of Special skills, Gun skills or artifice and Summon",
      "Summon is activated three times in a row.",
      "Explodes when incapacitated",
    ],
    768 => ["Outlaw Puppeteer/Kai",
      "Can equip Guns",
      "Dual-wielding possible",
      "You can use Gun skills, Summoning and Artificial skills",
      "Power of Gun skills, Summoning, and Artificial increases by 75%",
      "The MP and SP consumption of Gun skills, Summoning and Artificial increases by 1/3",
      "Chain activation possible in the order of Special skills, Gun skills, Summoning",
      "Gun skills and Summoning activate three times consecutively",
      "Explodes when incapacitated",
    ],
    769 => ["Kagetsumugi Doll - First Form",
      "Can equip Fists",
      "Frequently restrained with physical attacks",
      "Able to use Unarmed, Insect skills and Artificial",
      "Power of Unarmed, Insect skills, and Artificial increases by 50%",
      "Chain activation possible in the order of Artificial → Insect skills → Unarmed",
      "Special damage to restrained enemies with Unarmed, Insect skills, and Artificial.",
      "If Kagetsumugi is in the party, abilities increase by 50%",
    ],
    770 => ["Kagetsumugi Doll - Second Form",
      "Critical Rate and Critical Damage increase by 50%",
      "Can always equip Ninja Swords",
      "Frequently inflicts Sensitive and Seduction states with physical attacks",
      "Able to use Ninjutsu, Beast skills and Artificial",
      "Power of Ninjutsu, Beast skills, and Artificial increases by 50%",
      "Chain activation possible in the order of Artificial → Ninjutsu → Beast skills",
      "If Kagetsumugi is in the party, abilities increase by 50%",
    ],
    771 => ["Kagetsumugi Doll: Third Form",
      "Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Able to equip rods",
      "Can use Taoism Arts, Magic Arts, and Creation Arts",
      "Power of Taoism Arts, Magic skills, and Artificial increases by 50%",
      "「造技」「魔技」「陰陽術」の順にチェーン発動可能",
      "If Kagetsumugi is in the party, abilities increase by 50%",
    ],
    772 => ["Kagetsumugi Doll: Final Form",
      "Can equip Fists and Fangs",
      "Can use Unarmed, Beast Arts, and Creation Arts",
      "Power of Unarmed, Beast skills, and Artificial increases by 75%",
      "SP consumption for Unarmed, Beast Arts, and Creation Arts is increased by 1/3",
      "Unarmed, Beast skills, and Artificial activate twice in a row.",
      "Chain activation possible in the order of Artificial → Unarmed → Beast skills",
      "If Kagetsumugi is in the party, abilities increase by 50%",
    ],
    773 => ["Idaten Soaring monster", #NOTE: Supposed to have innate Agility/Dexterity increase, but isn't present in actor data.
      "Can always equip Katanas. Can always use Sword and Katana",
      "skills, dealing +30% damage with increased priority, and",
      "follow up with Tsubame Gaeshi. 50% of Agility is added to",
      "Katana skill power.",
    ],
    774 => ["Great Ice Snake monster", #NOTE: Overtuned infliction rate on Ice Demon Arts?
      "Deal +50% Ice damage and pierce Ice resistance. Innate Ice",
      "Strike. Can always use Flail and Demon Arts skills, dealing",
      "+30% damage. Ice-element Demon Arts have 33% MP cost and",
      "+750% status infliction rate. Chains Demon Arts skills into",
      "Flail skills. Absorb Ice damage. Immune to Freeze. Instantly",
      "kills Frozen foes at the end of turn.",
    ],
    775 => ["Angel-Hunting Musketeer",
      "Innate Dual Wield. Deals +100% damage to Angels. Can always",
      "equip Guns. Can always use Gun skills, dealing +30% damage",
      "and executing an additional time, but have 133% SP cost.",
    ],
    776 => ["Last Dragon Swordswoman",
      "Can always equip Swords, Knight Sword, Spears, and Heavy",
      "Spears. Can always use Sword, Spear, and Breath skills,",
      "dealing +30% damage. Chains Sword skills into Spear then",
      "Breath skills. Chained skill MP/SP cost is further halved.",
    ],
    777 => ["True Phoenix Soul",
      "Deal +50% Nuclear damage. Fire attacks inflict Nuclear",
      "damage. Can always use Beast, Wing, and Breath skills,",
      "dealing +50% damage, but have 133% SP cost. Three times per",
      "battle, revive when defeated. Immune to Fire and Nuclear",
      "damage and Burn status.",
    ],
    778 => ["Dark Phoenix Soul",
      "Deal +50% Demise damage. Fire attacks inflict Demise damage.",
      "Can always use Beast, Wing, and Breath skills, dealing +50%",
      "damage, but have 133% SP cost. Three times per battle,",
      "revive when defeated. Immune to Fire and Dark damage and Burn",
      "status.",
    ],
    779 => ["Weapon Built by the Dark Goddess",
      "Can always equip Fists and Fangs. Can always used Unarmed,",
      "Beast, Artificial, and Breath skills, dealing +75% damage.",
      "Chains Beast skills into Unarmed then Breath skills, Chained",
      "skill MP/SP cost is further halved.",
    ],
    780 => ["Weapon Built by the Goddess of Creation",
      "Innate Dual Wield. Can always equip Great Swords. Can always",
      "use Sword, Multiweapon, Artificial, and Breath skills,",
      "dealing +75% damage. Chains Sword skills into Multiweapon",
      "then Breath skills. Chained skill MP/SP cost is further",
      "halved.",
    ],
    781 => ["The Great Lord of Terror",
      "Can act twice",
      "Three-Sword Style",
      "Can equip all weapons",
      "Adds Carnage attribute to physical attacks",
      "Carnage attribute attacks deal +100% damage",
      "Can use Sword skills, Bow skills and Multi-Weapon skills",
      "Power of Sword skills, Bow skills, and Multi-Weapon skills increased by 100%",
      "The power of Bow skills depends only on ATK",
    ],
    782 => ["Civilization-Eliminating Weapon",
      "Can act twice",
      "Three-Sword Style",
      "Can equip swords, knight swords, great swords, katanas, ninja swords, staves and scythes",
      "Adds quantum attribute to physical and ice attributes",
      "Power of quantum attribute attacks increased by 100%",
      "Can use Sword skills, Scythe skills, Multi-Weapon skills and Taoism skills",
      "Power of Katana skills, Scythe skills, Multi-Weapon skills, and Taoism skills increased by 100%",
      "Power of Sword skills, Scythe skills and Taoism skills depends solely on ATK",
    ],
    783 => ["Ultimate Intelligence Singularity",
      "Can act twice",
      "Can equip Guns",
      "Power of nuclear heat and ion attribute attacks increased by 100%",
      "Can use Gun skills, Makina and Artificial",
      "Power of Gun skills, Machina, and Artificial increased by 100%",
      "The SP consumption of Gun skills, Makina and Artificial skills will be reduced to 1/10.",
    ],
    784 => ["The one who sinks the world into the sea",
      "Can act twice",
      "Can equip Staves",
      "Add nano attribute to water attribute",
      "Nano attribute attack power increased by 100%",
      "Can use white magic, Black magic and sea skills",
      "Ultimate Power +100% for White Magic, Black Magic, Ocean",
      "The power of white magic and sea skills depends on magical power.",
    ],
    785 => ["Guardian butterfly chrysalis",
      "Able to equip rods",
      "Changes wind, earth and water attributes to chaos attributes",
      "Power +50% for Hadron, Terra, Nano Attribute Attacks",
      "Can use Black magic, insect skills and Nature",
      "Power +50% for Black Magic, Insect skills, Nature",
      "The MP and SP consumption of Black magic, Insect skills and Natural Sense will be reduced to 1/3.",
      "The power of Black magic, insect skills and Nature depends on quickness.",
    ],
    786 => ["Guardian Butterfly",
      "Can act twice",
      "Able to equip rods",
      "Changes wind, earth and water attributes to chaos attributes",
      "Ultimate Power +100% for Hadron, Terra, Nano Attribute Attacks",
      "Can use Black magic, insect skills and Nature",
      "Ultimate Power +100% for Black Magic, Insect skills, Nature",
      "The power of Black magic, insect skills and Nature depends on quickness.",
    ],
    787 => ["Anti-Life Being",
      "Can act twice",
      "Can equip Scalpels",
      "Able to use Medical Arts and Corpse skills",
      "Ultimate Power +100% for Medicine, Corpse skills",
      "Cannot be incapacitated",
    ],
    788 => ["Gestalt Hivemind",
      "Can act twice",
      "Can equip Clubs",
      "Frequently causes confusion with physical attacks",
      "Can use Staff skills, Black magic and Insect skills",
      "The power of Staff skills, Black Magic, and Insect skills is increased by 100%",
      "Power of Staff skills and Black magic depends on DEF",
      "Deals massive damage to confused enemies with Staff skills, Black magic and Insect skills",
    ],
    789 => ["The Original Sin of All Things",
      "Can act twice",
      "Can equip knives",
      "Can use Dagger skills and Magic skills",
      "The power of Dagger skills and Magic skills increases by 100%",
      "At the start of battle, all the powers of the Seven Deadly Sins activate",
    ],
    790 => ["Ultimate Supreme Mage",
      "Can act twice",
      "Can equip staves, rods and magic books",
      "Converts fire, ice and lightning attributes into chaos attributes",
      "Nuclear, Quantum, and Ion attribute attack power increases by 100%",
      "Can use all magic",
      "The power of all magic is increased by 100%",
    ],
    791 => ["The Ancient Seducer",
      "Can act twice",
      "Can equip Flails and lewd tools",
      "Frequently inflicts Temptation status with physical attacks",
      "Able to use Flail skills, Lust skills, Psychic and Serpent skills",
      "The power of Flail skills, Lewd skills, Psycho, and Snake skills is increased by 100%",
      "Deals massive damage to Tempted enemies with Flail skills, Lust skills, Psychic and Serpent skills",
    ],
    792 => ["Cosmic Wave Life",
      "Can act twice",
      "Can equip Spears, Heavy Spears and Fans",
      "Adds Nuclear attribute to Fire attribute",
      "Nuclear heat attribute attack power increased by 100%",
      "Able to use Spear skills, Fan skills, Wing skills and Breath",
      "The power of Spear skills, Fan skills, Wing skills, and Breath is increased by 100%",
      "Even if you become incapacitated, you will be revived with full strength seven times.",
    ],
    793 => ["Interdimensional Invasion Tentacle Colony",
      "Can act twice",
      "Frequently causes Slippery status with physical attacks",
      "Can use Slime skills and Tentacle skills",
      "The power of Slime skills and Tentacle skills is increased by 100%",
      "Deals massive damage to Slippery enemies with Slime skills and Tentacle skills",
      "Ability values do not decrease when using division skills",
    ],
    794 => ["The Unnameable",
      "Can act twice",
      "Adds Galactic attribute to physical attacks",
      "Galactic attribute attack power increases by 100%",
      "Can use Dance, Sing and Tentacle skills",
      "Power of Dance, Sing, and Tentacle skills increases by 100%",
    ],
    795 => ["Interstellar Predator",
      "Can act twice",
      "Can be equipped with fists and clubs",
      "Adds Galactic attribute to physical attacks",
      "Galactic attribute attack power increases by 100%",
      "Can use clinging skills, fighting and giant skills",
      "Power of Staff skills, Unarmed, and Gigantic skills increases by 100%",
      "The power of fighting depends only on ATK",
    ],
    796 => ["Strongest and unprecedented in history",
      "act three times",
      "dual wielding",
      "Can be equipped with swords, knight swords, giant swords, pointed swords, magic swords, spears, heavy spears and swords.",
      "Adds Carnage attribute to physical attacks",
      "Carnage attribute attacks deal +100% damage",
      "Can use sword skills, spear skills, multi-weapon skills and fighting",
      "Power of Sword skills, Spear skills, Multi-Weapon skills, and Unarmed increases by 100%",
    ],
    797 => ["Three fighting gods/chaos",
      "Can act twice",
      "Adds Eternal attribute to Holy attribute",
      "Adds the attribute of Ruin to Dark attribute",
      "Eternal, Demise, and Galactic attribute attack power increases by 100%",
      "Can use Black magic, Time magic, holy skills and dark skills",
      "The power of Black Magic, Time Magic, Holy skills, and Dark skills is increased by 100%",
    ],
    798 => ["Three Fighting Gods/Darkness",
      "Can act twice",
      "Adds Nuclear attribute to Fire attribute",
      "Adds the attribute of Ruin to Dark attribute",
      "The power of Nuclear and demise attributes attacks is increased by 100%",
      "Can use Rapier skills, Black magic, Dark skills and Demon Arts",
      "The power of Rapier skills, Black Magic, Dark skills, and Magic skills is increased by 100%",
      "No MP consumption when using skills belonging to darkness",
    ],
    799 => ["Three Fighting Gods, Light",
      "Can act twice",
      "Adds Ion attribute to Lightning attribute",
      "Adds Eternal attribute to Holy attribute",
      "The power of Ion and Eternal attributes attacks is increased by 100%",
      "Can use Bow skills, White Magic, Holy skills",
      "The power of Bow skills, White Magic, and Holy skills is increased by 100%",
      "No MP cost when using Holy skills",
    ],
    801 => ["Hero of the Dream World",
      "Pleasure damage taken reduced to 75%. Can always equip Swords",
      "and Knight Swords. Can always use Sword and Heroism skills,",
      "dealing +30% damage. Sword skills deal +1% damage for every",
      "% of missing HP. +15% to all stats if Rovissa is in the",
      "main party.",
    ],
    802 => ["Fragment of the Demon Lord",
      "+15% Evasion and Magic Evasion rate. Pleasure damage taken",
      "reduced to 75%. Can always use White Magic, Black Magic,",
      "and Time Magic. Black Magic deals +30% damage. +15% to all",
      "stats if Lars is in the main party.",
    ],
    803 => ["Queen of Dreams",
      "Nightmare attribute. Gets an additional action every turn.",
      "Can always equip Sex Toys. Deals +50% Pleasure damage. Can",
      "always use Sexcraft skills, dealing +30% damage (+100% to",
      "foes afflicted with Sleep or pleasure ailments).",
    ],
    804 => ["Playful Demon of Sadism",
      "Can always equip Bows. Can always use Bow, Summoning, and", 
      "Sexcraft skills. Bow skills have increased priority, can use", 
      "Dexterity in place of Attack, have a 30% chance to inflict",
      "Horny, and inflict +100% damage to foes afflicted with sleep",
      "or pleasure ailments.",
    ],
    805 => ["Dream Demon of Deceitful Love",
      "Can always equip Staves. Can always use White Magic, Black",
      "Magic, and Sexcraft skills. White Magic has increased",
      "priority. White Magic inflicts +100% damage to foes afflicted",
      "with sleep or pleasure ailments. Sexcraft skills can use",
      "Willpower in place of Dexterity.",
    ],
    806 => ["Destructive Demon of Gluttony",
      "Can always equip Fists. Can always use Unarmed and Sexcraft",
      "skills. Unarmed skills deal +50% damage and gain +1% damage",
      "for every % of missing HP, but have 133% SP cost and use",
      "Agility in place of Attack. Unarmed skills inflict +100%",
      "damage to foes afflicted with sleep or pleasure ailments.",
      "Sexcraft skills use the highest of Agility or Dexterity.",
      "+15% to all stats if Myusca is in the main party.",
    ],
    807 => ["Witch's Disciple",
      "+40% Agility. +15% Evasion Rate. Can always equip Rods and",
      "Staves. Can always use White Magic, Black Magic, Summoning,",
      "and Sexcraft skills. White Magic, Black Magic, and Summoning",
      "deal +30% damage and gain +1% damage for every % of ",
      "missing HP.",
    ],
    808 => ["School Dropout",
      "Nightmare attribute. Can always equip Rods and Sex Toys.",
      "+40% Agility. +15% Evasion Rate.",
      "Can always use Sexcraft skills with increased priority.",
      "Targeted 50% as often by enemies.",
    ],
    809 => ["Unshakeable Arrogance",
      "Nightmare attribute. Can always equip Whips and Sex Toys.",
      "Can always use Whip and Sexcraft skills, dealing +50% damage,",
      "but have 133% SP cost. Immune to all status ailments and",
      "Instant KOs. 33% chance of using Overconfidence at the start",
      "of battle.",
    ],
    810 => ["Durable Toy",
      "Can always equip Rods and Magic Swords. Takes 50% less damage",
      "from physical and magic attacks. Can always use White Magic,",
      "Black Magic, Time Magic, and Dark skills, dealing +50% damage",
      "and executing an additional time. Takes five times more",
      "damage from Pleasure attacks, and cannot resist or reflect",
      "them in any way.",
    ],
    811 => ["Apprentice Sorcerer",
      "+40% Agility. +15% Evasion Rate.",
      "Can always use Unarmed skills with increased priority.",
      "At the start of battle, one of the Three Charms will activate",
      "automatically.",
    ],
    812 => ["Leader of Mahoroba",
      "Can always equip Clubs. Can always use Club and Taoism",
      "skills, dealing +50% damage but have 133% SP and MP cost.",
      "Taoism skills use the highest of Attack, Magic or Dexterity.",
    ],
    813 => ["Banquet Lover",
      "Can always equip Fangs, Harps, and Fans.",
      "Can always use Dancing and Singing skills with 50% SP cost,",
      "and Beast skills, which can use Dexterity in place of Attack.",
      "33% chance of using Song of Mahoroba at the start of battle.",
      "Targeted 75% as often by enemies.",
    ],
    814 => ["Contemptuous Youkai Hunter",
      "Can always equip Fists, Rods, and Bows. Can always use Bow,",
      "Unarmed, and Taoism skills, dealing +30% damage.",
      "Deals +50% damage with unique weapon skills. Taoism skills",
      "have a 100% chance to bind and paralyze foes. Bow and Unarmed",
      "skills deal +100% damage to bound or paralyzed foes, and can",
      "use Magic in place of Attack.",
    ],
    815 => ["Spirit of Compassion",
      "75% less likely to be affected by status ailments and",
      "Instant KOs. Can always equip Swords, Knight Swords, Magic",
      "Swords, Rods, and Guns. Can always use Black Magic, Sword, and",
      "Gun Skills, dealing +15% damage. Gun skills deal +100% damage",
      "to foes affected by binds or pleasure ailments. Black Magic",
      "and Sword skills can use Dexterity in place of other stats.",
      "Sword and Gun skills have an 80% chance to inflict Bleed.",
      "200% Recruit rate.",
    ],
    816 => ["Soul Lamp",
      "Immune to Poison, Sleep, Trance, and Seduction.",
      "Can always equip Whips.",
      "Whip and Plant skills deal +15% damage.",
      "Plant skills inflict status ailments 25% more often.",
      "25% chance of using Aroma of Intoxication",
      "at the start of battle.",
    ],
    817 => ["Puppet Body",
      "Innate Bind Strike 30%. Can always equip Katanas. Can always",
      "use Demon Arts, Time Magic, Katana, and Makina skills.",
      "Skills using hair deal +30% damage and have 50% SP cost.",
      "Once per fight, revive with 100% HP when defeated.",
    ],
    818 => ["Courtesan Kitsune",
      "Innate Horny/Trance/Seduction Strike 15%. Can always equip",
      "Magic Swords, Fans, Staves, and Rods. Can use all combat,",
      "magic, and job skills. Magic skills deal +50% damage, but",
      "have 133% MP cost. Sword, Fan, Ninjutsu, Dancing, Singing,",
      "Sexcraft, and Beast skills deal +50% damage, but have 133%",
      "SP cost.",
    ],
    819 => ["Almighty Swordsman",
      "Can always equip Swords and Knight Swords. 30% chance to",
      "parry and use Flash Counter. Can always use Sword and",
      "Heroism skills, dealing +30% damage.",
    ],
    820 => ["Musette's Left Hand",
      "+10% Critical Rate/+25% Critical Damage. Can always equip",
      "Fists. Can always use Unarmed, Sexcraft, and Wing skills,",
      "dealing +15% damage. Unarmed skills have a 30% chance to",
      "inflict Trance, and deal +100% damage to seduced foes.",
      "+15% to all stats if Lyla or Musette are in the main party.",
    ],
    821 => ["Musette's Right Hand",
      "+15% Evasion/Magic Evasion Rate. Can always equip Fists.",
      "Can always use Unarmed, Sexcraft, and Wing skills, dealing.",
      "+15% damage. Unarmed skills have a 30% chance to inflict",
      "Seduction, and deal +100% damage to entranced foes. +15% to",
      "all stats if Bell or Musette are in the main party.",
    ],
    822 => ["White-Winged Demon",
      "Can always equip Rods. Can always use White Magic, Black",
      "Magic, Sexcraft, and Wing skills, dealing +50% damage, but",
      "have 133% MP and SP cost. Black Magic has a 15% chance of",
      "inflicting Horny, Trance, and Seduction, and deals +100%",
      "damage to foes afflicted with Horny, Trance or Seduction.",
      "+15% to all stats if Bell or Lyla are in the main party.",
    ],
    823 => ["Super Novice",
      "Can always equip Swords, Knight Swords, and Great Swords.",
      "Normal attacks hit an extra time. Can always use Sword and",
      "Sexcraft skills. Sword skills deal +30% damage, gaining +1%",
      "damage for every % of missing HP. When below 20% HP, Attack",
      "and Max HP increase by 50% for 6 turns.",
    ],
    824 => ["Comodo Priestess",
      "+15% Evasion/Magic Evasion Rate. Can always equip Fans.",
      "Can always use Fan and Dancing skills with 50% SP cost.",
      "Targeted 50% as often by enemies.",
    ],
    825 => ["Comodo Succubus",
      "Innate Pleasure Strike. +15% Evasion/Magic Evasion Rate.",
      "Can always equip Fans. Can always use Dancing and Sexcraft",
      "skills. Sexcraft skills deal +30% damage. Targeted 50% as",
      "often by enemies.",
    ],
    826 => ["Third Daughter of the Cursed Swords",
      "+40% Agility, +15% Evasion/Magic Evasion Rate. Can always",
      "equip Scythes. Normal attack hits four random foes. Can",
      "always use Scythe skills, dealing +30% damage, and may use",
      "Agility in place of other stats. +15% to all stats for",
      "each other Cursed Sword Sister in the main party.",
    ],
    827 => ["Second Daughter of the Cursed Swords",
      "Can always equip Fists. +15% Critical Rate/+50% Critical",
      "Damage. Innate Stun Strike 30%. Can always use Unarmed",
      "skills, dealing +50% damage, but have 133% SP cost, and can",
      "use Agility in place of Attack. +15% to all stats for each",
      "other Cursed Sword Sister in the main party.",
    ],
    828 => ["First Daughter of the Cursed Swords",
      "Innate Silence/Petrify Strike +15%. Takes 25% less damage",
      "from physical and magic attacks. Can always equip Swords,",
      "Knight Swords, Magic Swords, and Shields. Can always use",
      "Sword, Black Magic, Dark, and Spellblade skills. Sword, Black",
      "Magic, and Dark skills deal +50% damage, but have 133% SP/MP",
      "cost. Sword skills use the highest of Magic or Attack.",
      "+15% to all stats for each other Cursed Sword Sister in the",
      "main party.",
    ],
    829 => ["Natural-born Nightmare",
      "Nightmare attribute. Can always equip Sex Toys.",
      "Can always use Sexcraft skills, dealing +15% damage with",
      "66% SP cost. All stats are doubled for the first turn of",
      "every battle.",
    ],
    830 => ["Natural-born Nightmare",
      "Nightmare attribute. Can always equip Sex Toys.",
      "Can always use Sexcraft skills, dealing +15% damage with",
      "66% SP cost. Follows up Sexcraft skills with Sexy Beam.",
    ],
    831 => ["Demi-Nightmare",
      "Can always equip Sex Toys. Can always use Sexcraft skills,",
      "dealing +15% damage with 66% SP cost. 33% chance to use",
      "Energy Drain at the end of the turn.",
    ],
    832 => ["Plague-Dispersing Prayer",
      "Can always equip Staves and Scalpels. Targeted 50% as often",
      "by enemies. Can always use White Magic, Medicine, Demon",
      "Arts, and Ocean skills. Immune to all status ailments and",
      "Instant KOs. Uses Rain of Life at the end of turn.",
    ],
    833 => ["Plague-Dispersing Prayer: Divine Healing",
      "Can always equip Staves and Scalpels. Recovery Booster 30%.",
      "Can always use White Magic, Medicine, Demon Arts, and",
      "Ocean skills. Immune to all status ailments and Instant KOs.",
      "Uses Rain of Life at the end of turn.",
    ],
    834 => ["All-Devouring Monster Lord",
      "Double action. Immune to Physical damage.",
      "Innate Digestion Strike 30%.",
      "Can always use Dark, Demon Arts, Slime, and Snake",
      "skills, dealing +50% damage but have 133% SP cost.",
    ],
    835 => ["Voracious Monster Noble",
      "Immune to Physical damage",
      "Frequently causes digestion and binding states with physical attacks.",
      "Can use Demon Arts and Slime Arts",
      "The power of Magic skills and Slime skills is increased by 50%",
      "Power of Gluttony activates at the start of battle",
    ],
    836 => ["Jealous Lily",
      "Can use Summoning, Magical Science and Tentacle Arts",
      "The power of Summoning, Magical Science, and Tentacle skills is increased by 50%",
      "Can cause Silence and Confusion with Summoning and Magical Science",
      "Tentacle Arts power depends on Magic instead of Dexterity",
      "Power of Jealousy activates at the start of battle",
    ],
    837 => ["Jealous Lucia",
      "Can use summoning, alchemy and tentacle skills",
      "The power of Summoning, Alchemy, and Tentacle skills is increased by 50%",
      "All abilities increase when using Alchemy",
      "When using alchemy, alchemy materials may not be consumed.",
      "You can often obtain alchemy materials during battles.",
      "Power of Jealousy activates at the start of battle",
    ],
    838 => ["Angry Ox Monster Lord",
      "Can equip Axes and Clubs",
      "Can use axe skills, club skills and giant skills",
      "The power of Axe skills, Staff skills, and Giant skills is increased by 75%",
      "The less HP you have left, the more powerful your Ax skills, Club skills and Giant skills will be.",
      "Power of Wrath is activated at the start of battle.",
    ],
    839 => ["Lust magic monster",
      "Can use Black magic, white magic and Sexcraft skills",
      "The power of Black Magic and White Magic is increased by 50%",
      "Special attack damage with Black magic to sensitive, ecstatic and seduced enemies",
      "Power of Lust is activated at the start of battle.",
    ],
    840 => ["The Vampire Queen of Arrogance",
      "Can use sword skills and Magic skills",
      "Lightning attribute attack power increased by 50%",
      "Sword and magic skills power increased by 50%",
      "At the start of battle, Power of Arrogance is activated",
    ],
    841 => ["The Fifth Law",
      "Can equip staves and rods",
      "Adds Eternal attribute to Holy attribute",
      "Eternal attribute attack power increased by 100% and penetrates enemy resistance",
      "Can use Rod skills, White Magic, Holy skills and Chaos",
      "Staff skills, white magic, holy skills, and chaos power increased by 100%",
      "The power of Rod skills and Chaos depends on Willpower",
      "The power of White Magic and Holy skills depends on ATK",
      "The less HP remaining, the more Rod skills, Holy skills and Chaos are strengthened",
      "Can chain activate in the order of White Magic, Rod skills, Holy skills and Chaos",
      "Ignores time stop",
    ],
    842 => ["The Fifth Law",
      "Can equip staves and rods",
      "Adds Eternal attribute to Holy attribute",
      "Eternal attribute attack power increased by 100% and penetrates enemy resistance",
      "Can use Rod skills, White Magic, Holy skills and Chaos",
      "Staff skills, white magic, holy skills, and chaos power increased by 100%",
      "The power of Rod skills and Chaos depends on Willpower",
      "The power of White Magic and Holy skills depends on ATK",
      "The less HP remaining, the more Rod skills, Holy skills and Chaos are strengthened",
      "Can chain activate in the order of White Magic, Rod skills, Holy skills and Chaos",
      "Ignores time stop",
    ],
    843 => ["Fifth Law - Holy Aberration",
      "Can equip staves and rods",
      "Adds Eternal attribute to Holy attribute",
      "Eternal attribute attack power increased by 100% and penetrates enemy resistance",
      "Can use Rod skills, White Magic, Holy skills and Chaos",
      "Staff skills, white magic, and holy skills power increased by 50%",
      "The MP and SP consumption of Staff skills, White Magic and Holy skills is halved",
      "Staff skills power depends on Willpower",
      "The power of White Magic and Holy skills depends on ATK",
      "The lower the remaining HP, the stronger Staff skills and Holy skills become",
      "Can chain activate in the order of White Magic, Holy skills, Staff skills and Chaos",
    ],
    844 => ["Fifth Law: Dark Aberration",
      "Can equip staves and rods",
      "Adds the attribute of Ruin to Dark attribute",
      "End attribute attack power increased by 100% and penetrates enemy resistance",
      "Able to use Staff skills, Black Magic, Dark Arts, and Chaos.",
      "Staff skills, black magic, and dark skills power increased by 50%",
      "The MP and SP consumption of Staff skills, Black Magic, and Dark skills is halved.",
      "The power of Staff skills and Dark skills depends on Willpower.",
      "The power of Black magic depends on Attack.",
      "The lower the remaining HP, the stronger Staff skills and Dark skills become.",
      "Can chain activate in the order of Black Magic, Staff skills, Dark skills, and Chaos.",
    ],
    845 => ["Fifth Law: Demise Anomaly",
      "Can equip staves and rods",
      "Adds Eternal attribute to Holy attribute",
      "Adds the attribute of Ruin to Dark attribute",
      "Eternal and Demise attribute attacks deal +50% damage and penetrate resistance",
      "Can use Staff skills, White Magic, Black Magic, Holy skills, Dark skills, and Chaos.",
      "Staff skills, white magic, black magic, holy skills, dark skills, and chaos power increased by 100%",
      "The power of Staff skills, Dark skills, and Chaos depends on Willpower.",
      "The power of White Magic, Black Magic, and Holy skills depends on Attack.",
      "The less HP you have left, the stronger your club skills, sacred skills, dark skills, and chaos will be.",
      "Chains can be activated in the order of club skills, holy skills, dark skills and chaos",
    ],
    846 => ["The Master of Masks",
      "Can equip staves and rods",
      "Added eternity/death attribute to holy attribute",
      "Eternal and demise attribute attack power increased by 100% and penetrates enemy resistance",
      "Can use Rod skills, White Magic, Holy skills and Chaos",
      "Staff skills, white magic, holy skills, and chaos power increased by 100%",
      "MP and SP consumption for club skills, white magic, sacred skills and chaos increases by 1/3.",
      "The power of Rod skills and Chaos depends on Willpower",
      "The power of White Magic and Holy skills depends on ATK",
      "The less HP remaining, the more Rod skills, Holy skills and Chaos are strengthened",
      "Can chain activate in the order of White Magic, Rod skills, Holy skills and Chaos",
      "Ignores time stop",
    ],
    848 => ["Throne of Judgment",
      "Frequently restrained with physical attacks",
      "Can use Holy skills and Tentacle skills",
      "Power of Holy skills and Tentacle skills increases by 30%",
      "It is possible to chain activate Holy skills from Tentacle skills.",
      "Adds half of her Dexterity to the power of Holy skills",
      "Deals massive critical damage to restrained enemies with Holy skills or Tentacle skills.",
      "Halves Holy attribute damage and reduces Eternal attribute damage.",
    ],
    849 => ["Zombie Ghost Complex",
      "Can be equipped with rod and sickle",
      "Can use Sickle skills and Corpse skills",
      "Sickle skills and Corpse skills are activated twice in a row.",
      "MP and SP consumption for Sickle skills and Corpse skills increase by 1/3.",
      "Can chain activate Scythe skills after Corpse skills.",
      "Halves dark attribute damage and reduces apocalypse attribute damage.",
    ],
    850 => ["Childish Tentacle Girl",
      "Can use Dagger skills, Black magic and Tentacle skills",
      "Dagger skills, black magic, and tentacle skills power increased by 30%",
      "SP consumption for Dagger skills and Tentacle skills will be reduced to 2/3",
      "Black magic consumes 2/3 MP",
      "Allows chain activation from Tentacle skills to Dagger skills and Black Magic.",
      "The power of Dagger skills and Black Magic depends on Dexterity.",
      "Deals massive damage to restrained enemies with Dagger skills and Black Magic",
    ],
    851 => ["Laughing Eroding Angel",
      "Can always equip Spears and Heavy Spears",
      "Can use Spear skills, Holy skills and Slime skills",
      "The SP consumption of Spear skills, Holy skills, and Slime skills increases by 1/3",
      "Spear skills, Holy skills, and Slime skills activate consecutively three times.",
      "The power of Spear skills and Slime skills depends on mental strength.",
    ],
    852 => ["The Magic Gun Executioner",
      "Can equip Guns",
      "Can use Gun skills and Artificial",
      "The power of Gun skills and Creation skills increases by 50% and activates with resilience",
      "SP consumption for Gun skills and Creation skills is halved.",
      "Can chain activate Gun skills from Artificial",
      "If Elgemini is in the party, abilities increase.",
      "Nullifies physical attributes and halves Carnage attributes.",
    ],
    853 => ["Magic Saw Executioner",
      "Can equip Great Swords",
      "Can use Sword skills and Artificial",
      "The power of Sword skills and Creation skills increases by 50% and activates with resilience.",
      "SP consumption for Sword skills and Creation skills is halved.",
      "Can chain Sword skills after Artificial",
      "Increases abilities when Argemini is in the party",
      "Nullifies physical attributes and halves Carnage attributes.",
    ],
    854 => ["Chaos Guard",
      "Can always equip Spears and Heavy Spears",
      "HP/SP gradually recovers",
      "Can use Spear skills, Holy skills and Artificial",
      "Power of Spear skills, Holy skills, and Artificial increased by 30%",
      "SP consumption for Spear Arts, Holy Arts, and Creation Arts is halved",
      "Holy Arts, Creation Arts, and Spear Arts can chain activate in order",
      "Adds half of agility to the power of Holy Arts and Creation Arts",
      "Deals massive critical damage to stigmatized enemies with Creation Arts and Spear Arts",
      "Halves Holy and Dark attributes, and reduces Eternal and Carnage attributes.",
    ],
    855 => ["Proliferation techno ogre",
      "Increases maximum HP by 30%",
      "Can equip Guns",
      "HP/SP gradually recovers",
      "Can use Gun skills, Makina and Artificial",
      "The power of Gun skills, Machina, and Artificial increases by 50%",
      "SP consumption for Gun Arts, Machina, and Creation Arts is halved",
      "Chain activation is possible in the order of Artificial, Machina and Gun skills",
    ],
    856 => ["Star Takers",
      "The power of Galaxy attribute attacks increases by 50%",
      "Time magic and Psychic can be used",
      "Power of Time Magic and Psycho increased by 30%",
      "Adds Galaxy attribute to Time Magic and Psycho",
      "The MP consumption of Time magic and Psychic is reduced to 2/3.",
      "Can activate Psychic chain from Time Magic",
      "Sun Sphere triggers as a counter",
      "Absorbs Galactic attribute",
    ],
    857 => ["destroyer of the earth",
      "Critical Rate and Critical Damage increase by 50%",
      "Counter rate increases by 50%",
      "Counter ATK increases by 5 levels",
      "Can be equipped with fists, axes and clubs",
      "Can use club skills, axe skills and fighting",
      "The power of Staff skills, Axe skills, and Martial Arts increases by 50%",
      "SP consumption for club skills, axe skills and fighting will be reduced to 2/3",
      "Chain activation possible in the order of Staff skills, Axe skills and Unarmed",
      "Unarmed skills power depends solely on ATK",
      "Absorbs Terra attribute",
    ],
    858 => ["Otherworldly Plant Erodent",
      "Can equip Whips and Staffs",
      "Can use Whip skills, White Magic and Plant skills",
      "Power of Whip skills, White Magic, and Plant skills increased by 30%",
      "MP and SP consumption of Whip skills, White Magic and Plant skills is reduced to 2/3",
      "White Magic, Whip skills, and Plant skills can chain activate in order",
      "All Mega Heal has a chance to activate as a counter",
    ],
    859 => ["Otherworldly Slime Invasion Body",
      "Can equip staves and boomerangs",
      "Can use Throwing skills, White Magic, and Slime skills",
      "Throwing skills, White Magic, and Slime skills power increases by 30%",
      "MP and SP consumption for Throwing skills, White Magic, and Slime skills is reduced to 2/3",
      "Can chain activate in the order of Slime skills, Throwing skills, and White Magic",
      "Deals massive critical damage to Slippery enemies with Throwing skills and White Magic",
      "All Mega Heal has a chance to activate as a counter",
    ],
    860 => ["Lord of corrosive mucus",
      "Can equip fans",
      "Can use Fan skills, dance and mucus skills",
      "Power of Fan skills, Dance, and Slime skills increased by 30%",
      "The SP consumption of Fan skills, Dancing and Mucus skills will be reduced to 2/3.",
      "Slime skills activate instantly",
      "Can chain activate in the order of Slime skills, Fan skills, and Dance",
      "Deals massive critical damage to Slippery enemies with Fan skills and Dance",
      "Nullifies Nano attribute",
    ],
    861 => ["Civilization Storage System",
      "Frequently inflicts bind status with physical attacks",
      "Gun skills and Makina can be used",
      "Power of Gun skills and Machina increased by 30%",
      "SP consumption for Gun skills and Makina is reduced to 2/3",
      "Machina activates consecutively twice",
      "Can chain activate Gun skills from Machina",
      "Deals massive critical damage to restrained enemies with Gun skills and Machina",
    ],
    862 => ["High Performance Flying Combatant",
      "Increases speed by 30%",
      "Can always equip Spears and Heavy Spears",
      "Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Can use Spear skills, Wing skills, and Artificial skills",
      "The power of Spear skills, Wing skills, and Artificial skills is increased and activates instantly",
      "SP consumption for Spear skills, Wing skills, and Artificial skills is reduced to 2/3",
      "Can chain activate in the order of Wing skills, Artificial skills, and Spear skills",
      "Adds half of speed to the power of Artificial skills",
    ],
    863 => ["Corrosive Chaos Angel",
      "Can use Holy skills and Dark skills",
      "The power of Holy skills and Dark skills increases by 75%.",
      "MP and SP consumption for Sacred skills and Dark skills increases by 1/3.",
      "Chains can be triggered in the order of Holy Technique, Dark Technique, and Holy Technique.",
      "The power of Dark skills depends on mental strength.",
      "Reduces Chaos damage.",
    ],
    864 => ["Giant life form from another world",
      "Increases maximum HP by 30%",
      "Can use tentacle skills and giant skills",
      "The power of Tentacle skills and Massive skills increases by 50% and activates robustly.",
      "The SP consumption of Tentacle skills and Giant skills increases by 1/3",
      "Massive skills activate twice in succession.",
      "Chain activation from Tentacle skills to Giant skills possible",
      "The power of Massive skills depends on dexterity.",
      "Deals massive critical damage with Massive skills to enemies in Slippery or Bound states.",
    ],
    865 => ["Otherworldly Gun God",
      "Can equip Guns",
      "Allows triple-wielding, and equipment effects are greatly enhanced during triple-wielding.",
      "Can use Gun skills",
      "Gun skills activate four times in succession.",
      "Gun skills SP consumption is doubled",
    ],
    866 => ["Otherworldly Assassin",
      "Can always equip Ninja Swords",
      "Dual wielding enabled, and equipment effects during dual wielding are greatly enhanced",
      "Completely evade physical attacks, and universal evasion rate increases by 30%",
      "Frequently cause instant death with physical attacks",
      "Adds the Feral attribute to physical attacks",
      "Can use Dagger skills and Ninjutsu",
      "Power of Dagger skills and Ninjutsu increased by 30%",
      "Dagger skills and Ninjutsu SP consumption is reduced to 2/3",
      "Increases the hit count of Dagger skills and Ninjutsu multi-hit skills by 2",
      "Chain activation possible from Dagger skills to Ninjutsu",
    ],
    867 => ["Unknown 1",
      "Gradually restores HP",
      "Can use Bow skills and Insect skills",
      "Enhances the power of Bow skills and Insect skills and activates Fortitude",
      "SP consumption for Bow skills is reduced to 2/3",
      "Allows chain activation from Insect skills to Bow skills",
      "Allows activation of monster skills without consuming MP or SP",
    ],
    868 => ["Unknown 2",
      "Gradually restores HP",
      "Can use Whip skills and Tentacle skills",
      "The power of Whip skills and Tentacle skills increases by 30%, and they activate with fortitude.",
      "The SP consumption for Whip skills is reduced to 2/3.",
      "Tentacle skills can be chain-activated from Whip skills.",
      "Allows activation of monster skills without consuming MP or SP",
    ],
    869 => ["Unknown 3",
      "Gradually restores HP",
      "Able to use Unarmed and Tentacle skills",
      "The power of Martial Arts and Tentacle skills increases by 30%, and they activate with fortitude.",
      "Unarmed skills have 2/3 SP cost",
      "Can chain activate Unarmed from Tentacle skills",
      "Allows activation of monster skills without consuming MP or SP",
    ],
    870 => ["Unknown 4",
      "Gradually restores HP",
      "Can use white magic and plant skills",
      "The power of White Magic and Plant skills increases by 30%, and they activate with fortitude.",
      "White Magic can be chain-activated from Plant skills.",
      "White Magic and monster skills can be activated without consuming MP or SP.",
    ],
    871 => ["Unknown 5",
      "Max HP increases by 50%, ATK increases by 30%",
      "Gradually restores HP",
      "Can use tentacle skills and giant skills",
      "The power of Tentacle skills and Gigantic skills increases by 75% and activates Sturdy",
      "Chain activation from Tentacle skills to Giant skills possible",
      "Allows activation of monster skills without consuming MP or SP",
    ],
    872 => ["Banshee returns",
      "Can equip Staves",
      "The power of Nano and Sonic attribute attacks increases by 50%",
      "Can use white magic, Black magic, Time magic and marine skills",
      "The power of White Magic, Black Magic, Time Magic, and Sea skills increases by 50%",
      "Chains can be activated in the order of Time Magic, White Magic or Black Magic, and Sea skills",
      "Deals massive critical damage to enemies in Slow or Stop status with White Magic, Black Magic, or Sea skills",
      "Frequently skips time and negates attacks",
      "Reflects Nano attribute",
    ],
    873 => ["Banshees of Greed",
      "The power of Nano attribute attacks increases by 50%",
      "Can use white magic, Black magic, Time magic and marine skills",
      "The power of White Magic, Black Magic, Time Magic, and Sea skills increases by 50%",
      "Chains can be activated in the order of Time Magic, White Magic or Black Magic, and Sea skills",
      "Adds Slow and Stop effects to White Magic, Black Magic, Time Magic, and Sea skills",
      "Frequently skips time and negates attacks",
      "At the end of the turn, frequently activates Slow and Stop predation skills.",
      "Reflects Nano attribute",
    ],
    874 => ["Fiendish Bird of Another World",
      "Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Hadron attribute attack power increases by 50%",
      "Can always equip Spears and Heavy Spears",
      "Can use Spear skills and Wing skills",
      "The power of Spear skills and Wing skills increases by 50%",
      "It is possible to chain spear skills from wing skills",
      "Absorbs Wind and Hadron attributes",
    ],
    875 => ["Fiendish Flower Blooming in Another World",
      "Can always equip Whips",
      "Can use Whip skills and Plant skills",
      "The power of Whip skills and Plant skills increases by 50%",
      "SP consumption for Whip skills and Plant skills is reduced to 1/3",
      "Chain activation from Plant skills to Whip skills possible",
      "Deals massive critical damage to enemies in Bind or Pleasure status with Plant skills or Whip skills",
      "Cures allies with status ailments at the end of the turn",
    ],
    876 => ["Weaving God of Another World",
      "Can equip Harps",
      "Can use Sing and Corpse skillss",
      "The power of Singing and Corpse skills increases by 50% and activates sturdily.",
      "Sing and Corpse skillss SP consumption reduced to 2/3",
      "Can chain activate Corpse skillss from Sing",
      "At the start of battle, protects all allies from status ailments.",
      "Absorbs Dark attribute and halves Apocalypse attribute.",
    ],
    877 => ["Otherworldly False Demon",
      "Able to equip rods",
      "Increased power of White Magic, Black magic, Time magic and Sea skills",
      "The power of Taoism Arts and Plant skills increases by 50%.",
      "Reduces MP and SP consumption of Taoism and Plant skills to 2/3",
      "Allows chain activation from Taoism to Plant skills",
      "Deals massive critical damage with Plant skills to enemies in an attribute-weakened state.",
      "The power of Plant skills depends on magic power.",
      "Randomly increases the number of actions.",
    ],
    878 => ["Shared consciousness alpha",
      "Can equip staves and Flails",
      "May inflict Confusion or Sleep status with physical attacks.",
      "Can use Staff skills, Flail skills and Insect skills",
      "The power of Staff skills, Flail skills, and Insect skills increases by 50% and activates sturdily.",
      "Chain activation possible in the order of Staff skills, Flail skills, and Insect skills.",
      "Deals massive critical damage to enemies in Confusion or Sleep status using Staff skills, Flail skills, or Insect skills.",
      "Nullifies Physical and Pleasure attributes, and halves Shura and Nightmare attributes.",
    ],
    879 => ["Shared Consciousness β",
      "Can equip bows",
      "May inflict Confusion, Sleep, or Digestion status with physical attacks.",
      "Can use Bow skills and Insect skills",
      "The power of Bow skills and Insect skills is greatly increased, and Sturdy activates.",
      "Allows chain activation from Insect skills to Bow skills",
      "Deals massive critical damage to enemies in Confusion, Sleep, or Digestion status using Bow skills or Insect skills.",
      "Frequently activates Confusion, Sleep, and Predation skills at the end of the turn.",
      "Nullifies Physical and Pleasure attributes, and halves Shura and Nightmare attributes.",
    ],
    880 => ["Gluttonous Mature Snake",
      "Can equip Flails",
      "May inflict Bind or Temptation status with physical attacks",
      "Can use Flail skills and Snake skills",
      "The power of Flail skills and Snake skills increases by 50%",
      "Allows chaining Flail skills after Snake skills",
      "Deals massive critical damage to enemies in Bind or Temptation status with Flail skills and Snake skills",
      "The power of single-hit skills (attacks that hit only once) increases by 50%",
      "Frequently activates predation skills at the Demise of the turn",
    ],
    881 => ["Otherworld monster",
      "The power of Hadron and Nightmare attribute attacks increases by 50%",
      "Can use Psychic and Magic skills",
      "Power of Psycho and Magic skills increased by 30%",
      "The MP and SP consumption of Psycho and Magic skills is halved",
      "Adds Hadron and Nightmare attributes to Psycho and Magic skills",
      "It is possible to chain Magic from Psychic",
      "Deals massive critical damage to enemies with Pleasure status ailments using Psycho and Magic skills",
      "Halves damage from Hadron and Nightmare attributes",
    ],
    882 => ["Otherworldly Dragon Princess",
      "Increases maximum HP by 30%",
      "Can equip Rapiers",
      "Adds nuclear heat attribute to physical attacks",
      "Power of nuclear heat attribute attacks increased by 50%",
      "Can use Rapier skills and Breath",
      "The power of Piercing Sword skills and Breath increases by 50%",
      "Breath, Breath, and Piercing Sword skills can be chain-activated in sequence",
      "The power of Piercing Sword skills and Breath depends solely on agility",
      "Deals massive critical damage to enemies in Burn status with Piercing Sword skills and Breath",
      "Reflects nuclear heat attribute",
    ],
    883 => ["Otherworldly Paizuri Doll",
      "Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Can use Holy skills, Lust skills and Artificial",
      "Significantly increases the power of skills using breasts",
      "Activates a skill using breasts four times in a row",
      "skills using breasts do not consume SP",
      "Deals massive critical damage with Erotic skills to sensitive or ecstatic enemies",
    ],
    884 => ["Otherworldly Iron Maiden",
      "Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Frequently restrained with physical attacks",
      "Can always use Holy and Corpse skills.",
      "The power of Holy skills and Corpse skills is increased by 50%",
      "Allows chaining Holy skills after Corpse skills",
      "Deals massive critical damage with Holy skills to restrained enemies",
      "Activates a restraining skill as a counter",
    ],
    885 => ["Otherworld doll",
      "Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Can equip fans",
      "You can use Taoism, Dance and Artificial skills.",
      "The power of Taoism, Dance, and Artificial skills increases by 50%.",
      "The MP and SP consumption of Taoism, Dance, and Artificial skills is halved.",
      "Chain activation is possible in the order of Dance, Taoism, and Artificial skills.",
      "Removes enemy buffs at the end of the turn",
    ],
    886 => ["Demon Eye of the Otherworld",
      "Can use Magic skills",
      "Magic Arts activate robustly",
      "Power of Magic Eye skills increases by 50%",
      "Magic eye skills MP consumption becomes 1/10",
      "Significantly increased incidence of evil eye condition",
      "Chain can be activated in the order of Magic skills, Magic skills and Magic skills",
    ],
    887 => ["Otherworld angel complex",
      "Increases maximum HP by 30%",
      "Can equip Fists",
      "Fighting and Sacred skills can be used",
      "The power of Martial Arts and Holy skills increases by 50%",
      "MP and SP consumption for fighting and holy skills are reduced to 2/3",
      "Adds half of mental power to the power of fighting",
      "Martial Arts and Holy skills activate twice in a row",
      "Can chain Martial Arts after using Holy skills",
      "Deals massive critical damage with Martial Arts to enemies in Stigmatized state",
      "Absorbs Eternal attribute",
    ],
    888 => ["Keeper of Knowledge",
      "Able to equip rods",
      "The power of Nuclear, Quantum, and Ion attribute attacks increases by 50%",
      "Able to use Black magic",
      "The power of Black Magic increases by 50%",
      "Reduces MP consumption of Black magic by half",
      "Black Magic activates three times in a row",
      "Deals massive critical damage with Black Magic to enemies in Burn, Freeze, or Shock states",
    ],
    889 => ["Observer of Knowledge",
      "Able to equip rods",
      "The power of Galaxy attribute attacks increases by 50%",
      "Can use Time magic",
      "Power of Time Magic increases by 50%",
      "Reduces MP consumption of Time magic by half",
      "Time Magic activates three times in a row",
      "Deals massive damage to enemies in Slow or Stop status with Time Magic.",
    ],
    890 => ["White Nine-Tails of the Otherworld",
      "Can equip ninja swords and rods",
      "Terra・Eternal attribute attack power increases by 50%",
      "Allows use of Holy Arts, Taoism, Ninjutsu, and Beast Arts",
      "The power of Holy Arts, Taoism, Ninjutsu, and Beast Arts increases by 50%",
      "The MP and SP consumption of Holy Arts, Taoism, Ninjutsu, and Beast Arts is halved",
      "Chain activation possible in the order of Holy Arts, Beast Arts, and Taoism or Ninjutsu",
      "Deals massive critical damage to stigmatized enemies with Taoism, Ninjutsu, or Beast Arts",
      "Absorbs Eternal attribute",
    ],
    891 => ["Otherworldly Spider Nun",
      "Can equip ninja swords and staffs",
      "The power of Galaxy attribute attacks increases by 50%",
      "Can use White Magic, Time magic, Ninjutsu and Insect Arts",
      "The power of White Magic, Time Magic, Ninjutsu, and Insect Arts increases by 50% and activates sturdily",
      "The MP and SP consumption of White Magic, Time Magic, Ninjutsu, and Insect Arts is halved",
      "White Magic and Ninjutsu gain a Galactic attribute",
      "Chain activation possible in the order of Time Magic, White Magic or Ninjutsu, and Insect Arts",
      "Deals massive damage to enemies in Slow or Stop status with Time Magic, Ninjutsu, or Insect Arts.",
      "Reflects Galactic attribute.",
    ],
    892 => ["Serviceborne",
      "Can always equip Spears and Heavy Spears",
      "Can use Spear skills, Service, and Tentacle skills",
      "The power of Spear skills, Service, and Tentacle skills increases by 50%",
      "The SP consumption of Spear skills, Service, and Tentacle skills becomes 2/3",
      "The power of Service and Tentacle skills depends on agility",
      "Can chain activate in the order of Tentacle skills, Service, and Spear skills",
      "Deals massive damage to restrained enemies with Service and Spear skills",
      "Nullifies Nano attribute and reduces End attribute damage",
    ],
    893 => ["Forsaken Spawn",
      "Can equip staves and Flails",
      "Can use club skills, ​​Flail skills, ​​ and tentacle skills.",
      "The power of Staff skills, Flail skills, and Tentacle skills increases by 50%",
      "SP consumption for club skills, ​​Flail skills, ​​ and tentacle skills will be reduced to 2/3.",
      "Chain activation possible in the order of Tentacle skills, Staff skills, Flail skills",
      "Deals massive damage to restrained enemies with Staff skills and Flail skills",
      "The power of multi-hit skills (with multiple attack judgments) increases by 50%",
      "Absorbs Nano attribute and halves Apocalypse attribute",
    ],
    894 => ["Tentacle Kin",
      "Can always equip Whips",
      "Frequently restrained with physical attacks",
      "Can use Whip skills, Slime skills and Tentacle skills",
      "The power of Whip skills, Slime skills, and Tentacle skills increases by 50%",
      "Increases the hit count of Tentacle skills combo attacks by 2",
      "Allows chain activation in the order of Tentacle skills, Slime skills, and Whip skills",
      "Deals massive critical damage to restrained enemies with Whip skills, Slime skills, or Tentacle skills",
      "Frequently activates Slippery and Restraint Predation skills at the end of the turn",
      "Nullifies Carnage attributes.",
    ],
    895 => ["Mucous Membrane Minion",
      "Can equip Clubs",
      "Frequently inflicts Slimed with physical attacks",
      "Can use Staff skills, Slime skills and Tentacle skills",
      "The power of Staff skills, Slime skills, and Tentacle skills increases by 50%",
      "Chain activation possible in the order of Slime skills, Tentacle skills, and Staff skills.",
      "Deals massive critical damage to slimy enemies with Staff skills, Slime skills, and Tentacle skills.",
      "Frequently activates Slippery and Restraint Predation skills at the end of the turn",
      "Nullifies Carnage attributes.",
    ],
    896 => ["The descendant of dissolution",
      "Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Can equip bows",
      "Frequently inflicts slimy and digestion states with physical attacks.",
      "Can use bow skills, mucus skills and tentacle skills",
      "The power of Bow skills, Slime skills, and Tentacle skills increases by 50%",
      "Chain activation possible in the order of Slime skills, Tentacle skills, and Bow skills.",
      "Deals critical damage to slimy or digestion-state enemies with Bow skills, Slime skills, and Tentacle skills.",
      "Activates a devour skill when evading.",
      "Frequently activates Slippery and Restraint Predation skills at the end of the turn",
      "Nullifies Carnage attributes.",
    ],
    897 => ["Servant emerging from the darkness.",
      "Max HP increases by 50%, and ATK increases by 30%.",
      "Frequently inflicts darkness, silence, and stun states with physical attacks.",
      "Can use mucus skills, tentacle skills and giant skills",
      "The power of Slime skills, Tentacle skills, and Giant skills increases by 75% and activates robustly.",
      "The SP consumption of Mucus skills, Tentacle skills and Giant skills increases by 1/3.",
      "Slime skills, Tentacle skills, and Giant skills can chain activate in order.",
      "Deals massive damage with Giant skills as a special attack against enemies in Bound, Slippery, Blind, Silence, or Stun states.",
      "The power of Slime skills and Tentacle skills depends on ATK.",
      "Activates devour skills as a counter.",
      "Frequently activates Blind, Silence, and Stun devour skills at the end of the turn.",
      "Nullifies Carnage attributes.",
    ],
    898 => ["Null Kin Blue",
      "Can always equip Whips",
      "Adds quantum attribute to physical attacks.",
      "The power of quantum attribute attacks increases by 50%.",
      "Can use Whip skills and Tentacle skills",
      "The power of Whip skills and Tentacle skills increases by 50%.",
      "The SP consumption of Whip skills and Tentacle skills becomes 2/3",
      "Adds freeze effect to Whip skills",
      "Tentacle skills can be chain-activated from Whip skills.",
      "Tentacle skills deal special attack damage to frozen enemies",
      "Abilities increase if Nullco・Nulls kin are in the party",
      "Absorbs quantum attribute",
    ],
    899 => ["Null Kin Red",
      "Can equip Fists",
      "Adds nuclear heat attribute to physical attacks",
      "Power of nuclear heat attribute attacks increased by 50%",
      "Able to use Unarmed and Tentacle skills",
      "The power of Martial Arts and Tentacle skills increases by 50%",
      "The SP consumption of Unarmed and Tentacle skills becomes 2/3",
      "Adds burn effect to Martial Arts",
      "The power of Unarmed depends on Dexterity instead of Agility",
      "Allows chain activation from Martial Arts to Tentacle skills",
      "Tentacle skills deal special attack damage to burned enemies",
      "Abilities increase if Nullco・Nulls kin are in the party",
      "Absorbs thermal nuclear attribute",
    ],
    900 => ["Null Kin Yellow",
      "Can equip Guns",
      "Adds ion attribute to physical attacks",
      "The power of Ion attribute attacks increases by 50%.",
      "Can use Gun skills and Tentacle skills",
      "The power of Gun skills and Tentacle skills is increased by 50%",
      "SP consumption of Gun skills and Tentacle skills is reduced to 2/3",
      "Adds Shock effect to Gun skills",
      "Allows chain activation of Tentacle skills from Gun skills",
      "Tentacle skills deal critical damage to enemies in Shock state",
      "Abilities increase if Nullco・Nulls kin are in the party",
      "Absorbs Ion attribute",
    ],
    901 => ["Null Kin μ",
      "Can equip Magic Books",
      "Can use Magical Science and Tentacle skills",
      "The power of Magical Science and Tentacle skills increases by 50%",
      "Magical Science and Tentacle skills consume half SP",
      "Chain activation from Magical Science to Tentacle skills is possible",
      "Adds half of magic power to the power of Tentacle skills",
      "Tentacle skills deal critical damage to enemies in Burn, Freeze, or Shock status",
      "Abilities increase if Nullco・Nulls kin are in the party",
      "Reduces Chaos attribute damage",
    ],
    902 => ["Null Kin Q",
      "Maximum HP increases by 50%",
      "Can use tentacle skills and giant skills",
      "The power of Tentacle skills and Gigantic skills increases by 75%",
      "Chain activation from Tentacle skills to Giant skills possible",
      "Adds dexterity to the power of Gigantic skills",
      "Deals critical damage with Colossal Technique to enemies in Bound or Slippery state.",
      "Abilities increase if Nullco・Nulls kin are in the party",
      "Nullifies Carnage attributes.",
    ],
    903 => ["Otherworldly Time Spider",
      "Able to equip rods",
      "The power of Galaxy attribute attacks increases by 50%",
      "Can use Time magic and Insect skills",
      "The power of Time Magic and Insect skills increases by 50%",
      "Time Magic and Insect skills gain the Galaxy attribute",
      "Can chain activate Insect skills from Time magic",
      "Special attack damage with Insect skills on enemies in Slow or Stop state",
    ],
    904 => ["Otherworldly ????",
      "Can equip Kitchen Knives",
      "Exceptionally high aptitude for equipping knives",
      "The power of Dagger skills and Rapier skills increases by 50%",
      "Dagger skills, Rapier skills, and Sorcery activate robustly",
      "The power of Sorcery Cleaver increases by 75%",
      "Rapier skills, Dagger skills, and Sorcery can chain activate in order",
      "Deals massive special attack damage with Dagger skills and Rapier skills to enemies with any status ailment",
      "Activates Cleaver as a counter",
    ],
    905 => ["War God from Another World",
      "Can equip Swords, Knight Swords, Spears, Heavy Spears and Bows",
      "Allows triple wielding, and the equipment effects during triple wielding increase by 50%",
      "Can use Sword skills and Multi-Weapon skills",
      "Sword skills and Multi-Weapon skills activate three times in succession",
      "SP consumption for sword skills and multi-weapon skills increases by 1/3",
      "It is possible to chain multi-weapon skills from sword skills.",
    ],
    906 => ["Queen of another world",
      "Max HP and ATK increase by 30%",
      "Can equip Fists",
      "Adds Carnage attributes to physical attacks.",
      "The power of Carnage attribute attacks increases by 50%.",
      "Enables the use of Martial Arts, Insect skills, and Giant skills",
      "The power of Martial Arts, Insect skills, and Giant skills increases by 50% and triggers Tenacity",
      "SP consumption for Martial Arts, Insect skills, and Giant skills increases by 1/3",
      "Allows chain activation in the order of Insect skills, Martial Arts, and Giant skills",
      "The power of single-hit skills (skills with only one attack judgment) increases by 75%",
      "Greatly reduces Carnage attributes.",
    ],
    907 => ["Nine Tails of Machine World",
      "Can always equip Ninja Swords",
      "Dual wielding is possible, and equipment effects during dual wielding are greatly increased",
      "Adds Terra attribute to physical attacks",
      "Increases the power of Terra attribute attacks by 50%",
      "Able to use 'Taoism,' 'Ninjutsu,' and Artificial skills'",
      "Greatly increases the power of Taoism, Ninjutsu, and Artificial skills, and ensures sturdy activation",
      "Chains can be activated in the order of Taoism, Ninjutsu and Zoujutsu",
      "Deals massive damage to enemies in Burn or attribute weakened states with Ninjutsu and Artificial skills",
      "Reflects Terra attribute",
    ],
    908 => ["Corrupted Doll from Another World",
      "Able to equip rods",
      "Adds Galaxy attribute to physical attacks and Holy attribute",
      "The power of Galaxy attribute attacks increases by 50%",
      "Can use White Magic, Holy skills and Artificial",
      "White Magic, Holy skills, and Artificial skills power increased by 30% and activates robustly",
      "Chain activation possible in the order of White Magic, Holy skills, Artificial",
      "Deals massive bonus damage to enemies with Stigmata using White Magic, Holy Arts, or Artificial Arts.",
      "Activates a Stigmata-inflicting skill as a counter.",
      "Absorbs Galactic attribute",
    ],
    909 => ["Hero from Another World",
      "Can equip Swords and Knight Swords",
      "Adds Carnage attributes to physical attacks.",
      "The power of Carnage attribute attacks increases by 50%.",
      "Can use Sword skills, Hero skills and Insect skills",
      "The power of Sword skills, Hero skills, and Insect skills increases by 50%",
      "Chain activation possible in the order of Insect skills, Sword skills and Hero skills",
      "Increases the hit count of Sword Arts and Hero Arts multi-hit skills by 2.",
    ],
    910 => ["Holy War Chariot from Another World",
      "Increases maximum HP by 30%",
      "Can equip Fists",
      "Adds Eternal attribute to physical attacks, bypassing resistances.",
      "Eternal attribute attack power increases by 50%.",
      "Can use Unarmed, Holy skills and Artificial",
      "The power of Unarmed, Holy skills, and Artificial increases by 50%",
      "Holy Arts, Artificial Arts, and Martial Arts activate twice consecutively.",
      "Chain activation possible in the order of Holy skills, Artificial and Unarmed",
      "Deals massive bonus damage to enemies with Stigmata using Artificial Arts or Martial Arts.",
      "Reflects Eternal attribute attacks.",
    ],
    911 => ["Otherworldly Void Water",
      "Able to equip rods",
      "Adds Nano attribute to Water attribute, bypassing resistances.",
      "The power of Nano attribute attacks increases by 50%",
      "Can use Black magic and Slime skills",
      "The power of Black Magic and Slime skills increases by 50%",
      "Chain activation possible in the order of Slime skills, Slime skills, and Black Magic.",
      "Adds DEF to the power of Black Magic.",
      "Deal critical damage to slippery enemies with Black magic",
      "Absolutely reflects physical and magical attacks, with a low chance to reflect Auto-Hits.",
    ],
    912 => ["Queen of Dreams",
      "Can be equipped with Rapiers and lewd tools",
      "Adds Nightmare attribute to physical attacks, penetrating resistances.",
      "Frequently inflicts Sleep and Pleasure status ailments with physical attacks.",
      "The power of Nightmare attribute attacks is increased by 50%.",
      "Allows the use of Piercing Sword skills, Lust skills, Magic skills, and Psycho.",
      "The power of Piercing Sword skills, Lust skills, Magic skills, and Psycho is increased by 50%.",
      "Chain activation possible in the order of Lust skills, Psycho, Magic skills, and Piercing Sword skills.",
      "Adds half of her Dexterity to the power of Magic skills and Piercing Sword skills",
      "Deals massive critical damage with Piercing Sword skills and Magic skills to enemies in Sleep or Pleasure status ailments",
      "Absorbs Nightmare attribute",
    ],
    913 => ["Subspace levitator",
      "Increases maximum HP by 30%",
      "Able to equip rods",
      "Adds Gravity and Galaxy attributes to physical attacks, Time Magic, and Magic skills",
      "The power of Gravity and Galaxy attribute attacks increases by 50%",
      "Can use Time magic and Magic skills",
      "The power of Time Magic and Magic skills increases by 50%",
      "Power of Magic Eye skills increases by 50%",
      "Allows chained activation in the order of Time Magic, Magic skills, and Magic skills",
      "Deals massive critical damage with Magic skills to enemies in Slow or Stop status",
      "Absorbs Carnage, Apocalypse, and Galaxy attributes",
    ],
    914 => ["Monster Lord of another world",
      "Maximum HP increases by 50%",
      "Can equip Rapiers",
      "Adds Carnage attribute to physical attacks and penetrates resistance",
      "The power of Carnage attribute attacks increases by 50%.",
      "Enables use of Piercing Sword skills, Dark skills, Tentacle skills, and Magic skills",
      "Power of Piercing Sword skills, Dark skills, Tentacle skills, and Magic skills increases by 50%",
      "Piercing Sword skills, Dark skills, Tentacle skills, and Magic skills activate twice consecutively",
      "Hit count of combo skills in Piercing Sword skills, Dark skills, Tentacle skills, and Magic skills increases by 2",
      "Chain activation possible in the order of Dark skills, Tentacle skills, Magic skills, and Piercing Sword skills",
      "Deals massive critical damage to enemies in Dark Corruption, Slippery, or Bound states with Magic skills and Piercing Sword skills",
    ],
    916 => ["Cosmic heroes",
      "Can equip fist and heavy armor",
      "Adds galaxy attribute to all attacks",
      "The power of Galaxy attribute attacks increases by 50%",
      "Can use Unarmed, Hero skills and Giant skills",
      "The power of Unarmed, Hero skills, and Giant skills increases by 50%",
      "Can chain activate in the order of Unarmed, Giant skills, Hero skills",
      "Unarmed skills power depends solely on ATK",
      "Absorbs Galactic attribute",
    ],
    917 => ["Cybernetic Warrior",
      "Can equip Guns",
      "Can use Gun skills, Makina and Artificial",
      "The power of Gun skills, Machina, and Artificial increases by 50%",
      "The more attacks received in the same turn, the less damage taken",
      "Automatically heals status ailments at the Demise of the turn when inflicted",
      "Nullifies physical attributes and reduces Carnage attribute",
    ],
    918 => ["Dear Neighbor Fox",
      "Can equip Fists",
      "Evasion rate, magic evasion rate and universal evasion rate are abnormally high",
      "Can always use Unarmed",
      "The power of Martial Arts and Hero skills increases by 50%",
      "Duration of All-or-Nothing and Bullet Time increases by 2 turns",
    ],
    919 => ["Fox Blossom Slayer",
      "Can equip swords",
      "Can use Sword skills",
      "The power of Sword skills increases by 50%",
      "SP consumption of Sword Arts is halved",
      "Increases the number of consecutive hits for Sword skills by 3",
      "Deals massive special attack damage to humans",
      "Nullifies enemy Sword Arts, Rapier Arts and Blade Arts and counterattacks",
    ],
    920 => ["Legendary Valkyrie",
      "Can always equip Spears and Heavy Spears",
      "Adds Eternal attribute to physical attacks",
      "Eternal attribute damage increases by 50%",
      "Spear skills and Sacred skills can be used",
      "The power of Spear skills and Holy skills increases by 50% and activates robustly",
      "Allows chain activation in the order of Holy skills, Spear skills, and Spear skills",
      "Deals massive special attack damage to stigmatized enemies with Spear skills and Holy skills",
      "MP/SP consumption when chaining skills is activated is 25%.",
      "Increases the power of chain-activated skills by 50%",
    ],
    921 => ["Successor of Great Phantom Thief M",
      "Can equip Daggers",
      "Dual-wielding possible",
      "Evasion, Physical Evasion, and Universal Evasion increase by 50%",
      "Can use Dagger skills, Thief skills and Slutty skills",
      "The SP consumption of Dagger skills, Thief skills and Slutty skills is halved.",
      "Increases the number of consecutive attacks of dagger skills and Sexcraft skills by 3",
      "Bundle with dagger skills and Sexcraft skills",
      "10x more likely to steal",
    ],
    922 => ["Skilled Butler",
      "Can equip Swords and Magic Swords",
      "Can use Sword skills, Magic Sword, Black magic and Service",
      "The power of Sword skills, Black Magic, and Service increases by 30%",
      "When using Sword skills, Black magic, or Service, ATK or Magic may increase",
    ],
    923 => ["The Great Thief M",
      "Can equip Daggers",
      "Dual-wielding possible",
      "Evasion, Physical Evasion, and Universal Evasion increase by 50%",
      "Can use Dagger skills, Black magic and Thief skills",
      "The power of Dagger skills, Black Magic, and Thief skills increases by 30%",
      "When using Dagger skills, Black magic, or Thief skills, ATK or Magic may increase",
      "Increases the number of consecutive attacks for Dagger skills and Black magic by 3",
      "Plunder with Dagger skills and Black magic",
      "10x more likely to steal",
    ],
    924 => ["Dear Neighbor Fox",
      "Can equip Fists",
      "Evasion rate, magic evasion rate and universal evasion rate are abnormally high",
      "Can always use Unarmed",
      "The power of Martial Arts and Hero skills increases by 50%",
      "Duration of All-or-Nothing and Bullet Time increases by 2 turns",
    ],
    925 => ["Fox Blossom Slayer",
      "Can equip swords",
      "Can use Sword skills",
      "The power of Sword skills increases by 50%",
      "SP consumption of Sword Arts is halved",
      "Increases the number of consecutive hits for Sword skills by 3",
      "Deals massive special attack damage to humans",
      "Nullifies enemy Sword Arts, Rapier Arts and Blade Arts and counterattacks",
    ],
    926 => ["Successor of Great Phantom Thief M",
      "Can equip Daggers",
      "Dual-wielding possible",
      "Evasion, Physical Evasion, and Universal Evasion increase by 50%",
      "Can use Dagger skills, Thief skills and Slutty skills",
      "The SP consumption of Dagger skills, Thief skills and Slutty skills is halved.",
      "Increases the number of consecutive attacks of dagger skills and Sexcraft skills by 3",
      "Bundle with dagger skills and Sexcraft skills",
      "10x more likely to steal",
    ],
    927 => ["Mother of the Fifth Law",
      "Can equip Staves",
      "Adds the Eternal attribute to Holy attribute and greatly enhances power",
      "Can use White Magic, Holy skills and Medical Arts",
      "Power of White Magic, Holy skills, and Medical skills increases by 50%",
      "Chains can be activated in the order of white magic, medicine, holy skills and holy skills",
      "The less HP you have left, the stronger your white magic, holy skills, and medicine will be.",
    ],
    928 => ["Gaihou tea-squeezing doll",
      "Can equip Guns",
      "Dual-wielding possible",
      "Agility, Evasion Rate, Magic Evasion Rate, and Universal Evasion Rate increase by 50%",
      "Extremely low chance of being targeted by enemies",
      "You can use Gun skills, Summoning and Artificial skills",
      "The MP and SP consumption of Gun skills, Summoning and Artificial skills will be reduced to 1/10.",
      "Explodes when incapacitated",
    ],
    998 => ["Self-proclaimed strongest",
      "Can equip Swords, Knight Swords and Great Swords",
      "Can use Sword skills, Spear skills, Fighting and Breath",
      "The power of Sword skills, Spear skills, Unarmed, and Breath increases by 30%",
    ],
    999 => ["Spirit of Chaos",
      "Deal +75% Eternal and Demise damage. Can always use Holy,",
      "Dark, Tentacle, and Chaos skills, dealing +75% damage and",
      "can use Dexterity in place of other stats.",
    ],
  }
end

 